/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_5000;
import snownee.kiwi.customization.shape.AbstractHorizontalShape;
import snownee.kiwi.customization.shape.BakingContext;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;
import snownee.kiwi.util.VoxelUtil;

public record FrontAndTopShape(ShapeGenerator floor, ShapeGenerator ceiling, ShapeGenerator wall) implements ShapeGenerator
{
    public static ShapeGenerator create(ShapeGenerator floor, ShapeGenerator ceiling, ShapeGenerator wall) {
        return new FrontAndTopShape(Child.create(floor), Child.create(ceiling), Child.create(wall));
    }

    @Override
    public class_265 getShape(class_2680 blockState, class_3726 context) {
        class_5000 frontAndTop = (class_5000)blockState.method_11654((class_2769)class_2741.field_23333);
        return switch (frontAndTop.method_26426()) {
            case class_2350.field_11036 -> this.ceiling.getShape(blockState, context);
            case class_2350.field_11033 -> this.floor.getShape(blockState, context);
            default -> this.wall.getShape(blockState, context);
        };
    }

    public record Child(class_265[] shapes) implements AbstractHorizontalShape
    {
        public static ShapeGenerator create(ShapeGenerator northGenerator) {
            class_265 north = ShapeGenerator.Unit.unboxOrThrow(northGenerator);
            if (VoxelUtil.isIsotropicHorizontally(north)) {
                return northGenerator;
            }
            class_265[] shapes = new class_265[4];
            shapes[class_2350.field_11043.method_10161()] = north;
            return new Child(shapes);
        }

        @Override
        public class_2350 getDirection(class_2680 blockState) {
            class_5000 frontAndTop = (class_5000)blockState.method_11654((class_2769)class_2741.field_23333);
            return frontAndTop.method_26428().method_10166().method_10179() ? frontAndTop.method_26428() : frontAndTop.method_26426();
        }
    }

    public record Unbaked(UnbakedShape floor, UnbakedShape ceiling, UnbakedShape wall) implements UnbakedShape
    {
        public static Codec<Unbaked> codec(UnbakedShapeCodec parentCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)parentCodec.fieldOf("floor").forGetter(Unbaked::floor), (App)parentCodec.fieldOf("ceiling").forGetter(Unbaked::ceiling), (App)parentCodec.fieldOf("wall").forGetter(Unbaked::wall)).apply((Applicative)instance, Unbaked::new));
        }

        @Override
        public ShapeGenerator bake(BakingContext context) {
            return FrontAndTopShape.create(this.floor.bake(context), this.ceiling.bake(context), this.wall.bake(context));
        }

        @Override
        public Stream<UnbakedShape> dependencies() {
            return Stream.of(this.floor, this.ceiling, this.wall);
        }
    }
}

