/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.placement;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.duck.KPlayer;
import snownee.kiwi.customization.network.SSyncPlaceCountPacket;
import snownee.kiwi.customization.placement.PlaceChoices;
import snownee.kiwi.customization.placement.PlaceMatchResult;
import snownee.kiwi.customization.placement.PlaceSlot;
import snownee.kiwi.customization.placement.SlotLink;
import snownee.kiwi.util.Util;

public class PlacementSystem {
    private static final Cache<class_1750, PlaceMatchResult> RESULT_CONTEXT = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(100L, TimeUnit.MILLISECONDS).build();

    public static boolean isDebugEnabled(class_1657 player) {
        return player != null && player.method_7337() && player.method_6079().method_31574(class_1802.field_8283);
    }

    public static void removeDebugBlocks(class_1937 level, class_2338 start) {
        class_2338.class_2339 pos = start.method_25503();
        pos.method_10104(class_2350.field_11036, 2);
        while (PlacementSystem.isBlockToRemove(level.method_8320((class_2338)pos))) {
            level.method_8501((class_2338)pos, class_2246.field_10124.method_9564());
            pos.method_10098(class_2350.field_11036);
        }
    }

    private static boolean isBlockToRemove(class_2680 blockState) {
        if (blockState.method_27852(class_2246.field_9987)) {
            return true;
        }
        String namespace = class_7923.field_41175.method_10221((Object)blockState.method_26204()).method_12836();
        return CustomizationHooks.getBlockNamespaces().contains(namespace);
    }

    public static class_2680 onPlace(class_1747 blockItem, class_2680 blockState, class_1750 context) {
        PlaceMatchResult result;
        PlaceMatchResult result2;
        PlaceChoices choices = null;
        KBlockSettings settings = KBlockSettings.of(blockState.method_26204());
        if (settings != null) {
            choices = settings.placeChoices;
        }
        if (choices != null && !choices.alter().isEmpty()) {
            for (PlaceChoices.Alter alter : choices.alter()) {
                class_2680 altered = alter.alter(blockItem, context);
                if (altered == null) continue;
                return PlacementSystem.onPlace(blockItem, altered, context);
            }
        }
        if (PlaceSlot.hasNoSlots(blockState.method_26204())) {
            return blockState;
        }
        if (context.method_8046() && (choices == null || choices.skippable())) {
            return blockState;
        }
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2338.class_2339 mutable = pos.method_25503();
        Map<class_2350, Collection<PlaceSlot>> neighborSlots = class_2350.method_42013().map($ -> PlaceSlot.find(level.method_8320((class_2338)mutable.method_25505((class_2382)pos, $)), $.method_10153())).filter(Predicate.not(Collection::isEmpty)).collect(Collectors.toUnmodifiableMap($ -> ((PlaceSlot)$.iterator().next()).side().method_10153(), Function.identity()));
        if (neighborSlots.isEmpty()) {
            return blockState;
        }
        boolean debug = PlacementSystem.isDebugEnabled(context.method_8036());
        ArrayList results = Lists.newArrayList();
        boolean waterLoggable = blockState.method_28498((class_2769)class_2741.field_12508);
        boolean hasWater = waterLoggable && (Boolean)blockState.method_11654((class_2769)class_2741.field_12508) != false;
        class_2680 noWaterBlockState = hasWater ? (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)) : blockState;
        PlaceMatchResult originalResult = null;
        for (class_2680 possibleState : blockState.method_26204().method_9595().method_11662()) {
            if (waterLoggable && hasWater != (Boolean)possibleState.method_11654((class_2769)class_2741.field_12508)) continue;
            int bonusInterest = 0;
            if (choices != null && (bonusInterest = choices.test(blockState, possibleState)) == Integer.MIN_VALUE || (result2 = PlacementSystem.getPlaceMatchResultAt(possibleState, neighborSlots, bonusInterest)) == null) continue;
            results.add(result2);
            if (possibleState != noWaterBlockState) continue;
            originalResult = result2;
        }
        if (results.isEmpty()) {
            if (debug && !level.field_9236) {
                Kiwi.LOGGER.info("No match");
                level.method_8501((class_2338)mutable.method_10098(class_2350.field_11036), class_2246.field_9987.method_9564());
            }
            return blockState;
        }
        results.sort(null);
        int resultIndex = 0;
        int maxInterest = ((PlaceMatchResult)results.get(0)).interest();
        if (maxInterest > 0 && results.size() > 1 && (result2 = context.method_8036()) instanceof KPlayer) {
            KPlayer player = (KPlayer)((Object)result2);
            int i = 1;
            while (i < results.size() && ((PlaceMatchResult)results.get(i)).interest() >= maxInterest) {
                resultIndex = i++;
            }
            if (resultIndex > 0) {
                resultIndex = player.kiwi$getPlaceCount() % (resultIndex + 1);
            }
        }
        PlaceMatchResult placeMatchResult = result = maxInterest == 0 ? originalResult : (PlaceMatchResult)results.get(resultIndex);
        if (result == null) {
            return blockState;
        }
        if (debug && maxInterest > 0 && !level.field_9236) {
            mutable.method_25505((class_2382)pos, class_2350.field_11036);
            Kiwi.LOGGER.info("Interest: %d".formatted(result.interest()));
            results.forEach($ -> {
                if ($ == result) {
                    return;
                }
                level.method_8501((class_2338)mutable.method_10098(class_2350.field_11036), $.blockState());
                Kiwi.LOGGER.info("Alt Interest: %d : %s".formatted($.interest(), $.blockState()));
            });
        }
        class_2680 resultState = result.blockState();
        for (SlotLink.MatchResult link : result.links()) {
            resultState = link.onLinkFrom().apply(level, pos, resultState);
        }
        RESULT_CONTEXT.put((Object)context, (Object)result);
        return resultState;
    }

    @Nullable
    public static PlaceMatchResult getPlaceMatchResultAt(class_2680 blockState, Map<class_2350, Collection<PlaceSlot>> theirSlotsMap, int bonusInterest) {
        int interest = 0;
        ArrayList results = List.of();
        ArrayList offsets = List.of();
        for (class_2350 side : Util.DIRECTIONS) {
            Collection<PlaceSlot> ourSlots;
            SlotLink.MatchResult result;
            Collection<PlaceSlot> theirSlots = theirSlotsMap.get(side);
            if (theirSlots == null || (result = SlotLink.find(ourSlots = PlaceSlot.find(blockState, side), theirSlots)) == null) continue;
            SlotLink link = result.link();
            interest += link.interest();
            if (results.isEmpty()) {
                results = Lists.newArrayListWithExpectedSize((int)theirSlotsMap.size());
                offsets = Lists.newArrayListWithExpectedSize((int)theirSlotsMap.size());
            }
            results.add((SlotLink.MatchResult)result);
            offsets.add(side.method_10163());
        }
        if (interest < 0) {
            return null;
        }
        return new PlaceMatchResult(blockState, interest + bonusInterest, results, offsets);
    }

    public static void onBlockPlaced(class_1750 context) {
        PlaceMatchResult result = (PlaceMatchResult)RESULT_CONTEXT.getIfPresent((Object)context);
        if (result == null) {
            return;
        }
        RESULT_CONTEXT.invalidate((Object)context);
        class_2338.class_2339 mutable = context.method_8037().method_25503();
        for (int i = 0; i < result.links().size(); ++i) {
            class_2338.class_2339 theirPos = mutable.method_35831((class_2382)context.method_8037(), result.offsets().get(i));
            class_2680 theirState = context.method_8045().method_8320((class_2338)theirPos);
            SlotLink.MatchResult link = result.links().get(i);
            theirState = link.onLinkTo().apply(context.method_8045(), (class_2338)theirPos, theirState);
            context.method_8045().method_8652((class_2338)theirPos, theirState, 11);
        }
        class_1657 player = context.method_8036();
        if (player != null) {
            ((KPlayer)player).kiwi$incrementPlaceCount();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                SSyncPlaceCountPacket.sync(serverPlayer);
            }
        }
    }

    public static void onBlockRemoved(class_1937 level, class_2338 pos, class_2680 oldState, class_2680 newState) {
        if (PlaceSlot.hasNoSlots(oldState.method_26204())) {
            return;
        }
        class_2338.class_2339 mutable = pos.method_25503();
        for (class_2350 direction : Util.DIRECTIONS) {
            SlotLink.MatchResult result;
            class_2680 neighborState = level.method_8320((class_2338)mutable.method_25505((class_2382)pos, direction));
            if (PlaceSlot.hasNoSlots(neighborState.method_26204()) || (result = SlotLink.find(oldState, neighborState, direction)) == null) continue;
            neighborState = result.onUnlinkTo().apply(level, (class_2338)mutable, neighborState);
            level.method_8501((class_2338)mutable, neighborState);
        }
    }
}

