/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.builder.FacingLimitation;
import snownee.kiwi.util.codec.CustomizationCodecs;

public record BlockSpread(Type type, FacingLimitation facingLimitation, int maxDistance) {
    public static final Codec<BlockSpread> CODEC = CustomizationCodecs.withAlternative(RecordCodecBuilder.create(instance -> instance.group((App)Type.CODEC.fieldOf("type").forGetter(BlockSpread::type), (App)class_3542.method_28140(FacingLimitation::values).optionalFieldOf("facing_limit", (Object)FacingLimitation.None).forGetter(BlockSpread::facingLimitation), (App)class_5699.field_33442.optionalFieldOf("max_distance", (Object)16).forGetter(BlockSpread::maxDistance)).apply((Applicative)instance, BlockSpread::create)), Type.CODEC.xmap(type -> BlockSpread.create(type, FacingLimitation.None, 16), BlockSpread::type));
    private static final Interner<BlockSpread> INTERNER = Interners.newStrongInterner();

    public static BlockSpread create(Type type, FacingLimitation facingLimitation, int maxDistance) {
        return (BlockSpread)INTERNER.intern((Object)new BlockSpread(type, facingLimitation, maxDistance));
    }

    public List<class_2338> collect(class_1838 context, Predicate<class_2680> blockPredicate, @Nullable BiConsumer<class_2338, class_2680> blockConsumer) {
        return this.collect((class_1922)context.method_8045(), context.method_8037(), Objects.requireNonNull(context.method_8036()), blockPredicate, blockConsumer);
    }

    public List<class_2338> collect(class_1922 level, class_2338 origin, class_1657 player, Predicate<class_2680> blockPredicate, @Nullable BiConsumer<class_2338, class_2680> blockConsumer) {
        class_2680 originalBlock = level.method_8320(origin);
        if (!blockPredicate.test(originalBlock)) {
            return List.of();
        }
        class_2350 direction = player.method_5735();
        class_2350 originalDirection = null;
        try {
            String s = KBlockUtils.getValueString(originalBlock, "facing");
            originalDirection = class_2350.valueOf((String)s.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception s) {
            // empty catch block
        }
        return switch (this.type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                if (originalDirection == null || this.facingLimitation.test(originalDirection, direction)) {
                    yield this.collectPlane(level, origin, blockPredicate, direction, direction.method_10170(), blockConsumer);
                }
                yield List.of();
            }
            case 1 -> {
                float yRot = player.method_36454() / 90.0f % 1.0f;
                boolean forcedDirection = yRot < 0.15f || yRot > 0.85f;
                List<Object> list = List.of();
                if (originalDirection == null || this.facingLimitation.test(originalDirection, direction)) {
                    list = this.collectPlane(level, origin, blockPredicate, direction, class_2350.field_11036, blockConsumer);
                }
                List<Object> list2 = List.of();
                if (!forcedDirection && (originalDirection == null || this.facingLimitation.test(originalDirection, direction.method_10170()))) {
                    list2 = this.collectPlane(level, origin, blockPredicate, direction.method_10170(), class_2350.field_11036, blockConsumer);
                }
                if (list.size() != list2.size()) {
                    if (list.size() > list2.size()) {
                        yield list;
                    }
                    yield list2;
                }
                yield list;
            }
            case 2 -> this.collectPlaneXYZ(level, origin, blockPredicate, player);
        };
    }

    private List<class_2338> collectPlaneXYZ(class_1922 level, class_2338 origin, Predicate<class_2680> blockPredicate, class_1657 player) {
        throw new NotImplementedException();
    }

    private List<class_2338> collectPlane(class_1922 level, class_2338 origin, Predicate<class_2680> blockPredicate, class_2350 direction, class_2350 direction2, @Nullable BiConsumer<class_2338, class_2680> blockConsumer) {
        ArrayList list = Lists.newArrayList((Object[])new class_2338[]{origin});
        PlacePosIterator iterator = new PlacePosIterator(origin, this.maxDistance, direction, direction2);
        while (iterator.hasNext()) {
            class_2338 next = iterator.next();
            class_2680 blockState = level.method_8320(next);
            if (!blockPredicate.test(blockState)) continue;
            if (blockConsumer != null) {
                blockConsumer.accept(next, blockState);
            }
            list.add(next);
            iterator.add(next, null);
        }
        return list;
    }

    public static enum Type implements class_3542
    {
        PLANE_Y,
        PLANE_XZ,
        PLANE_XYZ;

        public static final Codec<Type> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
        }
    }

    static class PlacePosIterator
    extends PosIterator {
        final class_2350 direction;
        final class_2350 direction2;

        PlacePosIterator(class_2338 origin, int maxDistance, class_2350 direction, class_2350 direction2) {
            super(origin, maxDistance);
            this.direction = direction;
            this.direction2 = direction2;
        }

        @Override
        public Stream<class_2338> listPossibleNext(class_2338 cur, @Nullable class_2338 from) {
            Stream.Builder<class_2338> builder = Stream.builder();
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    class_2338 next;
                    if (i == 0 && j == 0 || (next = cur.method_10079(this.direction, i).method_10079(this.direction2, j)).equals((Object)from)) continue;
                    builder.accept(next);
                }
            }
            return builder.build();
        }
    }

    static abstract class PosIterator
    implements Iterator<class_2338> {
        final LongSet visited = new LongAVLTreeSet();
        final Queue<class_2338> queue = Lists.newLinkedList();
        final class_2338 origin;
        final int maxDistance;

        PosIterator(class_2338 origin, int maxDistance) {
            this.origin = origin;
            this.maxDistance = maxDistance;
        }

        @Override
        public boolean hasNext() {
            if (this.visited.isEmpty()) {
                this.add(this.origin, null);
            }
            return !this.queue.isEmpty();
        }

        @Override
        public class_2338 next() {
            return Objects.requireNonNull(this.queue.poll());
        }

        public void add(class_2338 cur, @Nullable class_2338 from) {
            if (this.origin.method_19455((class_2382)cur) > this.maxDistance) {
                return;
            }
            this.visited.add(cur.method_10063());
            this.listPossibleNext(cur, from).filter(pos -> {
                long l = pos.method_10063();
                if (this.visited.contains(l)) {
                    return false;
                }
                this.visited.add(l);
                return true;
            }).forEach(this.queue::add);
        }

        public abstract Stream<class_2338> listPossibleNext(class_2338 var1, @Nullable class_2338 var2);
    }
}

