/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.family;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.block.family.BlockFamilyInferrer;
import snownee.kiwi.customization.block.family.StonecutterRecipeMaker;
import snownee.kiwi.util.KHolder;
import snownee.kiwi.util.resource.OneTimeLoader;

public class BlockFamilies {
    private static ImmutableListMultimap<class_1792, KHolder<BlockFamily>> byItem = ImmutableListMultimap.of();
    private static ImmutableList<KHolder<BlockFamily>> fromResources = ImmutableList.of();
    private static ImmutableMap<class_2960, KHolder<BlockFamily>> byId = ImmutableMap.of();
    private static ImmutableListMultimap<class_1792, KHolder<BlockFamily>> byStonecutterSource = ImmutableListMultimap.of();

    public static Collection<KHolder<BlockFamily>> find(class_1792 item) {
        if (item == class_1802.field_8162) {
            return List.of();
        }
        return byItem.get((Object)item);
    }

    public static List<KHolder<BlockFamily>> findQuickSwitch(class_1792 item, boolean creative) {
        Stream<KHolder<BlockFamily>> stream = BlockFamilies.find(item).stream();
        stream = creative ? stream.filter(f -> ((BlockFamily)f.value()).switchAttrs().enabled()) : stream.filter(f -> ((BlockFamily)f.value()).switchAttrs().enabled() && !((BlockFamily)f.value()).switchAttrs().creativeOnly());
        return stream.toList();
    }

    public static Collection<KHolder<BlockFamily>> findByStonecutterSource(class_1792 item) {
        return byStonecutterSource.get((Object)item);
    }

    public static void reloadResources(class_3300 resourceManager, OneTimeLoader.Context context) {
        Map<class_2960, BlockFamily> families = OneTimeLoader.load(resourceManager, "kiwi/family", BlockFamily.DIRECT_CODEC, context);
        fromResources = (ImmutableList)families.entrySet().stream().map(e -> new KHolder<BlockFamily>((class_2960)e.getKey(), (BlockFamily)e.getValue())).collect(ImmutableList.toImmutableList());
        BlockFamilies.reloadComplete(List::of);
    }

    public static int reloadTags() {
        if (CustomizationHooks.kswitch) {
            BlockFamilies.reloadComplete(new BlockFamilyInferrer()::generate);
        }
        return byId.size();
    }

    private static void reloadComplete(Supplier<Collection<KHolder<BlockFamily>>> additionalSupplier) {
        byId = ImmutableMap.of();
        byItem = ImmutableListMultimap.of();
        byStonecutterSource = ImmutableListMultimap.of();
        Collection<KHolder<BlockFamily>> additional = additionalSupplier.get();
        HashMap byIdBuilder = Maps.newHashMapWithExpectedSize((int)(fromResources.size() + additional.size()));
        ImmutableListMultimap.Builder byItemBuilder = ImmutableListMultimap.builder();
        ImmutableListMultimap.Builder byStonecutterBuilder = ImmutableListMultimap.builder();
        for (KHolder family : Iterables.concat(fromResources, additional)) {
            KHolder old = byIdBuilder.putIfAbsent(family.key(), family);
            if (old != null) {
                Kiwi.LOGGER.error("Duplicate family {}", (Object)family);
                continue;
            }
            for (class_6880.class_6883<class_1792> item : ((BlockFamily)family.value()).itemHolders()) {
                byItemBuilder.put((Object)((class_1792)item.comp_349()), (Object)family);
            }
            Optional<class_6880.class_6883<class_1792>> stonecutterSource = ((BlockFamily)family.value()).stonecutterSource();
            if (!stonecutterSource.isPresent()) continue;
            byStonecutterBuilder.put((Object)((class_1792)stonecutterSource.get().comp_349()), (Object)family);
        }
        byId = ImmutableMap.copyOf((Map)byIdBuilder);
        byItem = byItemBuilder.build();
        byStonecutterSource = byStonecutterBuilder.build();
        StonecutterRecipeMaker.invalidateCache();
    }

    @Nullable
    public static BlockFamily get(class_2960 id) {
        KHolder holder = (KHolder)byId.get((Object)id);
        return holder == null ? null : (BlockFamily)holder.value();
    }

    public static Collection<KHolder<BlockFamily>> all() {
        return byId.values();
    }

    public static boolean isEmpty() {
        return byId.isEmpty() && fromResources.isEmpty();
    }

    public static float getConvertRatio(class_1792 item) {
        class_2248 block = class_2248.method_9503((class_1792)item);
        if (block == class_2246.field_10124) {
            return 1.0f;
        }
        class_6880 holder = class_7923.field_41175.method_47983((Object)block);
        if (holder.method_40220(class_3481.field_15469)) {
            return 0.5f;
        }
        if (holder.method_40220(class_3481.field_15495)) {
            return 2.0f;
        }
        if (holder.method_40220(class_3481.field_15487)) {
            return 3.0f;
        }
        if (holder.method_40220(class_3481.field_25147)) {
            return 4.0f;
        }
        if (holder.method_40220(class_3481.field_24076)) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Nullable
    public static class_2960 getKey(BlockFamily family) {
        for (KHolder<BlockFamily> holder : BlockFamilies.all()) {
            if (holder.value() != family) continue;
            return holder.key();
        }
        return null;
    }
}

