/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.StringProperty;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.loader.KBlockComponents;
import snownee.kiwi.util.codec.CustomizationCodecs;
import snownee.kiwi.util.codec.JavaOps;

public record SimplePropertiesComponent(boolean useShapeForLightOcclusion, List<Pair<class_2769<?>, String>> properties) implements KBlockComponent
{
    private static final Interner<SimplePropertiesComponent> INTERNER = Interners.newStrongInterner();
    public static final Codec<Pair<class_2769<?>, String>> SINGLE_CODEC = new Codec<Pair<class_2769<?>, String>>(){
        private static final Map<String, class_2350> DIRECTION_STRINGS = class_2350.method_42013().collect(Collectors.toUnmodifiableMap(class_3542::method_15434, Function.identity()));

        public <T> DataResult<Pair<Pair<class_2769<?>, String>, T>> decode(DynamicOps<T> ops, T input) {
            String defaultString;
            Object property;
            DataResult mapValue = ops.getMap(input);
            if (mapValue.error().isPresent()) {
                return DataResult.error(() -> ((DataResult.PartialResult)((DataResult.PartialResult)mapValue.error().get())).message());
            }
            MapLike map = (MapLike)mapValue.result().orElseThrow();
            DataResult commonValue = ops.getStringValue(map.get("common"));
            Object defaultValue = ops.convertTo((DynamicOps)JavaOps.INSTANCE, map.get("default"));
            List values = Codec.STRING.listOf().parse(ops, map.get("values")).result().orElse(null);
            if (values != null && values.size() < 2) {
                return DataResult.error(() -> "Invalid values for property: " + String.valueOf(values));
            }
            if (defaultValue == null) {
                if (values == null) {
                    return DataResult.error(() -> "Missing default value for property");
                }
                defaultValue = values.get(0);
            }
            if (commonValue.result().isPresent()) {
                String s = (String)commonValue.result().get();
                property = (class_2769)KBlockUtils.COMMON_PROPERTIES.get((Object)s);
                if (property == null) {
                    return DataResult.error(() -> "Unknown common property: " + s);
                }
            } else {
                String name = (String)class_156.method_47526((DataResult)ops.getStringValue(map.get("name")), $ -> new IllegalStateException("Missing name for property"));
                if (defaultValue instanceof Integer) {
                    int min = ((Number)class_156.method_47526((DataResult)ops.getNumberValue(map.get("min")), $ -> new IllegalStateException("Missing min for integer property"))).intValue();
                    int max = ((Number)class_156.method_47526((DataResult)ops.getNumberValue(map.get("max")), $ -> new IllegalStateException("Missing max for integer property"))).intValue();
                    property = class_2758.method_11867((String)name, (int)min, (int)max);
                } else if (defaultValue instanceof Boolean) {
                    property = class_2746.method_11825((String)name);
                } else if (values != null && defaultValue instanceof String) {
                    String s = (String)defaultValue;
                    property = DIRECTION_STRINGS.containsKey(s) && DIRECTION_STRINGS.keySet().containsAll(values) ? (values.size() == DIRECTION_STRINGS.size() ? class_2753.method_35305((String)name) : class_2753.method_11845((String)name, (class_2350[])((class_2350[])values.stream().map(DIRECTION_STRINGS::get).toArray(class_2350[]::new)))) : new StringProperty(name, values);
                } else {
                    String msg = "Unsupported default value type: " + String.valueOf(defaultValue.getClass());
                    return DataResult.error(() -> msg);
                }
                property = KBlockUtils.internProperty(property);
            }
            try {
                defaultString = KBlockUtils.getNameByValue(property, defaultValue);
                Preconditions.checkArgument((boolean)property.method_11900(defaultString).isPresent());
            }
            catch (Exception e) {
                return DataResult.error(() -> "Invalid default value for property: " + e.getMessage());
            }
            return DataResult.success((Object)Pair.of((Object)Pair.of((Object)property, (Object)defaultString), (Object)ops.empty()));
        }

        public <T> DataResult<T> encode(Pair<class_2769<?>, String> input, DynamicOps<T> ops, T prefix) {
            Object defaultValue;
            RecordBuilder mapBuilder = ops.mapBuilder();
            class_2769 property = (class_2769)input.getFirst();
            String s = (String)KBlockUtils.COMMON_PROPERTIES.inverse().get((Object)property);
            List values = List.of();
            if (s == null) {
                mapBuilder.add("name", ops.createString(property.method_11899()));
                if (property instanceof class_2758) {
                    class_2758 integerProperty = (class_2758)property;
                    mapBuilder.add("min", ops.createInt(integerProperty.field_37655));
                    mapBuilder.add("max", ops.createInt(integerProperty.field_37656));
                } else if (property instanceof class_2754 || property instanceof StringProperty) {
                    values = property.method_11898().stream().map($ -> KBlockUtils.getNameByValue(property, $)).collect(Collectors.toCollection(ArrayList::new));
                } else if (!(property instanceof class_2746)) {
                    return DataResult.error(() -> "Unsupported property type: " + String.valueOf(property));
                }
            } else {
                mapBuilder.add("common", ops.createString(s));
            }
            if (property instanceof class_2758) {
                class_2758 integerProperty = (class_2758)property;
                defaultValue = integerProperty.method_11900((String)input.getSecond()).map(arg_0 -> ops.createInt(arg_0)).orElse(null);
            } else if (property instanceof class_2746) {
                class_2746 booleanProperty = (class_2746)property;
                defaultValue = booleanProperty.method_11900((String)input.getSecond()).map(arg_0 -> ops.createBoolean(arg_0)).orElse(null);
            } else {
                Object object = defaultValue = property.method_11900((String)input.getSecond()).isPresent() ? ops.createString((String)input.getSecond()) : null;
            }
            if (defaultValue == null) {
                return DataResult.error(() -> "Invalid value %s for property %s".formatted(input.getSecond(), property.method_11899()));
            }
            if (!values.isEmpty()) {
                values.remove(input.getSecond());
                values.add(0, (String)input.getSecond());
                mapBuilder.add("values", ops.createList(values.stream().map(arg_0 -> ops.createString(arg_0))));
            } else {
                mapBuilder.add("default", defaultValue);
            }
            return mapBuilder.build(prefix);
        }
    };
    public static final MapCodec<SimplePropertiesComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("shape_for_light_occlusion", (Object)false).forGetter(SimplePropertiesComponent::useShapeForLightOcclusion), (App)class_5699.method_36973(CustomizationCodecs.compactList(SINGLE_CODEC)).fieldOf("properties").forGetter(SimplePropertiesComponent::properties)).apply((Applicative)instance, ($1, $2) -> (SimplePropertiesComponent)INTERNER.intern((Object)new SimplePropertiesComponent((boolean)$1, (List<Pair<class_2769<?>, String>>)$2))));

    @Override
    public KBlockComponent.Type<?> type() {
        return KBlockComponents.SIMPLE_PROPERTIES.getOrCreate();
    }

    @Override
    public void injectProperties(class_2248 block, class_2689.class_2690<class_2248, class_2680> builder) {
        for (Pair<class_2769<?>, String> pair : this.properties) {
            builder.method_11667(new class_2769[]{(class_2769)pair.getFirst()});
        }
    }

    @Override
    public class_2680 registerDefaultState(class_2680 state) {
        for (Pair<class_2769<?>, String> pair : this.properties) {
            state = KBlockUtils.setValueByString(state, ((class_2769)pair.getFirst()).method_11899(), (String)pair.getSecond());
        }
        return state;
    }

    @Override
    public boolean useShapeForLightOcclusion(class_2680 pState) {
        return this.useShapeForLightOcclusion;
    }
}

