/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3883;
import net.minecraft.class_591;
import net.minecraft.class_742;
import snownee.kiwi.Kiwi;
import snownee.kiwi.contributor.ITierProvider;
import snownee.kiwi.contributor.client.CosmeticLayer;

public class JsonTierProvider
implements ITierProvider {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private final String author;
    private ImmutableSetMultimap<String, String> contributors = ImmutableSetMultimap.of();
    protected ImmutableSet<String> superusers = ImmutableSet.of();
    private final Supplier<List<String>> urlProvider;

    public JsonTierProvider(String author, Supplier<List<String>> urlProvider) {
        this.author = author;
        this.urlProvider = urlProvider;
        this.refresh();
    }

    public boolean load(String url) {
        boolean bl;
        InputStreamReader reader = new InputStreamReader(new URL(url).openStream());
        try {
            Map map = (Map)GSON.fromJson((Reader)reader, Map.class);
            this.superusers = map.containsKey("*") ? ImmutableSet.copyOf((Collection)((Collection)map.get("*"))) : ImmutableSet.of((Object)this.getAuthor());
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            map.forEach((reward, users) -> {
                if ("*".equals(reward)) {
                    return;
                }
                users.forEach(user -> builder.put(user, reward));
            });
            this.contributors = builder.build();
            Kiwi.LOGGER.debug("Successfully loaded {} contributors", (Object)this.contributors.keySet().size());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Kiwi.LOGGER.debug("Failed to load contributors from %s".formatted(url), (Throwable)e);
                return e instanceof UnknownHostException;
            }
        }
        reader.close();
        return bl;
    }

    @Override
    public CompletableFuture<Void> refresh() {
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        Thread thread = new Thread(() -> {
            List<String> url = this.urlProvider.get();
            for (int tried = 0; tried < url.size() && !this.load(url.get(tried)); ++tried) {
            }
            cf.complete(null);
        }, String.format("[Kiwi > %s] Loading Contributors", this.author));
        thread.setDaemon(true);
        thread.start();
        return cf;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public Set<String> getPlayerTiers(String playerName) {
        return this.superusers.contains((Object)playerName) ? this.getTiers() : this.contributors.get((Object)playerName);
    }

    @Override
    public Set<String> getTiers() {
        return this.contributors.keySet();
    }

    @Override
    public List<String> getRenderableTiers() {
        return Collections.EMPTY_LIST;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public CosmeticLayer createRenderer(class_3883<class_742, class_591<class_742>> entityRenderer, String tier) {
        return null;
    }
}

