/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structure;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.entity.monster.dungeon.boss.ValkyrieQueen;
import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.LargeAercloudChunk;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverBossRoom;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverDungeonBuilder;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverTemplePiece;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_4651;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6624;
import net.minecraft.class_6626;
import net.minecraft.class_7151;

public class SilverDungeonStructure
extends class_3195 {
    public static final Codec<SilverDungeonStructure> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)SilverDungeonStructure.method_42697((RecordCodecBuilder.Instance)builder), (App)Codec.INT.fieldOf("maxY").forGetter(o -> o.maxY), (App)Codec.INT.fieldOf("belowTerrain").forGetter(o -> o.belowTerrain), (App)Codec.INT.fieldOf("aboveTerrain").forGetter(o -> o.aboveTerrain), (App)Codec.INT.fieldOf("minY").forGetter(o -> o.minY), (App)Codec.INT.fieldOf("rangeY").forGetter(o -> o.rangeY)).apply((Applicative)builder, SilverDungeonStructure::new));
    private final int maxY;
    private final int belowTerrain;
    private final int aboveTerrain;
    private final int minY;
    private final int rangeY;

    public SilverDungeonStructure(class_3195.class_7302 settings, int maxY, int belowTerrain, int aboveTerrain, int minY, int rangeY) {
        super(settings);
        this.maxY = maxY;
        this.belowTerrain = belowTerrain;
        this.aboveTerrain = aboveTerrain;
        this.minY = minY;
        this.rangeY = rangeY;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        int height;
        class_2794 chunkGenerator = context.comp_562();
        class_5539 heightAccessor = context.comp_569();
        class_1923 chunkPos = context.comp_568();
        class_2919 random = context.comp_566();
        int x = chunkPos.method_33940();
        int z = chunkPos.method_33942();
        int maxHeight = this.maxY;
        int minHeight = chunkGenerator.method_16397(x, z, class_2902.class_2903.field_13194, heightAccessor, context.comp_564()) - this.belowTerrain;
        if (random.method_43048(5) < 3) {
            height = minHeight + this.aboveTerrain;
            if (height < maxHeight) {
                height += random.method_43048(maxHeight - height);
            }
        } else {
            height = Math.max(minHeight, this.minY + random.method_43048(this.rangeY));
        }
        class_2338 blockpos = new class_2338(chunkPos.method_33940(), height, chunkPos.method_33942());
        return Optional.of(new class_3195.class_7150(blockpos, piecesBuilder -> this.generatePieces((class_6626)piecesBuilder, context, blockpos)));
    }

    private void generatePieces(class_6626 builder, class_3195.class_7149 context, class_2338 input) {
        class_2919 randomSource = context.comp_566();
        class_2470 rotation = class_2470.method_16548((class_5819)randomSource);
        class_2350 direction = rotation.method_10503(class_2350.field_11035);
        class_3485 manager = context.comp_565();
        class_2338 elevatedPos = input.method_10079(rotation.method_10503(class_2350.field_11043), 54).method_10079(rotation.method_10503(class_2350.field_11039), 15);
        this.buildCloudBed(builder, (class_5819)randomSource, elevatedPos, direction);
        SilverTemplePiece rear = new SilverTemplePiece(manager, "rear", elevatedPos, rotation);
        builder.method_35462((class_3443)rear);
        class_2338 bossRoomPos = elevatedPos.method_10069((direction.method_10148() + direction.method_10165()) * 5, 3, (direction.method_10165() - direction.method_10148()) * 5);
        SilverBossRoom bossRoom = new SilverBossRoom(manager, "boss_room", bossRoomPos, rotation);
        builder.method_35462((class_3443)bossRoom);
        int xOffset = direction.method_10148() * rear.method_14935().method_35414();
        int zOffset = direction.method_10165() * rear.method_14935().method_14663();
        class_2338 offsetPos = elevatedPos.method_10069(xOffset, 0, zOffset);
        SilverTemplePiece exterior = new SilverTemplePiece(manager, "skeleton", offsetPos, rotation);
        builder.method_35462((class_3443)exterior);
        SilverDungeonBuilder grid = new SilverDungeonBuilder((class_5819)randomSource, 3, 3, 3);
        grid.assembleDungeon(builder, manager, offsetPos, rotation, direction);
    }

    private void buildCloudBed(class_6626 builder, class_5819 random, class_2338 origin, class_2350 direction) {
        int zBounds;
        int xBounds;
        class_2338.class_2339 offset = origin.method_25503().method_10100(0, -1, 0);
        switch (direction) {
            case field_11035: {
                xBounds = 50;
                zBounds = 77;
                offset.method_10100(-10, 0, -11);
                break;
            }
            case field_11043: {
                xBounds = 50;
                zBounds = 77;
                offset.method_10100(-40, 0, -66);
                break;
            }
            case field_11034: {
                xBounds = 77;
                zBounds = 50;
                offset.method_10100(-11, 0, -40);
                break;
            }
            case field_11039: {
                xBounds = 77;
                zBounds = 50;
                offset.method_10100(-66, 0, -10);
                break;
            }
            default: {
                xBounds = 77;
                zBounds = 50;
            }
        }
        HashMap<class_1923, Set> chunks = new HashMap<class_1923, Set>();
        HashSet<class_2338> positions = new HashSet<class_2338>();
        for (int tries = 0; tries < 100; ++tries) {
            int x = offset.method_10263() + random.method_43048(xBounds);
            int y = offset.method_10264();
            int z = offset.method_10260() + random.method_43048(zBounds);
            int xTendency = random.method_43048(3) - 1;
            int zTendency = random.method_43048(3) - 1;
            for (int n = 0; n < 10; ++n) {
                x += random.method_43048(3) - 1 + xTendency;
                if (random.method_43056()) {
                    y += random.method_43048(3) - 1;
                }
                z += random.method_43048(3) - 1 + zTendency;
                for (int x1 = x; x1 < x + random.method_43048(4) + 3; ++x1) {
                    for (int y1 = y; y1 < y + random.method_43048(1) + 2; ++y1) {
                        for (int z1 = z; z1 < z + random.method_43048(4) + 3; ++z1) {
                            if (Math.abs(x1 - x) + Math.abs(y1 - y) + Math.abs(z1 - z) >= 4 + random.method_43048(2)) continue;
                            class_2338 newPosition = new class_2338(x1, y1, z1);
                            positions.add(newPosition);
                            chunks.computeIfAbsent(new class_1923(newPosition), pos -> new HashSet());
                        }
                    }
                }
            }
        }
        chunks.forEach((chunkPos, blockPosSet) -> {
            blockPosSet.addAll(positions.stream().filter(pos -> new class_1923(pos).equals(chunkPos)).toList());
            builder.method_35462((class_3443)new LargeAercloudChunk((Set<class_2338>)blockPosSet, (class_4651)class_4651.method_38433((class_2680)((class_2680)((class_2248)AetherBlocks.COLD_AERCLOUD.get()).method_9564().method_11657((class_2769)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)))), new class_3341(chunkPos.method_8326(), origin.method_10264(), chunkPos.method_8328(), chunkPos.method_8327(), origin.method_10264(), chunkPos.method_8329()), direction));
        });
    }

    public void method_38694(class_5281 level, class_5138 structureManager, class_2794 generator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_6624 pieces) {
        class_238 chunkBounds = new class_238((double)chunkBox.method_35415(), (double)chunkBox.method_35416(), (double)chunkBox.method_35417(), (double)chunkBox.method_35418(), (double)chunkBox.method_35419(), (double)chunkBox.method_35420());
        level.method_18467(ValkyrieQueen.class, chunkBounds).forEach(queen -> {
            class_3341 box = pieces.method_38712();
            class_238 dungeonBounds = new class_238((double)box.method_35415(), (double)box.method_35416(), (double)box.method_35417(), (double)(box.method_35418() + 1), (double)(box.method_35419() + 1), (double)(box.method_35420() + 1));
            queen.setDungeonBounds(dungeonBounds);
        });
    }

    public class_7151<?> method_41618() {
        return (class_7151)AetherStructureTypes.SILVER_DUNGEON.get();
    }
}

