/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.serializer;

import com.aetherteam.aether.recipe.recipes.ban.AbstractPlacementBanRecipe;
import com.aetherteam.nitrogen.recipe.BlockStateIngredient;
import com.aetherteam.nitrogen.recipe.BlockStateRecipeUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.class_1865;
import net.minecraft.class_1959;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class PlacementBanRecipeSerializer<T, S extends Predicate<T>, F extends AbstractPlacementBanRecipe<T, S>>
implements class_1865<F> {
    private final CookieBaker<T, S, F> factory;

    public PlacementBanRecipeSerializer(CookieBaker<T, S, F> factory) {
        this.factory = factory;
    }

    public F fromJson(class_2960 id, JsonObject json) {
        Pair biomeRecipeData = BlockStateRecipeUtil.biomeRecipeDataFromJson((JsonObject)json);
        class_5321 biomeKey = (class_5321)biomeRecipeData.getLeft();
        class_6862 biomeTag = (class_6862)biomeRecipeData.getRight();
        BlockStateIngredient bypassBlock = BlockStateIngredient.EMPTY;
        if (json.has("bypass")) {
            boolean isBypassArray = class_3518.method_15264((JsonObject)json, (String)"bypass");
            JsonArray bypassElement = isBypassArray ? class_3518.method_15261((JsonObject)json, (String)"bypass") : class_3518.method_15296((JsonObject)json, (String)"bypass");
            bypassBlock = BlockStateIngredient.fromJson((JsonElement)bypassElement);
        }
        return this.factory.create(id, (class_5321<class_1959>)biomeKey, (class_6862<class_1959>)biomeTag, bypassBlock);
    }

    @Nullable
    public F fromNetwork(class_2960 id, class_2540 buffer) {
        class_5321 biomeKey = BlockStateRecipeUtil.readBiomeKey((class_2540)buffer);
        class_6862 biomeTag = BlockStateRecipeUtil.readBiomeTag((class_2540)buffer);
        BlockStateIngredient bypassBlock = BlockStateIngredient.fromNetwork((class_2540)buffer);
        return this.factory.create(id, (class_5321<class_1959>)biomeKey, (class_6862<class_1959>)biomeTag, bypassBlock);
    }

    public void toNetwork(class_2540 buffer, F recipe) {
        BlockStateRecipeUtil.writeBiomeKey((class_2540)buffer, ((AbstractPlacementBanRecipe)recipe).getBiomeKey());
        BlockStateRecipeUtil.writeBiomeTag((class_2540)buffer, ((AbstractPlacementBanRecipe)recipe).getBiomeTag());
        ((AbstractPlacementBanRecipe)recipe).getBypassBlock().toNetwork(buffer);
    }

    public static interface CookieBaker<T, S extends Predicate<T>, F extends AbstractPlacementBanRecipe<T, S>> {
        public F create(class_2960 var1, @Nullable class_5321<class_1959> var2, @Nullable class_6862<class_1959> var3, BlockStateIngredient var4);
    }
}

