/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.mixin;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.WorldDisplayHelper;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.item.accessories.cape.CapeItem;
import com.aetherteam.aether.item.accessories.gloves.GlovesItem;
import com.aetherteam.aether.item.accessories.pendant.PendantItem;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_526;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class AetherMixinHooks {
    private static final class_2960 SWUFF_CAPE_LOCATION = new class_2960("aether", "textures/models/accessory/capes/swuff_accessory.png");

    public static boolean isCapeVisible(class_1309 livingEntity) {
        Optional<SlotEntryReference> slotResult = EquipmentUtil.findFirstCurio(livingEntity, item -> item.method_7909() instanceof CapeItem);
        if (slotResult.isPresent()) {
            AccessoriesContainer stacksHandler;
            SlotType identifier = slotResult.get().reference().type();
            int id = slotResult.get().reference().slot();
            AccessoriesCapability itemHandler = livingEntity.accessoriesCapability();
            if (itemHandler != null && (stacksHandler = itemHandler.getContainer(identifier)) != null) {
                return stacksHandler.shouldRender(id);
            }
        }
        return false;
    }

    public static class_2960 getCapeTexture(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof CapeItem) {
            CapeItem capeItem = (CapeItem)class_17922;
            if (stack.method_7964().getString().equalsIgnoreCase("swuff_'s cape")) {
                return SWUFF_CAPE_LOCATION;
            }
            return capeItem.getCapeTexture();
        }
        return null;
    }

    public static boolean canUnlockLevel(Path basePath) {
        if (class_310.method_1551().field_1755 != null && class_310.method_1551().field_1755 instanceof class_526) {
            return basePath.getFileName().toString().equals(WorldDisplayHelper.getLevelSummary().method_248());
        }
        return false;
    }

    public static boolean canReplaceCurrentAccessory(class_1308 mob, class_1799 candidate, class_1799 existing) {
        if (class_1890.method_8224((class_1799)existing)) {
            return false;
        }
        class_1792 class_17922 = candidate.method_7909();
        if (class_17922 instanceof GlovesItem) {
            GlovesItem candidateGloves = (GlovesItem)class_17922;
            class_1792 class_17923 = existing.method_7909();
            if (!(class_17923 instanceof GlovesItem)) {
                return true;
            }
            GlovesItem existingGloves = (GlovesItem)class_17923;
            if (candidateGloves.getDamage() != existingGloves.getDamage()) {
                return candidateGloves.getDamage() > existingGloves.getDamage();
            }
            return mob.method_26320(candidate, existing);
        }
        if (candidate.method_7909() instanceof PendantItem) {
            if (!(existing.method_7909() instanceof PendantItem)) {
                return true;
            }
            return mob.method_26320(candidate, existing);
        }
        return false;
    }

    public static String getIdentifierForItem(class_1309 livingEntity, class_1799 stack) {
        if (((Boolean)AetherConfig.COMMON.use_curios_menu.get()).booleanValue()) {
            class_6862 glovesTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Accessories.of((String)"hands"));
            class_6862 pendantTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Accessories.of((String)"necklace"));
            if (stack.method_31573(glovesTag)) {
                return "hands";
            }
            if (stack.method_31573(pendantTag) && (livingEntity.method_5864() == class_1299.field_22281 || livingEntity.method_5864() == class_1299.field_6050)) {
                return "necklace";
            }
        } else {
            if (stack.method_31573(AetherTags.Items.AETHER_GLOVES)) {
                return "aether_gloves";
            }
            if (stack.method_31573(AetherTags.Items.AETHER_PENDANT) && (livingEntity.method_5864() == class_1299.field_22281 || livingEntity.method_5864() == class_1299.field_6050)) {
                return "aether_pendant";
            }
        }
        return "";
    }

    public static class_1799 getItemByIdentifier(class_1309 livingEntity, String identifier) {
        AccessoriesContainer container;
        AccessoriesCapability handler = livingEntity.accessoriesCapability();
        SlotType type = SlotTypeLoader.getSlotType((class_1309)livingEntity, (String)identifier);
        if (handler != null && (container = handler.getContainer(type)) != null) {
            return container.getAccessories().method_5438(0);
        }
        return class_1799.field_8037;
    }

    public static void setItemByIdentifier(class_1309 livingEntity, class_1799 itemStack, String identifier) {
        AccessoriesContainer container;
        AccessoriesCapability handler = livingEntity.accessoriesCapability();
        SlotType type = SlotTypeLoader.getSlotType((class_1309)livingEntity, (String)identifier);
        if (handler != null && (container = handler.getContainer(type)) != null) {
            container.getAccessories().method_5447(0, itemStack);
        }
    }
}

