/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.rei.categories.item;

import com.aetherteam.aether.recipe.recipes.item.AbstractAetherCookingRecipe;
import com.aetherteam.aether.recipe.recipes.item.AltarRepairRecipe;
import com.aetherteam.aether.recipe.recipes.item.IncubationRecipe;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_2960;

public class AetherCookingRecipeDisplay<T extends class_1860<?>>
extends BasicDisplay {
    private final CategoryIdentifier<?> identifier;
    private final float experience;
    private final int cookingTime;
    private final boolean isIncubation;

    public AetherCookingRecipeDisplay(CategoryIdentifier<AetherCookingRecipeDisplay<T>> identifier, List<EntryIngredient> inputs, List<EntryIngredient> outputs, float experience, int cookingTime, boolean isIncubation, Optional<class_2960> location) {
        super(inputs, outputs, location);
        this.identifier = identifier;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.isIncubation = isIncubation;
    }

    public static <T extends class_1860<?>> AetherCookingRecipeDisplay<T> of(CategoryIdentifier<AetherCookingRecipeDisplay<T>> categoryIdentifier, T recipe) {
        int cookingTime = 0;
        float experience = 0.0f;
        if (recipe instanceof class_1874) {
            class_1874 cookingRecipe = (class_1874)recipe;
            cookingTime = cookingRecipe.method_8167();
            experience = cookingRecipe.method_8171();
        } else if (recipe instanceof IncubationRecipe) {
            IncubationRecipe incubationRecipe = (IncubationRecipe)recipe;
            cookingTime = incubationRecipe.getIncubationTime();
        }
        return new AetherCookingRecipeDisplay<T>(categoryIdentifier, AetherCookingRecipeDisplay.getInput(recipe), AetherCookingRecipeDisplay.getOutput(recipe), experience, cookingTime, recipe instanceof IncubationRecipe, Optional.of(recipe.method_8114()));
    }

    private static List<EntryIngredient> getInput(class_1860<?> recipe) {
        if (recipe instanceof AltarRepairRecipe) {
            class_1799 damagedItem = ((class_1856)recipe.method_8117().get(0)).method_8105()[0].method_7972();
            damagedItem.method_7974(damagedItem.method_7936() * 3 / 4);
            return List.of(EntryIngredients.of((class_1799)damagedItem));
        }
        return List.of(EntryIngredients.ofIngredient((class_1856)((class_1856)recipe.method_8117().get(0))));
    }

    private static List<EntryIngredient> getOutput(class_1860<?> recipe) {
        List<EntryIngredient> list;
        if (recipe instanceof AbstractAetherCookingRecipe) {
            AbstractAetherCookingRecipe cookingRecipe = (AbstractAetherCookingRecipe)recipe;
            list = List.of(EntryIngredients.of((class_1799)cookingRecipe.getResult()));
        } else {
            list = List.of();
        }
        return list;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public boolean isIncubation() {
        return this.isIncubation;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.identifier;
    }

    public static <T extends class_1860<?>> DisplaySerializer<AetherCookingRecipeDisplay<T>> serializer(CategoryIdentifier<AetherCookingRecipeDisplay<T>> identifier) {
        return BasicDisplay.Serializer.of((input, output, location1, tag) -> {
            float experience = tag.method_10583("experience");
            int cookingTime = tag.method_10550("cookingTime");
            boolean isIncubation = tag.method_10577("isIncubation");
            return new AetherCookingRecipeDisplay(identifier, input, output, experience, cookingTime, isIncubation, location1);
        }, (display, tag) -> {
            tag.method_10548("experience", display.experience);
            tag.method_10569("cookingTime", display.cookingTime);
            tag.method_10556("isIncubation", display.isIncubation);
        });
    }
}

