/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.capability.player.AetherPlayerCapability;
import com.aetherteam.aether.capability.time.AetherTime;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class CapabilityHooks {

    public static class AetherTimeHooks {
        public static void login(class_1657 player) {
            AetherTimeHooks.syncAetherTime(player);
        }

        public static void changeDimension(class_1657 player) {
            AetherTimeHooks.syncAetherTime(player);
        }

        public static void respawn(class_1657 player) {
            AetherTimeHooks.syncAetherTime(player);
        }

        private static void syncAetherTime(class_1657 player) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (player.method_37908().method_8597().comp_655().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.method_29177())) {
                    AetherTime.get(serverPlayer.method_37908()).ifPresent(aetherTime -> aetherTime.updateEternalDay(serverPlayer));
                }
            }
        }
    }

    public static class AetherPlayerHooks {
        public static void login(class_1657 player) {
            AetherPlayer.getOptional(player).ifPresent(AetherPlayer::onLogin);
        }

        public static void logout(class_1657 player) {
            AetherPlayer.getOptional(player).ifPresent(AetherPlayer::onLogout);
        }

        public static void joinLevel(class_1297 entity) {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                AetherPlayer.getOptional(player).ifPresent(AetherPlayer::onJoinLevel);
            }
        }

        public static void update(class_1309 entity) {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                AetherPlayer.getOptional(player).ifPresent(AetherPlayer::onUpdate);
            }
        }

        public static void clone(class_1657 originalPlayer, class_1657 newPlayer, boolean wasDeath) {
            AetherPlayer originalAetherPlayer = AetherPlayer.getOptional(originalPlayer).orElseThrow(() -> new IllegalStateException("Player " + String.valueOf(originalPlayer.method_5477().method_10851()) + " has no AetherPlayer capability!"));
            AetherPlayer newAetherPlayer = AetherPlayer.getOptional(newPlayer).orElseThrow(() -> new IllegalStateException("Player " + String.valueOf(newPlayer.method_5477().method_10851()) + " has no AetherPlayer capability!"));
            newAetherPlayer.copyFrom(originalAetherPlayer, wasDeath);
        }

        public static void changeDimension(class_1657 player) {
            AetherPlayer aetherPlayer;
            if (!player.method_37908().method_8608() && (aetherPlayer = AetherPlayer.get(player)) instanceof AetherPlayerCapability) {
                AetherPlayerCapability capability = (AetherPlayerCapability)aetherPlayer;
                capability.forceSync(INBTSynchable.Direction.CLIENT);
            }
        }
    }
}

