/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.capability.time;

import com.aetherteam.aether.capability.time.AetherTime;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.AetherTimeSyncPacket;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import com.aetherteam.nitrogen.network.BasePacket;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.pepperbell.simplenetworking.SimpleChannel;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Triple;

public class AetherTimeCapability
implements AetherTime {
    private final class_1937 level;
    private long dayTime = 18000L;
    private boolean isEternalDay = true;
    private final Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> synchableFunctions = Map.ofEntries(Map.entry("setEternalDay", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setEternalDay((Boolean)object), this::getEternalDay)));

    public AetherTimeCapability(class_1937 level) {
        this.level = level;
    }

    @Override
    public class_1937 getLevel() {
        return this.level;
    }

    public Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> getSynchableFunctions() {
        return this.synchableFunctions;
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10544("DayTime", this.level.method_8532());
        tag.method_10556("EternalDay", this.getEternalDay());
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        if (tag.method_10545("DayTime")) {
            this.setDayTime(tag.method_10537("DayTime"));
        }
        if (tag.method_10545("EternalDay")) {
            this.setEternalDay(tag.method_10577("EternalDay"));
        }
    }

    @Override
    public long tickTime(class_1937 level) {
        long dayTime = level.method_8532();
        if (this.getEternalDay()) {
            if (dayTime != 18000L) {
                long tempTime = dayTime % 72000L;
                if (tempTime > 54000L) {
                    tempTime -= 72000L;
                }
                long target = (long)class_3532.method_15363((float)(18000L - tempTime), (float)-10.0f, (float)10.0f);
                dayTime += target;
            }
        } else {
            ++dayTime;
        }
        return dayTime;
    }

    @Override
    public void updateEternalDay() {
        this.setSynched(INBTSynchable.Direction.DIMENSION, "setEternalDay", this.isEternalDay, this.level.method_27983());
    }

    @Override
    public void updateEternalDay(class_3222 player) {
        this.setSynched(INBTSynchable.Direction.PLAYER, "setEternalDay", this.isEternalDay, player);
    }

    @Override
    public void setDayTime(long time) {
        this.dayTime = time;
    }

    @Override
    public long getDayTime() {
        return this.dayTime;
    }

    @Override
    public void setEternalDay(boolean isEternalDay) {
        this.isEternalDay = isEternalDay;
    }

    @Override
    public boolean getEternalDay() {
        return this.isEternalDay;
    }

    public BasePacket getSyncPacket(String key, INBTSynchable.Type type, Object value) {
        return new AetherTimeSyncPacket(key, type, value);
    }

    public SimpleChannel getPacketChannel() {
        return AetherPacketHandler.INSTANCE;
    }
}

