/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.energising;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.energising.EnergiserBlockEntity;
import org.antarcticgardens.cna.util.StringFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergiserBlock
extends HorizontalKineticBlock
implements IBE<EnergiserBlockEntity> {
    private final int tier;

    public EnergiserBlock(class_4970.class_2251 properties, int tier) {
        super(properties.method_9629(2.5f, 1.0f));
        this.tier = tier;
    }

    public static int getStrength(int tier) {
        return (int)(Math.pow(4.0, tier) * (Double)CNAConfig.getCommon().energiserSpeedMultiplier.get());
    }

    public static long getCapacity(int tier) {
        return (long)(Math.pow(10.0, tier) * 1000.0);
    }

    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 worldIn, @NotNull class_2338 pos, @NotNull class_3726 context) {
        if (context instanceof class_3727 && ((class_3727)context).method_32480() instanceof class_1657) {
            return AllShapes.CASING_14PX.get(class_2350.field_11033);
        }
        return AllShapes.MECHANICAL_PROCESSOR_SHAPE;
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 preferredSide = this.getPreferredHorizontalFacing(context);
        if (preferredSide != null) {
            return (class_2680)this.method_9564().method_11657(HORIZONTAL_FACING, (Comparable)preferredSide);
        }
        return super.method_9605(context);
    }

    public class_2350.class_2351 getRotationAxis(class_2680 state) {
        return ((class_2350)state.method_11654(HORIZONTAL_FACING)).method_10166();
    }

    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face.method_10166() == ((class_2350)state.method_11654(HORIZONTAL_FACING)).method_10166();
    }

    public Class<EnergiserBlockEntity> getBlockEntityClass() {
        return EnergiserBlockEntity.class;
    }

    public class_2591<? extends EnergiserBlockEntity> getBlockEntityType() {
        return (class_2591)CNABlockEntityTypes.ENERGISER.get();
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        tooltip.add((class_2561)CreateLang.translate((String)"tooltip.create_new_age.speed", (Object[])new Object[0]).style(class_124.field_1080).component());
        tooltip.add((class_2561)CreateLang.text((String)" ").translate("tooltip.create_new_age.energy_per_tick", new Object[]{StringFormatUtil.formatLong(EnergiserBlock.getStrength(this.tier))}).style(class_124.field_1075).add(CreateLang.text((String)" ").translate("tooltip.create_new_age.per_rpm", new Object[]{10}).style(class_124.field_1080)).component());
        tooltip.add((class_2561)CreateLang.translate((String)"tooltip.create_new_age.stores", (Object[])new Object[0]).style(class_124.field_1080).component());
        tooltip.add((class_2561)CreateLang.text((String)" ").translate("tooltip.create_new_age.energy", new Object[]{StringFormatUtil.formatLong(EnergiserBlock.getCapacity(this.tier))}).style(class_124.field_1075).component());
    }

    public static EnergiserBlock newBasic(class_4970.class_2251 properties) {
        return new EnergiserBlock(properties, 1);
    }

    public static EnergiserBlock newAdvanced(class_4970.class_2251 properties) {
        return new EnergiserBlock(properties, 2);
    }

    public static EnergiserBlock newReinforced(class_4970.class_2251 properties) {
        return new EnergiserBlock(properties, 3);
    }
}

