/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.energising;

import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import org.antarcticgardens.cna.content.energising.EnergiserBlock;
import org.antarcticgardens.cna.content.energising.EnergiserBlockEntity;
import org.antarcticgardens.cna.content.energising.recipe.EnergisingRecipe;
import org.antarcticgardens.esl.energy.EnergyHelper;
import org.antarcticgardens.esl.energy.EnergyStorage;
import org.antarcticgardens.esl.transaction.Transaction;
import org.antarcticgardens.esl.transaction.TransactionContext;
import org.antarcticgardens.esl.transaction.TransactionStack;
import org.antarcticgardens.esl.util.ItemHolder;
import org.antarcticgardens.esl.util.ItemStackHolder;
import org.joml.Math;

public class EnergiserBehaviour
extends BeltProcessingBehaviour {
    protected int tier;
    protected EnergiserBlockEntity be;
    public boolean capacitorMode = false;
    public EnergisingRecipe currentRecipe;
    public long charged;
    public long needed;
    private boolean shouldCreateParticles = false;
    public long sinceUpdate = 0L;

    public EnergiserBehaviour(EnergiserBlockEntity be) {
        super((SmartBlockEntity)be);
        this.whenItemEnters(this::itemEnter);
        this.whileItemHeld(this::itemHeld);
        this.be = be;
    }

    public EnergisingRecipe getRecipe(class_1799 stack) {
        if (this.be.method_10997() == null) {
            return null;
        }
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((class_1937)this.getWorld(), (class_1799)stack, (class_3956)EnergisingRecipe.TYPE.getType(), EnergisingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return (EnergisingRecipe)((Object)assemblyRecipe.get());
        }
        List recipes = this.be.method_10997().method_8433().method_30027(EnergisingRecipe.TYPE.getType());
        for (EnergisingRecipe recipe : recipes) {
            if (!recipe.test(stack)) continue;
            return recipe;
        }
        return null;
    }

    public void read(class_2487 nbt, boolean clientPacket) {
        this.charged = nbt.method_10537("charged");
        this.needed = nbt.method_10537("needed");
        this.shouldCreateParticles = nbt.method_10577("shouldCreateParticles");
        this.capacitorMode = nbt.method_10577("capacitorModer");
        super.read(nbt, clientPacket);
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        nbt.method_10544("charged", this.charged);
        nbt.method_10544("needed", this.needed);
        nbt.method_10556("shouldCreateParticles", this.shouldCreateParticles);
        nbt.method_10556("capacitorMode", this.capacitorMode);
        if (clientPacket) {
            this.shouldCreateParticles = false;
        }
        super.write(nbt, clientPacket);
    }

    public void tick() {
        super.tick();
        if (this.be.method_10997() == null) {
            return;
        }
        if (!this.be.method_10997().method_8608() && this.needed > 0L) {
            --this.sinceUpdate;
            if (this.sinceUpdate <= 0L) {
                this.needed = 0L;
                this.be.getEnergyStorage().internalInsert(this.charged, false);
                this.charged = 0L;
                this.currentRecipe = null;
                this.capacitorMode = false;
                this.blockEntity.sendData();
            }
        }
        if (!this.capacitorMode) {
            this.be.lastCharged = -1L;
            if (this.needed > 0L) {
                this.be.lastCharged = this.be.getEnergyStorage().internalExtract((long)Math.min((float)this.eSpeed(), (float)(this.needed - this.charged)), false);
                this.charged += this.be.lastCharged;
            }
        }
        if (this.be.method_10997().method_8608()) {
            this.be.size -= 0.15f;
            this.be.size = Math.clamp((float)0.0f, (float)1.0f, (float)this.be.size);
            if (this.needed > 0L && this.charged > 0L) {
                this.be.size = (float)Math.lerp((double)this.be.size, (double)((float)this.charged / (float)this.needed), (double)0.6);
            } else if (this.shouldCreateParticles) {
                this.shouldCreateParticles = false;
                class_5819 rand = this.be.method_10997().method_8409();
                for (int i = 0; i < 6; ++i) {
                    this.be.method_10997().method_8466((class_2394)class_2398.field_28479, false, (double)this.be.method_11016().method_10263() + 0.5 + ((double)rand.method_43057() - 0.5) * 0.4, (double)this.be.method_11016().method_10264() - 1.4 + ((double)rand.method_43057() - 0.5) * 0.4, (double)this.be.method_11016().method_10260() + 0.5 + ((double)rand.method_43057() - 0.5) * 0.4, 0.0, 0.5, 0.0);
                }
                this.be.method_10997().method_8486((double)this.be.method_11016().method_10263() + 0.5, (double)this.be.method_11016().method_10264() - 1.4, (double)this.be.method_11016().method_10260() + 0.5, class_3417.field_15210, class_3419.field_15245, 0.3f, 2.0f, true);
            }
        }
    }

    private BeltProcessingBehaviour.ProcessingResult itemHeld(TransportedItemStack transportedItemStack, TransportedItemStackHandlerBehaviour handler) {
        if (this.currentRecipe == null) {
            this.currentRecipe = this.getRecipe(transportedItemStack.stack);
        }
        if (this.be.getSpeed() == 0.0f || this.currentRecipe == null && !this.capacitorMode || this.be.method_10997() == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.capacitorMode) {
            ItemStackHolder holder = new ItemStackHolder(transportedItemStack.stack);
            EnergyStorage itemStorage = EnergyStorage.findForItem((ItemHolder)holder);
            if (itemStorage != null) {
                try (Transaction t = TransactionStack.get().openOuter();){
                    this.be.lastCharged = EnergyHelper.moveEnergy((EnergyStorage)this.be.getEnergyStorage(), (EnergyStorage)itemStorage, (long)this.eSpeed(), (TransactionContext)t);
                    this.charged = itemStorage.getStoredEnergy();
                    this.needed = itemStorage.getCapacity();
                    this.sinceUpdate = 10L;
                    transportedItemStack.stack = holder.toItemStack();
                    this.blockEntity.sendData();
                    if (this.charged >= this.needed) {
                        this.capacitorMode = false;
                        this.charged = 0L;
                        this.needed = 0L;
                        this.shouldCreateParticles = true;
                        BeltProcessingBehaviour.ProcessingResult processingResult = BeltProcessingBehaviour.ProcessingResult.PASS;
                        return processingResult;
                    }
                    t.commit();
                }
                return BeltProcessingBehaviour.ProcessingResult.HOLD;
            }
            this.capacitorMode = false;
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        int count = transportedItemStack.stack.method_7947();
        this.needed = (long)count * (long)this.currentRecipe.getEnergyNeeded();
        this.sinceUpdate = 10L;
        if (this.charged >= this.needed) {
            List out = this.currentRecipe.rollResults().stream().map(stack -> {
                TransportedItemStack copy = transportedItemStack.copy();
                boolean centered = BeltHelper.isItemUpright((class_1799)stack);
                stack.method_7939(stack.method_7947() * count);
                copy.stack = stack;
                copy.angle = centered ? 180 : this.be.method_10997().method_8409().method_43048(360);
                return copy;
            }).collect(Collectors.toList());
            if (this.charged > this.needed) {
                this.be.getEnergyStorage().internalInsert(this.charged - this.needed, false);
            }
            this.charged = 0L;
            this.needed = 0L;
            if (out.isEmpty()) {
                handler.handleProcessingOnItem(transportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult.removeItem());
            } else {
                handler.handleProcessingOnItem(transportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(out));
            }
            this.shouldCreateParticles = true;
            this.blockEntity.sendData();
            this.currentRecipe = null;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    private long eSpeed() {
        return (long)EnergiserBlock.getStrength(this.be.tier) * (long)Math.abs((double)((double)this.be.getSpeed() * 0.1));
    }

    private BeltProcessingBehaviour.ProcessingResult itemEnter(TransportedItemStack transportedItemStack, TransportedItemStackHandlerBehaviour transportedItemStackHandlerBehaviour) {
        if (this.be.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        EnergyStorage itemStorage = EnergyStorage.findForItem((ItemHolder)new ItemStackHolder(transportedItemStack.stack));
        if (itemStorage != null && itemStorage.getStoredEnergy() < itemStorage.getCapacity()) {
            this.capacitorMode = true;
            this.charged = itemStorage.getStoredEnergy();
            this.needed = itemStorage.getCapacity();
            this.sinceUpdate = 10L;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        this.capacitorMode = false;
        this.currentRecipe = this.getRecipe(transportedItemStack.stack);
        this.sinceUpdate = 10L;
        if (this.currentRecipe == null || this.currentRecipe.method_8117().size() > 1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }
}

