/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tacz.guns.GunMod;
import com.tacz.guns.util.Md5Utils;
import com.tacz.guns.util.UriEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jetbrains.annotations.NotNull;

public final class GetJarResources {
    private static final Instant BACKUP_TIME = Instant.parse("2024-02-26T12:28:08.000Z");
    private static final Path BACKUP_PATH = Paths.get("config", "tacz", "backup");
    private static final SimpleDateFormat BACKUP_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private static final int MAX_BACKUP_COUNT = 10;

    private GetJarResources() {
    }

    public static void copyModFile(String srcPath, Path root, String path) {
        URL url = GunMod.class.getResource(srcPath);
        try {
            if (url != null) {
                FileUtils.copyURLToFile((URL)url, (File)root.resolve(path).toFile());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyModDirectory(Class<?> resourceClass, String srcPath, Path root, String path) {
        URL url = resourceClass.getResource(srcPath);
        try {
            if (url != null) {
                GetJarResources.copyFolder(url.toURI(), root.resolve(path));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyModDirectory(String srcPath, Path root, String path) {
        GetJarResources.copyModDirectory(GunMod.class, srcPath, root, path);
    }

    @Nullable
    public static InputStream readModFile(String filePath) {
        URL url = GunMod.class.getResource(filePath);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void copyFolder(URI sourceURI, Path targetPath) throws IOException {
        if (Files.isDirectory(targetPath, new LinkOption[0])) {
            GetJarResources.backupFiles(targetPath);
            GetJarResources.deleteFiles(targetPath);
        }
        try (Stream<Path> stream = Files.walk(Paths.get(sourceURI), Integer.MAX_VALUE, new FileVisitOption[0]);){
            stream.forEach(source -> {
                Path target = GetJarResources.getTargetPath(sourceURI, targetPath, source);
                try {
                    if (Files.isDirectory(source, new LinkOption[0])) {
                        Files.createDirectories(target, new FileAttribute[0]);
                    } else {
                        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    @NotNull
    private static Path getTargetPath(URI sourceURI, Path targetPath, Path source) {
        String relativize = sourceURI.relativize(source.toUri()).toString();
        if (Objects.equals(sourceURI.getScheme(), "jar")) {
            URI pSourceURI = URI.create(UriEncoder.encode(sourceURI.getSchemeSpecificPart()));
            URI pSource = URI.create(UriEncoder.encode(source.toUri().getSchemeSpecificPart()));
            relativize = pSourceURI.relativize(pSource).toString();
        }
        return targetPath.resolve(relativize);
    }

    private static void backupFiles(Path targetPath) throws IOException {
        String dirName = targetPath.getFileName().toString();
        Path resourcePacksPath = FabricLoader.getInstance().getGameDir().resolve("tacz_backup");
        Path backupPath = resourcePacksPath.resolve(dirName);
        if (!Files.isDirectory(backupPath, new LinkOption[0])) {
            Files.createDirectories(backupPath, new FileAttribute[0]);
        }
        Set<String> cacheMd5 = GetJarResources.checkOldBackups(backupPath);
        File tempFile = File.createTempFile(dirName, ".tmp");
        FileTime fileTime = FileTime.from(BACKUP_TIME);
        try (ZipOutputStream zs = new ZipOutputStream(new FileOutputStream(tempFile));
             Stream<Path> fileWalks = Files.walk(targetPath, new FileVisitOption[0]);){
            fileWalks.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                String entryPath = targetPath.relativize((Path)path).toString();
                ZipEntry zipEntry = new ZipEntry(entryPath);
                zipEntry.setLastModifiedTime(fileTime);
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException e) {
                    GunMod.LOGGER.info("Error in zip file: {}", (Object)e.getMessage());
                }
            });
        }
        try (FileInputStream inputStream = new FileInputStream(tempFile);){
            String md5Hex = Md5Utils.md5Hex(inputStream);
            if (cacheMd5.contains(md5Hex)) {
                tempFile.deleteOnExit();
            } else {
                String dataName = BACKUP_DATE_FORMAT.format(new Date()).toLowerCase(Locale.ENGLISH);
                Path backupZipFilePath = backupPath.resolve(String.format("backup-%s-%s.zip", dataName, md5Hex));
                FileUtils.copyFile((File)tempFile, (File)backupZipFilePath.toFile());
            }
        }
    }

    private static Set<String> checkOldBackups(Path backupPath) {
        HashSet allMd5Hex = Sets.newHashSet();
        if (!Files.isDirectory(backupPath, new LinkOption[0])) {
            return allMd5Hex;
        }
        try {
            ArrayList delFiles = Lists.newArrayList((Iterable)FileUtils.listFiles((File)backupPath.toFile(), (IOFileFilter)TrueFileFilter.TRUE, null));
            delFiles.sort(LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            int count = 1;
            for (File file : delFiles) {
                if (count >= 10) {
                    GunMod.LOGGER.info("Deleting old backup gun pack {}", (Object)file.getName());
                    FileUtils.deleteQuietly((File)file);
                } else {
                    try (FileInputStream inputStream = new FileInputStream(file);){
                        allMd5Hex.add(Md5Utils.md5Hex(inputStream));
                    }
                }
                ++count;
            }
        }
        catch (Exception exception) {
            GunMod.LOGGER.error("Error while checking old backup gun pack : {}", (Object)exception.getMessage());
        }
        return allMd5Hex;
    }

    private static void deleteFiles(Path targetPath) throws IOException {
        Files.walkFileTree(targetPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

