/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.config.client.ZoomConfig;
import com.tacz.guns.util.math.MathUtil;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_4050;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_312.class})
public class MouseHandlerMixin {
    @WrapOperation(method={"turnPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;turn(DD)V")})
    public void reduceSensitivity(class_746 player, double yaw, double pitch, Operation<Void> original) {
        class_1799 mainHandItem = player.method_6047();
        IGun iGun = IGun.getIGunOrNull(mainHandItem);
        if (iGun == null) {
            original.call(new Object[]{player, yaw, pitch});
            return;
        }
        class_2960 scopeId = iGun.getAttachmentId(mainHandItem, AttachmentType.SCOPE);
        if (scopeId.equals((Object)DefaultAssets.EMPTY_ATTACHMENT_ID)) {
            scopeId = iGun.getBuiltInAttachmentId(mainHandItem, AttachmentType.SCOPE);
        }
        float zoomLevel = 1.0f;
        if (DefaultAssets.isEmptyAttachmentId(scopeId)) {
            zoomLevel = TimelessAPI.getGunDisplay(mainHandItem).map(GunDisplayInstance::getIronZoom).orElse(Float.valueOf(1.0f)).floatValue();
        } else {
            float[] zoom;
            Optional<ClientAttachmentIndex> optional = TimelessAPI.getClientAttachmentIndex(scopeId);
            if (optional.isPresent() && (zoom = optional.get().getZoom()) != null && zoom.length > 0) {
                class_2487 attachmentTag = iGun.getAttachmentTag(mainHandItem, AttachmentType.SCOPE);
                zoomLevel = zoom[AttachmentItemDataAccessor.getZoomNumberFromTag(attachmentTag) % zoom.length];
            }
        }
        class_310 minecraft = class_310.method_1551();
        float progress = IGunOperator.fromLivingEntity((class_1309)player).getSynAimingProgress();
        double sensitivityMultiplier = (Double)ZoomConfig.ZOOM_SENSITIVITY_BASE_MULTIPLIER.get();
        sensitivityMultiplier = 1.0 + (sensitivityMultiplier - 1.0) * (double)progress;
        double originalFov = ((Integer)minecraft.field_1690.method_41808().method_41753()).intValue();
        double currentFov = MathUtil.magnificationToFov(1.0f + (zoomLevel - 1.0f) * progress, originalFov);
        double coefficient = (Double)ZoomConfig.SCREEN_DISTANCE_COEFFICIENT.get();
        double denominator = MathUtil.zoomSensitivityRatio(currentFov, originalFov, coefficient) * sensitivityMultiplier;
        double finalYaw = yaw * denominator;
        double finalPitch = MouseHandlerMixin.getCrawlPitch(player, pitch, denominator);
        original.call(new Object[]{player, finalYaw, finalPitch});
    }

    @Unique
    private static double getCrawlPitch(class_746 player, double pitch, double denominator) {
        double finalPitch = pitch * denominator;
        if (!player.method_5681() && player.method_18376() == class_4050.field_18079) {
            float playerPitch = -player.method_36455();
            if (playerPitch > 45.0f) {
                finalPitch = Math.max(finalPitch, 0.0);
            }
            if (playerPitch < -30.0f) {
                finalPitch = Math.min(finalPitch, 0.0);
            }
        }
        return finalPitch;
    }
}

