/*
 * Decompiled with CFR 0.152.
 */
package cn.sh1rocu.tacz.util.forge;

import cn.sh1rocu.tacz.util.forge.CraftingHelper;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2105;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class PartialNBTIngredient
implements CustomIngredient {
    private final Set<class_1792> items;
    private final class_2487 nbt;
    private final class_2105 predicate;
    public static final class_2960 ID = new class_2960("forge", "partial_nbt");

    protected PartialNBTIngredient(Set<class_1792> items, class_2487 nbt) {
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a PartialNBTIngredient with no items");
        }
        this.items = Collections.unmodifiableSet(items);
        this.nbt = nbt;
        this.predicate = new class_2105(nbt);
    }

    public static PartialNBTIngredient of(class_2487 nbt, class_1935 ... items) {
        return new PartialNBTIngredient(Arrays.stream(items).map(class_1935::method_8389).collect(Collectors.toSet()), nbt);
    }

    public static PartialNBTIngredient of(class_1935 item, class_2487 nbt) {
        return new PartialNBTIngredient(Set.of(item.method_8389()), nbt);
    }

    public boolean test(@Nullable class_1799 input) {
        if (input == null) {
            return false;
        }
        return this.items.contains(input.method_7909()) && this.predicate.method_9077((class_2520)input.method_7969());
    }

    public List<class_1799> getMatchingStacks() {
        return this.items.stream().map(item -> {
            class_1799 stack = new class_1799((class_1935)item);
            stack.method_7980(this.nbt.method_10553());
            return stack;
        }).toList();
    }

    public boolean requiresTesting() {
        return true;
    }

    public CustomIngredientSerializer<PartialNBTIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements CustomIngredientSerializer<PartialNBTIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public class_2960 getIdentifier() {
            return ID;
        }

        public PartialNBTIngredient read(JsonObject json) {
            ImmutableSet items;
            if (json.has("item")) {
                items = Set.of(CraftingHelper.getItem(class_3518.method_15265((JsonObject)json, (String)"item"), true));
            } else if (json.has("items")) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                JsonArray itemArray = class_3518.method_15261((JsonObject)json, (String)"items");
                for (int i = 0; i < itemArray.size(); ++i) {
                    builder.add((Object)CraftingHelper.getItem(class_3518.method_15287((JsonElement)itemArray.get(i), (String)("items[" + i + "]")), true));
                }
                items = builder.build();
            } else {
                throw new JsonSyntaxException("Must set either 'item' or 'items'");
            }
            if (!json.has("nbt")) {
                throw new JsonSyntaxException("Missing nbt, expected to find a String or JsonObject");
            }
            class_2487 nbt = CraftingHelper.getNBT(json.get("nbt"));
            return new PartialNBTIngredient((Set<class_1792>)items, nbt);
        }

        public void write(JsonObject json, PartialNBTIngredient ingredient) {
            json.addProperty("type", ID.toString());
            if (ingredient.items.size() == 1) {
                json.addProperty("item", class_7923.field_41178.method_10221((Object)ingredient.items.iterator().next()).toString());
            } else {
                JsonArray items = new JsonArray();
                ingredient.items.stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).sorted().forEach(name -> items.add(name.toString()));
                json.add("items", (JsonElement)items);
            }
            json.addProperty("nbt", ingredient.nbt.toString());
        }

        public PartialNBTIngredient read(class_2540 buffer) {
            Set<class_1792> items = Stream.generate(() -> (class_1792)class_7923.field_41178.method_10223(buffer.method_10810())).limit(buffer.method_10816()).collect(Collectors.toSet());
            class_2487 nbt = buffer.method_10798();
            return new PartialNBTIngredient(items, Objects.requireNonNull(nbt));
        }

        public void write(class_2540 buffer, PartialNBTIngredient ingredient) {
            buffer.method_10804(ingredient.items.size());
            for (class_1792 item : ingredient.items) {
                buffer.method_10812(class_7923.field_41178.method_10221((Object)item));
            }
            buffer.method_10794(ingredient.nbt);
        }
    }
}

