/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.sealconfig.relocated.blue.endless.jankson.api.document;

import com.focamacho.sealconfig.relocated.blue.endless.jankson.api.document.CommentElement;
import com.focamacho.sealconfig.relocated.blue.endless.jankson.api.document.DocumentElement;
import com.focamacho.sealconfig.relocated.blue.endless.jankson.api.document.KeyValuePairElement;
import com.focamacho.sealconfig.relocated.blue.endless.jankson.api.document.ValueElement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ObjectElement
implements ValueElement {
    protected CommentElement commentBefore = null;
    protected CommentElement commentAfter = null;
    protected List<DocumentElement> entries = new ArrayList<DocumentElement>();

    @Nullable
    public ValueElement get(String key) {
        for (DocumentElement entry : this.entries) {
            if (!(entry instanceof KeyValuePairElement) || !((KeyValuePairElement)entry).getKey().equals(key)) continue;
            return ((KeyValuePairElement)entry).getValue();
        }
        return null;
    }

    public DocumentElement put(String key, ValueElement value) {
        if (value instanceof KeyValuePairElement || value instanceof CommentElement) {
            throw new IllegalArgumentException();
        }
        for (DocumentElement entry : this.entries) {
            KeyValuePairElement pair;
            if (!(entry instanceof KeyValuePairElement) || !(pair = (KeyValuePairElement)entry).getKey().equals(key)) continue;
            return pair.setValue(value);
        }
        this.entries.add(new KeyValuePairElement(key, value));
        return null;
    }

    public CommentElement commentBefore() {
        return this.commentBefore;
    }

    public CommentElement commentAfter() {
        return this.commentAfter;
    }

    public void setCommentBefore(String comment) {
        this.commentBefore = new CommentElement(comment);
    }

    public void setCommentBefore(CommentElement comment) {
        this.commentBefore = comment;
    }

    public void setCommentAfter(String comment) {
        this.commentAfter = new CommentElement(comment);
        this.commentAfter.setLineEnd(true);
    }

    public void setCommentAfter(CommentElement comment) {
        this.commentAfter = comment;
    }

    @Override
    public boolean isComment() {
        return false;
    }

    @Override
    public CommentElement asComment() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValueEntry() {
        return true;
    }

    @Override
    public ValueElement asValueEntry() {
        return this;
    }
}

