/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.ringsofascension;

import com.focamacho.ringsofascension.config.ConfigRingsOfAscension;
import com.focamacho.ringsofascension.data.LootModifier;
import com.focamacho.ringsofascension.init.ModItems;
import com.focamacho.sealconfig.SealConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_217;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import org.apache.commons.lang3.ArrayUtils;

public class RingsOfAscension
implements ModInitializer {
    public static final String MODID = "ringsofascension";
    private final SealConfig sealConfig = new SealConfig();
    public static ConfigRingsOfAscension config;
    private static final List<LootModifier> LOOT_MODIFIERS;

    public void onInitialize() {
        config = this.sealConfig.getConfig(new File(FabricLoader.getInstance().getConfigDir().toFile(), "ringsofascension.json"), ConfigRingsOfAscension.class);
        ModItems.init();
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)new class_2960(MODID, "creative_tab"), (Object)FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.ringsofascension")).method_47320(() -> new class_1799((class_1935)ModItems.ringExperience)).method_47317((context, entries) -> ModItems.allRings.forEach(r -> entries.method_45420(new class_1799((class_1935)r)))).method_47324());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public void method_14491(class_3300 manager) {
                RingsOfAscension.this.loadModifiers(manager);
            }

            public class_2960 getFabricId() {
                return new class_2960(RingsOfAscension.MODID, "loot_modifiers");
            }
        });
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            if (LOOT_MODIFIERS.isEmpty()) {
                this.loadModifiers(resourceManager);
            }
            LOOT_MODIFIERS.stream().filter(mod -> ArrayUtils.contains(mod.loot_tables, id.toString())).forEach(modifier -> tableBuilder.pool(new class_55.class_56().conditionally((Collection)Arrays.stream(modifier.conditions).collect(Collectors.toList())).method_351((class_79.class_80)class_77.method_411((class_1935)modifier.ring)).method_355()));
        });
    }

    private void loadModifiers(class_3300 manager) {
        LOOT_MODIFIERS.clear();
        Gson gson = new GsonBuilder().registerTypeAdapter(TypeToken.get(class_5341.class).getType(), class_217.method_29326()).registerTypeAdapter(TypeToken.get(class_1792.class).getType(), (src, typeOfSrc, context) -> new JsonPrimitive(class_7923.field_41178.method_10221(src).toString())).registerTypeAdapter(TypeToken.get(class_1792.class).getType(), (json, typeOfT, context) -> {
            String[] identifier = json.getAsString().split(":");
            return (class_1792)class_7923.field_41178.method_10223(class_2960.method_43902((String)identifier[0], (String)identifier[1]));
        }).create();
        Map resources = manager.method_14488("loot_modifiers", identifier -> identifier.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                InputStream input = ((class_3298)entry.getValue()).method_14482();
                try {
                    try {
                        LootModifier modifier = (LootModifier)gson.fromJson(new String(input.readAllBytes(), StandardCharsets.UTF_8), LootModifier.class);
                        if (!Objects.equals(modifier.type, "ringsofascension:rings_modifier")) continue;
                        LOOT_MODIFIERS.add(modifier);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        LOOT_MODIFIERS = new ArrayList<LootModifier>();
    }
}

