/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.model;

import com.pepper.faunify.config.FaunifyConfig;
import com.pepper.faunify.entity.ChinchillaEntity;
import net.minecraft.class_2960;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class ChinchillaModel
extends GeoModel<ChinchillaEntity> {
    public class_2960 getModelResource(ChinchillaEntity animatable) {
        return new class_2960("faunify", "geo/chinchilla.geo.json");
    }

    public class_2960 getTextureResource(ChinchillaEntity animatable) {
        return new class_2960("faunify", "textures/entity/chinchilla.png");
    }

    public class_2960 getAnimationResource(ChinchillaEntity animatable) {
        if (FaunifyConfig.oldAnimationStyle) {
            return new class_2960("faunify", "animations/chinchilla.animation.json");
        }
        return new class_2960("faunify", "animations/ratchinchilla.animation.json");
    }

    public void setCustomAnimations(ChinchillaEntity entity, long instanceId, AnimationState<ChinchillaEntity> animationState) {
        boolean isIdle;
        if (animationState == null) {
            return;
        }
        CoreGeoBone head = this.getBone("head").orElse(null);
        CoreGeoBone neck = this.getBone("head_rotation").orElse(null);
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (entityData == null) {
            return;
        }
        boolean moving = animationState.isMoving();
        if (head != null) {
            if (entity.method_6109()) {
                float headScale = 1.3f;
                head.setScaleX(headScale);
                head.setScaleY(headScale);
                head.setScaleZ(headScale);
            } else {
                head.setScaleX(1.0f);
                head.setScaleY(1.0f);
                head.setScaleZ(1.0f);
            }
        }
        boolean bl = isIdle = !moving && !entity.method_6113() && !entity.method_6172();
        if (!entity.method_6113() && !entity.method_6172()) {
            if (head == null) {
                return;
            }
            if (isIdle) {
                return;
            }
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
        if (entity.method_6172()) {
            if (head != null) {
                head.setRotZ(entityData.netHeadYaw() * ((float)Math.PI / 180));
            }
            return;
        }
        if (neck != null && head != null) {
            float pitch = entityData.headPitch();
            neck.setRotX(Math.min(20.0f, pitch) * ((float)Math.PI / 180));
            if (pitch > 20.0f && !moving) {
                head.setRotX((pitch - 30.0f) * ((float)Math.PI / 180));
            }
            neck.setRotZ(entityData.netHeadYaw() * ((float)Math.PI / 180) * -0.5f);
        }
    }
}

