/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.config;

import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class FaunifyConfig {
    private static final String CONFIG_FILE_NAME = "faunify.properties";
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("faunify.properties");
    public static boolean oldAnimationStyle = false;
    public static boolean replaceNet = true;
    public static int weaselSpawnWeight = 8;
    public static int fennecSpawnWeight = 5;
    public static int chinchillaSpawnWeight = 8;
    public static int hedgehogSpawnWeight = 6;
    public static int ringtailcatSpawnWeight = 6;
    public static int opossumSpawnWeight = 8;
    public static int mouseSpawnWeight = 12;
    public static int silkmothSpawnWeight = 16;
    public static int leafsheepSpawnWeight = 35;
    private static final Map<String, ConfigEntry> configEntries = new HashMap<String, ConfigEntry>();

    public static void load() {
        try {
            if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
                FaunifyConfig.save();
                return;
            }
            Properties properties = new Properties();
            try (InputStream input = Files.newInputStream(CONFIG_FILE, new OpenOption[0]);){
                properties.load(input);
            }
            oldAnimationStyle = FaunifyConfig.getBooleanProperty(properties, "oldAnimationStyle", false);
            replaceNet = FaunifyConfig.getBooleanProperty(properties, "replaceNet", true);
            weaselSpawnWeight = FaunifyConfig.getIntProperty(properties, "weaselSpawnWeight", 8);
            fennecSpawnWeight = FaunifyConfig.getIntProperty(properties, "fennecSpawnWeight", 5);
            chinchillaSpawnWeight = FaunifyConfig.getIntProperty(properties, "chinchillaSpawnWeight", 15);
            hedgehogSpawnWeight = FaunifyConfig.getIntProperty(properties, "hedgehogSpawnWeight", 8);
            ringtailcatSpawnWeight = FaunifyConfig.getIntProperty(properties, "ringtailcatSpawnWeight", 6);
            opossumSpawnWeight = FaunifyConfig.getIntProperty(properties, "opossumSpawnWeight", 8);
            mouseSpawnWeight = FaunifyConfig.getIntProperty(properties, "mouseSpawnWeight", 8);
            silkmothSpawnWeight = FaunifyConfig.getIntProperty(properties, "silkmothSpawnWeight", 16);
            leafsheepSpawnWeight = FaunifyConfig.getIntProperty(properties, "leafsheepSpawnWeight", 35);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]));){
                writer.println("[animation_settings]");
                writer.println();
                FaunifyConfig.writeBooleanConfigEntry(writer, "oldAnimationStyle", oldAnimationStyle);
                writer.println("[compatibility_settings]");
                writer.println();
                FaunifyConfig.writeBooleanConfigEntry(writer, "replaceNet", replaceNet);
                writer.println("[spawning]");
                writer.println();
                FaunifyConfig.writeIntConfigEntry(writer, "weaselSpawnWeight", weaselSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "fennecSpawnWeight", fennecSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "chinchillaSpawnWeight", chinchillaSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "hedgehogSpawnWeight", hedgehogSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "ringtailcatSpawnWeight", ringtailcatSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "opossumSpawnWeight", opossumSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "mouseSpawnWeight", mouseSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "silkmothSpawnWeight", silkmothSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "leafsheepSpawnWeight", leafsheepSpawnWeight);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void writeIntConfigEntry(PrintWriter writer, String key, int value) {
        ConfigEntry entry = configEntries.get(key);
        if (entry != null && entry.isInt) {
            writer.println("\t#" + entry.comment);
            writer.println("\t#Range: " + entry.min + " ~ " + entry.max);
            writer.println("\t" + key + " = " + value);
            writer.println();
        }
    }

    private static void writeBooleanConfigEntry(PrintWriter writer, String key, boolean value) {
        ConfigEntry entry = configEntries.get(key);
        if (entry != null && !entry.isInt) {
            writer.println("\t#" + entry.comment);
            writer.println("\t" + key + " = " + value);
            writer.println();
        }
    }

    private static int getIntProperty(Properties properties, String key, int defaultValue) {
        try {
            String value = properties.getProperty(key);
            if (value != null) {
                int parsed = Integer.parseInt(value.trim());
                ConfigEntry entry = configEntries.get(key);
                if (entry != null && entry.isInt) {
                    return Math.max(entry.min, Math.min(entry.max, parsed));
                }
                return parsed;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    private static boolean getBooleanProperty(Properties properties, String key, boolean defaultValue) {
        try {
            String value = properties.getProperty(key);
            if (value != null) {
                return Boolean.parseBoolean(value.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    static {
        configEntries.put("oldAnimationStyle", new ConfigEntry("oldAnimationStyle", false, "Use the old animation style"));
        configEntries.put("replaceNet", new ConfigEntry("replaceNet", true, "Disable Naturalist's Bug Net to use Faunify's Bug Net"));
        configEntries.put("weaselSpawnWeight", new ConfigEntry("weaselSpawnWeight", 8, 0, 500, "Spawn Weight - How often Weasels spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("fennecSpawnWeight", new ConfigEntry("fennecSpawnWeight", 5, 0, 500, "Spawn Weight - How often Fennec Foxes spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("chinchillaSpawnWeight", new ConfigEntry("chinchillaSpawnWeight", 15, 0, 500, "Spawn Weight - How often Chinchillas spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("hedgehogSpawnWeight", new ConfigEntry("hedgehogSpawnWeight", 8, 0, 500, "Spawn Weight - How often Hedgehogs spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("ringtailcatSpawnWeight", new ConfigEntry("ringtailcatSpawnWeight", 6, 0, 500, "Spawn Weight - How often Ringtail Cats spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("opossumSpawnWeight", new ConfigEntry("opossumSpawnWeight", 8, 0, 500, "Spawn Weight - How often Opossums spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("mouseSpawnWeight", new ConfigEntry("mouseSpawnWeight", 8, 0, 500, "Spawn Weight - How often Mice spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("silkmothSpawnWeight", new ConfigEntry("silkmothSpawnWeight", 16, 0, 500, "Spawn Weight - How often Silk Moths spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("leafsheepSpawnWeight", new ConfigEntry("leafsheepSpawnWeight", 35, 0, 500, "Spawn Weight - How often Leaf Sheep spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
    }

    private static class ConfigEntry {
        final boolean isInt;
        final int min;
        final int max;
        final String comment;

        ConfigEntry(String key, boolean defaultValue, String comment) {
            this.isInt = false;
            this.min = 0;
            this.max = 0;
            this.comment = comment;
        }

        ConfigEntry(String key, int defaultValue, int min, int max, String comment) {
            this.isInt = true;
            this.min = min;
            this.max = max;
            this.comment = comment;
        }
    }
}

