/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.energy;

import earth.terrarium.botarium.common.energy.base.PlatformEnergyManager;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.jetbrains.annotations.ApiStatus;
import team.reborn.energy.api.EnergyStorage;

@ApiStatus.Internal
public record FabricEnergyManager(EnergyStorage energy) implements PlatformEnergyManager
{
    public FabricEnergyManager(class_2586 entity, class_2350 direction) {
        this((EnergyStorage)EnergyStorage.SIDED.find(entity.method_10997(), entity.method_11016(), (Object)direction));
    }

    @Override
    public long getStoredEnergy() {
        return this.energy.getAmount();
    }

    @Override
    public long getCapacity() {
        return this.energy.getCapacity();
    }

    @Override
    public long extract(long amount, boolean simulate) {
        try (Transaction txn = Transaction.openOuter();){
            long extract = this.energy.extract(amount, (TransactionContext)txn);
            if (simulate) {
                txn.abort();
            } else {
                txn.commit();
            }
            long l = extract;
            return l;
        }
    }

    @Override
    public long insert(long amount, boolean simulate) {
        try (Transaction txn = Transaction.openOuter();){
            long insert = this.energy.insert(amount, (TransactionContext)txn);
            if (simulate) {
                txn.abort();
            } else {
                txn.commit();
            }
            long l = insert;
            return l;
        }
    }

    @Override
    public boolean supportsInsertion() {
        return this.energy.supportsInsertion();
    }

    @Override
    public boolean supportsExtraction() {
        return this.energy.supportsExtraction();
    }
}

