/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.glm;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IOperation;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.glm.IGlobalLootModifierAccessor;
import com.yanny.ali.plugin.glm.IGlobalLootModifierPlugin;
import com.yanny.ali.plugin.glm.IGlobalLootModifierWrapper;
import com.yanny.ali.plugin.glm.ILootTableIdConditionPredicate;
import com.yanny.ali.plugin.mods.BaseAccessor;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.ReflectionUtils;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.GlobalLootModifierNode;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_212;
import net.minecraft.class_215;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_8551;
import org.slf4j.Logger;

public class GlobalLootModifierUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<ILootModifier<?>> getLootModifier(final List<class_5341> conditions, final Function<List<class_5341>, List<IOperation>> operationSupplier, final ILootTableIdConditionPredicate predicate) {
        if (GlobalLootModifierUtils.entityPredicate(conditions)) {
            return Optional.of(new ILootModifier<class_1297>(){

                @Override
                public boolean predicate(class_1297 value) {
                    return GlobalLootModifierUtils.entityPredicate(conditions, value);
                }

                @Override
                public List<IOperation> getOperations() {
                    return (List)operationSupplier.apply(conditions.stream().filter(c -> !GlobalLootModifierUtils.entityPredicate(c)).toList());
                }

                @Override
                public ILootModifier.IType<class_1297> getType() {
                    return ILootModifier.IType.ENTITY;
                }
            });
        }
        if (GlobalLootModifierUtils.blockPredicate(conditions)) {
            return Optional.of(new ILootModifier<class_2248>(){

                @Override
                public boolean predicate(class_2248 value) {
                    return GlobalLootModifierUtils.blockPredicate(conditions, value);
                }

                @Override
                public List<IOperation> getOperations() {
                    return (List)operationSupplier.apply(conditions.stream().filter(c -> !GlobalLootModifierUtils.blockPredicate(c)).toList());
                }

                @Override
                public ILootModifier.IType<class_2248> getType() {
                    return ILootModifier.IType.BLOCK;
                }
            });
        }
        if (GlobalLootModifierUtils.tablePredicate(conditions, predicate)) {
            return Optional.of(new ILootModifier<class_2960>(){

                @Override
                public boolean predicate(class_2960 value) {
                    return GlobalLootModifierUtils.tablePredicate(conditions, value, predicate);
                }

                @Override
                public List<IOperation> getOperations() {
                    return (List)operationSupplier.apply(conditions.stream().filter(c -> !GlobalLootModifierUtils.tablePredicate(c, predicate)).toList());
                }

                @Override
                public ILootModifier.IType<class_2960> getType() {
                    return ILootModifier.IType.LOOT_TABLE;
                }
            });
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean entityPredicate(class_5341 c) {
        if (c instanceof class_215) {
            class_215 condition = (class_215)c;
            if (condition.field_1292 == class_47.class_50.field_935 && condition.field_1293 != class_2048.field_9599 && condition.field_1293.field_9595 != class_2050.field_9609) {
                return true;
            }
        }
        if (!(c instanceof class_8551)) return false;
        class_8551 condition = (class_8551)c;
        if (!GlobalLootModifierUtils.entityPredicate(Arrays.asList(condition.field_1246))) return false;
        return true;
    }

    public static boolean entityPredicate(List<class_5341> conditions) {
        return conditions.stream().anyMatch(GlobalLootModifierUtils::entityPredicate);
    }

    public static boolean entityPredicate(List<class_5341> conditions, class_1297 entity) {
        return conditions.stream().anyMatch(c -> {
            if (c instanceof class_215) {
                class_215 condition = (class_215)c;
                if (condition.field_1292 == class_47.class_50.field_935 && condition.field_1293 != class_2048.field_9599 && condition.field_1293.field_9595 != class_2050.field_9609 && condition.field_1293.field_9595.method_8925(entity.method_5864())) {
                    return true;
                }
            }
            if (!(c instanceof class_8551)) return false;
            class_8551 condition = (class_8551)c;
            if (!GlobalLootModifierUtils.entityPredicate(Arrays.asList(condition.field_1246), entity)) return false;
            return true;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean blockPredicate(class_5341 c) {
        if (c instanceof class_212) {
            return true;
        }
        if (!(c instanceof class_8551)) return false;
        class_8551 condition = (class_8551)c;
        if (!GlobalLootModifierUtils.blockPredicate(Arrays.asList(condition.field_1246))) return false;
        return true;
    }

    public static boolean blockPredicate(List<class_5341> conditions) {
        return conditions.stream().anyMatch(GlobalLootModifierUtils::blockPredicate);
    }

    public static boolean blockPredicate(List<class_5341> conditions, class_2248 block) {
        return conditions.stream().anyMatch(c -> {
            if (c instanceof class_212) {
                class_212 condition = (class_212)c;
                if (condition.field_1286.equals(block)) {
                    return true;
                }
            }
            if (!(c instanceof class_8551)) return false;
            class_8551 condition = (class_8551)c;
            if (!GlobalLootModifierUtils.blockPredicate(Arrays.asList(condition.field_1246), block)) return false;
            return true;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean tablePredicate(class_5341 c, ILootTableIdConditionPredicate predicate) {
        if (predicate.isLootTableIdCondition(c)) {
            return true;
        }
        if (!(c instanceof class_8551)) return false;
        class_8551 condition = (class_8551)c;
        if (!GlobalLootModifierUtils.tablePredicate(Arrays.asList(condition.field_1246), predicate)) return false;
        return true;
    }

    public static boolean tablePredicate(List<class_5341> conditions, ILootTableIdConditionPredicate predicate) {
        return conditions.stream().anyMatch(c -> GlobalLootModifierUtils.tablePredicate(c, predicate));
    }

    public static boolean tablePredicate(List<class_5341> conditions, class_2960 location, ILootTableIdConditionPredicate predicate) {
        return conditions.stream().anyMatch(c -> {
            if (predicate.isLootTableIdCondition((class_5341)c) && predicate.getTargetLootTableId((class_5341)c).equals((Object)location)) {
                return true;
            }
            if (!(c instanceof class_8551)) return false;
            class_8551 condition = (class_8551)c;
            if (!GlobalLootModifierUtils.tablePredicate(Arrays.asList(condition.field_1246), location, predicate)) return false;
            return true;
        });
    }

    public static <T extends BaseAccessor<?>> void registerGlobalLootModifier(IGlobalLootModifierPlugin.IRegistry registry, Class<T> clazz, ILootTableIdConditionPredicate predicate) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> functionClass = Class.forName(classAnnotation.value());
                registry.registerGlobalLootModifier(functionClass, (u, c) -> ((IGlobalLootModifierAccessor)ReflectionUtils.copyClassData(clazz, c)).getLootModifier((IServerUtils)u, predicate));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register GLM for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for GLM " + clazz.getName());
        }
    }

    public static Optional<ILootModifier<?>> getMissingGlobalLootModifier(IServerUtils utils, IGlobalLootModifierWrapper modifier, ILootTableIdConditionPredicate predicate) {
        if (modifier.isLootModifier()) {
            return GlobalLootModifierUtils.getLootModifier(modifier.getConditions(), conditions -> {
                ArrayTooltipNode.Builder tooltip = ArrayTooltipNode.array();
                IKeyTooltipNode fieldsTooltip = utils.getValueTooltip(utils, modifier.getName());
                TooltipUtils.addObjectFields(utils, fieldsTooltip, modifier, modifier.getLootModifierClass());
                tooltip.add(fieldsTooltip.build("ali.util.advanced_loot_info.auto_detected"));
                tooltip.add(GenericTooltipUtils.getConditionsTooltip(utils, conditions));
                return List.of(new IOperation.AddOperation(i -> true, new GlobalLootModifierNode(utils, tooltip.build())));
            }, predicate);
        }
        return Optional.empty();
    }
}

