/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.tooltip;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.common.tooltip.ListTooltipNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ComponentTooltipNode
extends ListTooltipNode
implements ITooltipNode {
    public static final class_2960 ID = new class_2960("ali", "component");
    private static final LoadingCache<CacheKey, ComponentTooltipNode> CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(data -> data != null ? new ComponentTooltipNode((CacheKey)data) : null));
    private final List<class_2561> values;
    private final String key;

    private ComponentTooltipNode(CacheKey cacheKey) {
        super(cacheKey.children);
        this.key = cacheKey.key;
        this.values = cacheKey.values;
    }

    @Override
    public void encodeNode(class_2540 buf) {
        buf.writeInt(this.values.size());
        for (class_2561 value : this.values) {
            buf.method_10805(value);
        }
        buf.method_10814(this.key);
    }

    @Override
    public List<class_2561> getComponents(int pad, boolean showAdvancedTooltip) {
        if (this.key == null) {
            throw new IllegalStateException("Key was not set!");
        }
        List<class_2561> children = super.getComponents(pad + 1, showAdvancedTooltip);
        ArrayList<class_2561> components = new ArrayList<class_2561>(children.size() + 1);
        Object[] values = this.values.stream().map(ComponentTooltipNode::transform).toArray();
        components.add(ITooltipNode.pad(pad, class_2561.method_43469((String)this.key, (Object[])values).method_27692(TEXT_STYLE)));
        components.addAll(children);
        return components;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentTooltipNode that = (ComponentTooltipNode)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.values, this.key);
    }

    public String toString() {
        return "ComponentTooltipNode{key='" + this.key + "', values=" + String.valueOf(this.values) + ", children=" + String.valueOf(this.getChildren()) + "}";
    }

    @NotNull
    public static Builder values(class_2561 ... values) {
        return new Builder(Arrays.asList(values));
    }

    @NotNull
    public static ComponentTooltipNode decode(IClientUtils utils, class_2540 buf) {
        List<class_2561> values;
        List<ITooltipNode> children = ListTooltipNode.decodeChildren(utils, buf);
        int size = buf.readInt();
        if (size == 1) {
            values = Collections.singletonList(buf.method_10808());
        } else {
            values = new ArrayList<class_2561>();
            for (int i = 0; i < size; ++i) {
                values.add(buf.method_10808());
            }
        }
        String key = buf.method_19772();
        CacheKey cacheKey = new CacheKey(children, key, values);
        try {
            return (ComponentTooltipNode)CACHE.get((Object)cacheKey);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static class_2561 transform(class_2561 component) {
        if (component instanceof class_5250) {
            class_5250 mutableComponent = (class_5250)component;
            return mutableComponent.method_27661().method_27692(ITooltipNode.PARAM_STYLE);
        }
        return component;
    }

    private record CacheKey(List<ITooltipNode> children, String key, List<class_2561> values) {
        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.key, cacheKey.key) && Objects.equals(this.values, cacheKey.values) && Objects.equals(this.children, cacheKey.children);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.children, this.key, this.values);
        }
    }

    public static class Builder
    extends ListTooltipNode.Builder {
        private final List<class_2561> values;

        public Builder(List<class_2561> values) {
            this.values = values;
        }

        @Override
        public ComponentTooltipNode build(String key) {
            String internKey = key.intern();
            CacheKey cacheKey = new CacheKey((List<ITooltipNode>)ImmutableList.copyOf((Collection)this.children), internKey, (List<class_2561>)ImmutableList.copyOf(this.values));
            try {
                return (ComponentTooltipNode)CACHE.get((Object)cacheKey);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

