/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.resource;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class AlternativesFileToIdConverter {
    private final String prefix;
    private final List<String> extensions;
    private final int sameExtensionLength;

    public AlternativesFileToIdConverter(String pPrefix, List<String> pExtensions) {
        this.prefix = pPrefix;
        this.extensions = pExtensions;
        this.sameExtensionLength = pExtensions.stream().mapToInt(String::length).distinct().reduce((a, b) -> -1).orElseThrow();
        Preconditions.checkArgument((!this.extensions.isEmpty() ? 1 : 0) != 0, (Object)"Extensions cannot be empty");
    }

    public static AlternativesFileToIdConverter yamlOrJson(String pName) {
        return new AlternativesFileToIdConverter(pName, List.of(".yaml", ".json"));
    }

    public class_2960 idToFile(class_2960 pId) {
        return pId.method_45136(this.prefix + "/" + pId.method_12832() + this.extensions.get(0));
    }

    public Stream<class_2960> idToAllPossibleFiles(class_2960 pId) {
        return this.extensions.stream().map(ext -> pId.method_45136(this.prefix + "/" + pId.method_12832() + ext));
    }

    public class_2960 fileToId(class_2960 pFile) {
        if (this.sameExtensionLength >= 0) {
            String s = pFile.method_12832();
            return pFile.method_45136(s.substring(this.prefix.length() + 1, s.length() - this.sameExtensionLength));
        }
        for (String ext : this.extensions) {
            if (!pFile.method_12832().endsWith(ext)) continue;
            String s = pFile.method_12832();
            return pFile.method_45136(s.substring(this.prefix.length() + 1, s.length() - ext.length()));
        }
        throw new IllegalArgumentException("Unknown extension for " + String.valueOf(pFile));
    }

    public Map<class_2960, class_3298> listMatchingResources(class_3300 pResourceManager) {
        return pResourceManager.method_14488(this.prefix, location -> this.extensions.stream().anyMatch(location.method_12832()::endsWith));
    }

    public Map<class_2960, List<class_3298>> listMatchingResourceStacks(class_3300 pResourceManager) {
        return pResourceManager.method_41265(this.prefix, location -> this.extensions.stream().anyMatch(location.method_12832()::endsWith));
    }
}

