/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.codec;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1814;
import net.minecraft.class_1922;
import net.minecraft.class_2096;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2440;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4174;
import net.minecraft.class_4550;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_5955;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8177;
import snownee.kiwi.KiwiModule;

public class CustomizationCodecs {
    public static final BiMap<String, class_2766> INSTRUMENTS = HashBiMap.create();
    public static final Codec<class_2766> INSTRUMENT_CODEC = CustomizationCodecs.simpleByNameCodec(INSTRUMENTS);
    public static final BiMap<String, class_3620> MAP_COLORS = HashBiMap.create();
    public static final Codec<class_3620> MAP_COLOR_CODEC = CustomizationCodecs.simpleByNameCodec(MAP_COLORS);
    public static final Codec<class_3619> PUSH_REACTION = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"normal", (Object)class_3619.field_15974, (Object)"destroy", (Object)class_3619.field_15971, (Object)"block", (Object)class_3619.field_15972, (Object)"ignore", (Object)class_3619.field_15975, (Object)"push_only", (Object)class_3619.field_15970));
    public static final Codec<KiwiModule.RenderLayer.Layer> RENDER_TYPE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"cutout", (Object)((Object)KiwiModule.RenderLayer.Layer.CUTOUT), (Object)"cutout_mipped", (Object)((Object)KiwiModule.RenderLayer.Layer.CUTOUT_MIPPED), (Object)"translucent", (Object)((Object)KiwiModule.RenderLayer.Layer.TRANSLUCENT)));
    public static final Codec<class_4970.class_2250> OFFSET_TYPE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"xz", (Object)class_4970.class_2250.field_10657, (Object)"xyz", (Object)class_4970.class_2250.field_10655));
    public static final Codec<class_4970.class_4973> STATE_PREDICATE = Codec.BOOL.flatComapMap(bl -> bl != false ? class_2246::method_26113 : class_2246::method_26122, p -> DataResult.error(() -> "Unsupported operation"));
    public static final Codec<class_2350> DIRECTION = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"down", (Object)class_2350.field_11033, (Object)"up", (Object)class_2350.field_11036, (Object)"north", (Object)class_2350.field_11043, (Object)"south", (Object)class_2350.field_11035, (Object)"west", (Object)class_2350.field_11039, (Object)"east", (Object)class_2350.field_11034));
    public static final Codec<class_2096.class_2100> INT_BOUNDS = class_5699.field_40721.xmap(class_2096.class_2100::method_9056, class_2096::method_9036);
    public static final Codec<class_4550> BLOCK_PREDICATE = new Codec<class_4550>(){

        public <T> DataResult<Pair<class_4550, T>> decode(DynamicOps<T> ops, T input) {
            String stringValue = ops.getStringValue(input).result().orElse(null);
            if (stringValue != null) {
                if (stringValue.startsWith("#")) {
                    return DataResult.success((Object)Pair.of((Object)class_4550.class_4710.method_23880().method_29233(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(stringValue.substring(1)))).method_23882(), (Object)ops.empty()));
                }
                return DataResult.success((Object)Pair.of((Object)class_4550.class_4710.method_23880().method_27962(new class_2248[]{(class_2248)class_7923.field_41175.method_10223(new class_2960(stringValue))}).method_23882(), (Object)ops.empty()));
            }
            return class_5699.field_40721.decode(ops, input).map($ -> $.mapFirst(class_4550::method_22453));
        }

        public <T> DataResult<T> encode(class_4550 input, DynamicOps<T> ops, T prefix) {
            return class_5699.field_40721.encodeStart(ops, (Object)input.method_22452());
        }
    };
    public static final Codec<class_8177> BLOCK_SET_TYPE = class_5699.method_39508(class_8177::comp_1289, s -> class_8177.method_49232().filter(e -> e.comp_1289().equals(s)).findFirst().orElseThrow());
    public static final Codec<class_4719> WOOD_TYPE = class_5699.method_39508(class_4719::comp_1299, s -> class_4719.method_24026().filter(e -> e.comp_1299().equals(s)).findFirst().orElseThrow());
    public static final BiMap<String, class_2440.class_2441> SENSITIVITIES = HashBiMap.create();
    public static final Codec<class_2440.class_2441> SENSITIVITY_CODEC = CustomizationCodecs.simpleByNameCodec(SENSITIVITIES);
    public static final Codec<class_5955.class_5811> WEATHER_STATE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"unaffected", (Object)class_5955.class_5811.field_28704, (Object)"exposed", (Object)class_5955.class_5811.field_28705, (Object)"weathered", (Object)class_5955.class_5811.field_28706, (Object)"oxidized", (Object)class_5955.class_5811.field_28707));
    public static final Codec<class_1293> MOB_EFFECT_INSTANCE = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41174.method_39673().fieldOf("id").forGetter(class_1293::method_5579), (App)class_5699.field_33441.optionalFieldOf("amplifier", (Object)0).forGetter(class_1293::method_5578), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(class_1293::method_5584), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(class_1293::method_5591), (App)Codec.BOOL.optionalFieldOf("show_particles", (Object)true).forGetter(class_1293::method_5581), (App)Codec.BOOL.optionalFieldOf("show_icon", (Object)true).forGetter(class_1293::method_5592)).apply((Applicative)instance, class_1293::new));
    public static final Codec<Pair<class_1293, Float>> POSSIBLE_EFFECT = RecordCodecBuilder.create(instance -> instance.group((App)MOB_EFFECT_INSTANCE.fieldOf("effect").forGetter(Pair::getFirst), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("probability", (Object)Float.valueOf(1.0f)).forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    public static final Codec<class_4174> FOOD = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("nutrition").forGetter(class_4174::method_19230), (App)Codec.FLOAT.fieldOf("saturation").forGetter(class_4174::method_19231), (App)Codec.BOOL.optionalFieldOf("meat", (Object)false).forGetter(class_4174::method_19232), (App)Codec.BOOL.optionalFieldOf("can_always_eat", (Object)false).forGetter(class_4174::method_19233), (App)Codec.BOOL.optionalFieldOf("fast_food", (Object)false).forGetter(class_4174::method_19234), (App)POSSIBLE_EFFECT.listOf().optionalFieldOf("effects", List.of()).forGetter(class_4174::method_19235)).apply((Applicative)instance, class_4174::new));
    public static final BiMap<String, class_1814> RARITIES = HashBiMap.create(Map.of("common", class_1814.field_8906, "uncommon", class_1814.field_8907, "rare", class_1814.field_8903, "epic", class_1814.field_8904));
    public static final Codec<class_1814> RARITY_CODEC = CustomizationCodecs.simpleByNameCodec(RARITIES);
    public static final Codec<class_1738.class_8051> ARMOR_TYPE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"helmet", (Object)class_1738.class_8051.field_41934, (Object)"chestplate", (Object)class_1738.class_8051.field_41935, (Object)"leggings", (Object)class_1738.class_8051.field_41936, (Object)"boots", (Object)class_1738.class_8051.field_41937));
    public static final BiMap<class_2960, class_1741> CUSTOM_ARMOR_MATERIALS = HashBiMap.create();
    public static final Codec<class_1741> ARMOR_MATERIAL = CustomizationCodecs.withAlternative((Codec)class_3542.method_28140(class_1740::values), CustomizationCodecs.simpleByNameCodec(CUSTOM_ARMOR_MATERIALS));

    public static <T> Codec<T> simpleByNameCodec(Map<class_2960, T> map) {
        return class_2960.field_25139.flatXmap(key -> {
            Object value = map.get(key);
            if (value == null) {
                return DataResult.error(() -> "Unknown key: " + String.valueOf(key));
            }
            return DataResult.success(value);
        }, value -> DataResult.error(() -> "Unsupported operation"));
    }

    public static <T> Codec<T> simpleByNameCodec(BiMap<String, T> map) {
        return CustomizationCodecs.simpleByNameCodec(map, Codec.STRING);
    }

    public static <K, V> Codec<V> simpleByNameCodec(BiMap<K, V> map, Codec<K> keyCodec) {
        return keyCodec.flatXmap(key -> {
            Object value = map.get(key);
            if (value == null) {
                return DataResult.error(() -> "Unknown key: " + String.valueOf(key));
            }
            return DataResult.success((Object)value);
        }, value -> {
            Object key = map.inverse().get(value);
            if (key == null) {
                return DataResult.error(() -> "Unknown value: " + String.valueOf(value));
            }
            return DataResult.success((Object)key);
        });
    }

    public static <T> Codec<class_4970.class_4972<T>> stateArgumentPredicate() {
        return new Codec<class_4970.class_4972<T>>(){

            public <R> DataResult<R> encode(class_4970.class_4972<T> input, DynamicOps<R> ops, R prefix) {
                return DataResult.error(() -> "Unsupported operation");
            }

            public <R> DataResult<Pair<class_4970.class_4972<T>, R>> decode(DynamicOps<R> ops, R input) {
                String s;
                Optional booleanValue = ops.getBooleanValue(input).result();
                if (booleanValue.isPresent()) {
                    class_4970.class_4972 predicate = (Boolean)booleanValue.get() != false ? CustomizationCodecs::always : CustomizationCodecs::never;
                    return DataResult.success((Object)Pair.of((Object)predicate, (Object)ops.empty()));
                }
                Optional stringValue = ops.getStringValue(input).result();
                if (stringValue.isPresent() && "ocelot_or_parrot".equals(s = (String)stringValue.get())) {
                    return DataResult.success((Object)Pair.of((state, world, pos, entity) -> entity == class_1299.field_6081 || entity == class_1299.field_6104, (Object)ops.empty()));
                }
                return DataResult.error(() -> "Failed to decode state argument predicate: " + String.valueOf(input));
            }
        };
    }

    public static <T> boolean always(class_2680 blockState, class_1922 blockGetter, class_2338 pos, T t) {
        return true;
    }

    public static <T> boolean never(class_2680 blockState, class_1922 blockGetter, class_2338 pos, T t) {
        return false;
    }

    public static <T> Codec<T> withAlternative(Codec<T> codec, Codec<? extends T> codec2) {
        return new class_5699.class_6495(codec, codec2).xmap(either -> either.map(object -> object, object -> object), Either::left);
    }

    public static <T> Codec<List<T>> compactList(Codec<T> codec) {
        return CustomizationCodecs.withAlternative(codec.listOf(), codec.xmap(List::of, list -> list.get(0)));
    }

    public static <A> MapCodec<Optional<A>> strictOptionalField(Codec<A> codec, String string) {
        return new StrictOptionalFieldCodec<A>(string, codec);
    }

    public static <A> MapCodec<A> strictOptionalField(Codec<A> codec, String string, A object) {
        return CustomizationCodecs.strictOptionalField(codec, string).xmap(optional -> optional.orElse(object), object2 -> Objects.equals(object2, object) ? Optional.empty() : Optional.of(object2));
    }

    static {
        MAP_COLORS.put((Object)"none", (Object)class_3620.field_16008);
        MAP_COLORS.put((Object)"grass", (Object)class_3620.field_15999);
        MAP_COLORS.put((Object)"sand", (Object)class_3620.field_15986);
        MAP_COLORS.put((Object)"wool", (Object)class_3620.field_15979);
        MAP_COLORS.put((Object)"fire", (Object)class_3620.field_16002);
        MAP_COLORS.put((Object)"ice", (Object)class_3620.field_16016);
        MAP_COLORS.put((Object)"metal", (Object)class_3620.field_16005);
        MAP_COLORS.put((Object)"plant", (Object)class_3620.field_16004);
        MAP_COLORS.put((Object)"snow", (Object)class_3620.field_16022);
        MAP_COLORS.put((Object)"clay", (Object)class_3620.field_15976);
        MAP_COLORS.put((Object)"dirt", (Object)class_3620.field_16000);
        MAP_COLORS.put((Object)"stone", (Object)class_3620.field_16023);
        MAP_COLORS.put((Object)"water", (Object)class_3620.field_16019);
        MAP_COLORS.put((Object)"wood", (Object)class_3620.field_15996);
        MAP_COLORS.put((Object)"quartz", (Object)class_3620.field_16025);
        MAP_COLORS.put((Object)"color_orange", (Object)class_3620.field_15987);
        MAP_COLORS.put((Object)"color_magenta", (Object)class_3620.field_15998);
        MAP_COLORS.put((Object)"color_light_blue", (Object)class_3620.field_16024);
        MAP_COLORS.put((Object)"color_yellow", (Object)class_3620.field_16010);
        MAP_COLORS.put((Object)"color_light_green", (Object)class_3620.field_15997);
        MAP_COLORS.put((Object)"color_pink", (Object)class_3620.field_16030);
        MAP_COLORS.put((Object)"color_gray", (Object)class_3620.field_15978);
        MAP_COLORS.put((Object)"color_light_gray", (Object)class_3620.field_15993);
        MAP_COLORS.put((Object)"color_cyan", (Object)class_3620.field_16026);
        MAP_COLORS.put((Object)"color_purple", (Object)class_3620.field_16014);
        MAP_COLORS.put((Object)"color_blue", (Object)class_3620.field_15984);
        MAP_COLORS.put((Object)"color_brown", (Object)class_3620.field_15977);
        MAP_COLORS.put((Object)"color_green", (Object)class_3620.field_15995);
        MAP_COLORS.put((Object)"color_red", (Object)class_3620.field_16020);
        MAP_COLORS.put((Object)"color_black", (Object)class_3620.field_16009);
        MAP_COLORS.put((Object)"gold", (Object)class_3620.field_15994);
        MAP_COLORS.put((Object)"diamond", (Object)class_3620.field_15983);
        MAP_COLORS.put((Object)"lapis", (Object)class_3620.field_15980);
        MAP_COLORS.put((Object)"emerald", (Object)class_3620.field_16001);
        MAP_COLORS.put((Object)"podzol", (Object)class_3620.field_16017);
        MAP_COLORS.put((Object)"nether", (Object)class_3620.field_16012);
        MAP_COLORS.put((Object)"terracotta_white", (Object)class_3620.field_16003);
        MAP_COLORS.put((Object)"terracotta_orange", (Object)class_3620.field_15981);
        MAP_COLORS.put((Object)"terracotta_magenta", (Object)class_3620.field_15985);
        MAP_COLORS.put((Object)"terracotta_light_blue", (Object)class_3620.field_15991);
        MAP_COLORS.put((Object)"terracotta_yellow", (Object)class_3620.field_16013);
        MAP_COLORS.put((Object)"terracotta_light_green", (Object)class_3620.field_16018);
        MAP_COLORS.put((Object)"terracotta_pink", (Object)class_3620.field_15989);
        MAP_COLORS.put((Object)"terracotta_gray", (Object)class_3620.field_16027);
        MAP_COLORS.put((Object)"terracotta_light_gray", (Object)class_3620.field_15988);
        MAP_COLORS.put((Object)"terracotta_cyan", (Object)class_3620.field_15990);
        MAP_COLORS.put((Object)"terracotta_purple", (Object)class_3620.field_16029);
        MAP_COLORS.put((Object)"terracotta_blue", (Object)class_3620.field_16015);
        MAP_COLORS.put((Object)"terracotta_brown", (Object)class_3620.field_15992);
        MAP_COLORS.put((Object)"terracotta_green", (Object)class_3620.field_16028);
        MAP_COLORS.put((Object)"terracotta_red", (Object)class_3620.field_15982);
        MAP_COLORS.put((Object)"terracotta_black", (Object)class_3620.field_16007);
        MAP_COLORS.put((Object)"crimson_nylium", (Object)class_3620.field_25702);
        MAP_COLORS.put((Object)"crimson_stem", (Object)class_3620.field_25703);
        MAP_COLORS.put((Object)"crimson_hyphae", (Object)class_3620.field_25704);
        MAP_COLORS.put((Object)"warped_nylium", (Object)class_3620.field_25705);
        MAP_COLORS.put((Object)"warped_stem", (Object)class_3620.field_25706);
        MAP_COLORS.put((Object)"warped_hyphae", (Object)class_3620.field_25707);
        MAP_COLORS.put((Object)"warped_wart_block", (Object)class_3620.field_25708);
        MAP_COLORS.put((Object)"deepslate", (Object)class_3620.field_33532);
        MAP_COLORS.put((Object)"raw_iron", (Object)class_3620.field_33533);
        MAP_COLORS.put((Object)"glow_lichen", (Object)class_3620.field_33617);
        for (class_2766 instrument : class_2766.values()) {
            if (!instrument.method_47889()) continue;
            INSTRUMENTS.put((Object)instrument.method_15434(), (Object)instrument);
        }
        SENSITIVITIES.put((Object)"everything", (Object)class_2440.class_2441.field_11361);
        SENSITIVITIES.put((Object)"mobs", (Object)class_2440.class_2441.field_11362);
    }

    static final class StrictOptionalFieldCodec<A>
    extends MapCodec<Optional<A>> {
        private final String name;
        private final Codec<A> elementCodec;

        public StrictOptionalFieldCodec(String string, Codec<A> codec) {
            this.name = string;
            this.elementCodec = codec;
        }

        public <T> DataResult<Optional<A>> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
            Object object = mapLike.get(this.name);
            if (object == null) {
                return DataResult.success(Optional.empty());
            }
            return this.elementCodec.parse(dynamicOps, object).map(Optional::of);
        }

        public <T> RecordBuilder<T> encode(Optional<A> optional, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
            if (optional.isPresent()) {
                return recordBuilder.add(this.name, this.elementCodec.encodeStart(dynamicOps, optional.get()));
            }
            return recordBuilder;
        }

        public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
            return Stream.of(dynamicOps.createString(this.name));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof StrictOptionalFieldCodec) {
                StrictOptionalFieldCodec strictOptionalFieldCodec = (StrictOptionalFieldCodec)((Object)object);
                return Objects.equals(this.name, strictOptionalFieldCodec.name) && Objects.equals(this.elementCodec, strictOptionalFieldCodec.elementCodec);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.elementCodec);
        }

        public String toString() {
            return "StrictOptionalFieldCodec[" + this.name + ": " + String.valueOf(this.elementCodec) + "]";
        }
    }
}

