/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import snownee.kiwi.customization.shape.BakingContext;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;
import snownee.kiwi.util.VoxelUtil;

public record SixWayShape(class_265[] shapes, class_265 base, class_265 trueDown, class_265 falseDown) implements ShapeGenerator
{
    private static final List<class_2746> DIRECTION_PROPERTIES = List.of(class_2741.field_12546, class_2741.field_12519, class_2741.field_12489, class_2741.field_12540, class_2741.field_12527, class_2741.field_12487);

    public static ShapeGenerator create(ShapeGenerator base_, ShapeGenerator trueDown_, ShapeGenerator falseDown_) {
        class_265 base = ShapeGenerator.Unit.unboxOrThrow(base_);
        class_265 trueDown = ShapeGenerator.Unit.unboxOrThrow(trueDown_);
        class_265 falseDown = ShapeGenerator.Unit.unboxOrThrow(falseDown_);
        Preconditions.checkArgument((!trueDown.method_1110() || !falseDown.method_1110() ? 1 : 0) != 0);
        class_265[] shapes = new class_265[64];
        return new SixWayShape(shapes, base, trueDown, falseDown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public class_265 getShape(class_2680 blockState, class_3726 context) {
        int index = 0;
        for (int i = 0; i < 6; ++i) {
            if (!((Boolean)blockState.method_11654((class_2769)DIRECTION_PROPERTIES.get(i))).booleanValue()) continue;
            index |= 1 << i;
        }
        class_265 shape = this.shapes[index];
        if (shape != null) return shape;
        class_265[] class_265Array = this.shapes;
        synchronized (this.shapes) {
            shape = this.shapes[index];
            if (shape != null) return shape;
            shape = this.base;
            for (int i = 0; i < 6; ++i) {
                class_265 sideShape = VoxelUtil.rotate((index & 1 << i) != 0 ? this.trueDown : this.falseDown, class_2350.method_10143((int)i));
                shape = class_259.method_1082((class_265)shape, (class_265)sideShape, (class_247)class_247.field_1366);
            }
            this.shapes[index] = shape = shape.method_1097();
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return shape;
        }
    }

    public record Unbaked(UnbakedShape base, UnbakedShape trueDown, UnbakedShape falseDown) implements UnbakedShape
    {
        public static Codec<Unbaked> codec(UnbakedShapeCodec parentCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)parentCodec.fieldOf("base").forGetter(Unbaked::base), (App)parentCodec.fieldOf("true_down").forGetter(Unbaked::trueDown), (App)parentCodec.fieldOf("false_down").forGetter(Unbaked::falseDown)).apply((Applicative)instance, Unbaked::new));
        }

        @Override
        public ShapeGenerator bake(BakingContext context) {
            return SixWayShape.create(this.base.bake(context), this.trueDown.bake(context), this.falseDown.bake(context));
        }

        @Override
        public Stream<UnbakedShape> dependencies() {
            return Stream.of(this.base, this.trueDown, this.falseDown);
        }
    }
}

