/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.command;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1076;
import net.minecraft.class_1921;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2389;
import net.minecraft.class_2397;
import net.minecraft.class_2465;
import net.minecraft.class_2468;
import net.minecraft.class_2477;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2544;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4456;
import net.minecraft.class_4696;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.CustomizationRegistries;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.component.FrontAndTopComponent;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.loader.BlockCodecs;
import snownee.kiwi.customization.block.loader.KBlockComponents;
import snownee.kiwi.datagen.GameObjectLookup;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.DumperOptions;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.Yaml;

public class ExportBlocksCommand {
    public static final Supplier<Map<Class<? extends class_2248>, String>> TEMPLATE_MAPPING = Suppliers.memoize(() -> {
        HashMap map = Maps.newHashMap();
        map.put(class_2510.class, "stair");
        map.put(class_2482.class, "slab");
        map.put(class_2544.class, "wall");
        map.put(class_2354.class, "fence");
        map.put(class_2349.class, "fence_gate");
        map.put(class_2323.class, "door");
        map.put(class_2533.class, "trapdoor");
        map.put(class_2389.class, "iron_bars");
        map.put(class_2465.class, "rotated_pillar");
        map.put(class_2397.class, "leaves");
        map.put(class_2468.class, "colored_falling");
        return map;
    });
    private static final Map<KBlockSettings, KBlockSettings.MoreInfo> MORE_INFO = Maps.newHashMap();
    private static final Supplier<Yaml> YAML = Suppliers.memoize(() -> {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        return new Yaml(dumperOptions);
    });

    public static void register(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"blocks").executes(ctx -> ExportBlocksCommand.exportBlocks((class_2168)ctx.getSource(), class_7923.field_41178.method_10221((Object)((class_2168)ctx.getSource()).method_9207().method_6047().method_7909()).method_12836()))).then(class_2170.method_9244((String)"modId", (ArgumentType)StringArgumentType.string()).executes(ctx -> ExportBlocksCommand.exportBlocks((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"modId")))));
    }

    private static int exportBlocks(class_2168 source, String modId) {
        class_1076 languageManager = class_310.method_1551().method_1526();
        class_2477 language = null;
        String languageCode = languageManager.method_4669();
        if (!"en_us".equals(languageCode)) {
            languageManager.method_4667("en_us");
            class_3300 resourceManager = class_310.method_1551().method_1478();
            languageManager.method_14491(resourceManager);
            language = class_2477.method_10517();
            languageManager.method_4667(languageCode);
            languageManager.method_14491(resourceManager);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get("exported_blocks_" + modId + ".csv", new String[0]), new OpenOption[0]);){
            LinkedHashMap row = Maps.newLinkedHashMap();
            row.put("ID", "");
            if (language != null) {
                row.put("Name:en_us", "");
            }
            row.put("Name:" + languageCode, "");
            row.put("Template", "");
            row.put("RenderType", "");
            row.put("LightEmission", "");
            row.put("GlassType", "");
            row.put("SustainsPlant", "");
            row.put("WaterLoggable", "");
            row.put("BaseComponent", "");
            row.put("ExtraComponents", "");
            KBlockSettings.MoreInfo fallbackMoreInfo = new KBlockSettings.MoreInfo(null, null, null);
            if (KiwiClientConfig.exportBlocksMore) {
                row.put("Shape", "");
                row.put("CollisionShape", "");
                row.put("InteractionShape", "");
            }
            row.put("NoCollision", "");
            row.put("NoOcclusion", "");
            Set<KBlockComponent.Type<FrontAndTopComponent>> baseComponents = Set.of(KBlockComponents.DIRECTIONAL.get(), KBlockComponents.HORIZONTAL.get(), KBlockComponents.MOULDING.get(), KBlockComponents.HORIZONTAL_AXIS.get(), KBlockComponents.FRONT_AND_TOP.get());
            Codec componentsCodec = Codec.list((Codec)CustomizationRegistries.BLOCK_COMPONENT.method_39673().dispatch("type", KBlockComponent::type, KBlockComponent.Type::codec));
            class_4456 csvOutput = row.keySet().stream().reduce(class_4456.method_21627(), class_4456.class_4457::method_21632, (builder1, builder2) -> {
                throw new UnsupportedOperationException();
            }).method_21631((Writer)writer);
            for (class_2248 block : GameObjectLookup.all(class_7924.field_41254, modId).toList()) {
                KBlockSettings settings;
                Object template = TEMPLATE_MAPPING.get().getOrDefault(block.getClass(), "block");
                if ("ignore".equals(template)) continue;
                if ("door".equals(template) || "trapdoor".equals(template)) {
                    Codec codec = BlockCodecs.get(new class_2960((String)template)).codec();
                    template = (String)template + ExportBlocksCommand.toYaml(codec, block, json -> {
                        json.getAsJsonObject().remove("properties");
                        return json;
                    });
                }
                row.put("Template", template);
                row.put("ID", class_7923.field_41175.method_10221((Object)block).method_12832());
                row.put("Name:" + languageCode, block.method_9518().getString());
                if (language != null && language.method_4678(block.method_9539())) {
                    String englishName = language.method_48307(block.method_9539());
                    row.put("Name:en_us", englishName);
                    if (englishName.equals(block.method_9518().getString())) {
                        row.put("Name:" + languageCode, "");
                    }
                }
                KiwiModule.RenderLayer.Layer layer = null;
                class_1921 renderType = class_4696.method_23679((class_2680)block.method_9564());
                if (renderType == class_1921.method_23581()) {
                    layer = KiwiModule.RenderLayer.Layer.CUTOUT;
                } else if (renderType == class_1921.method_23579()) {
                    layer = KiwiModule.RenderLayer.Layer.CUTOUT_MIPPED;
                } else if (renderType == class_1921.method_23583()) {
                    layer = KiwiModule.RenderLayer.Layer.TRANSLUCENT;
                }
                row.put("RenderType", layer == null ? "solid" : layer.name().toLowerCase(Locale.ENGLISH));
                int lightEmission = -1;
                for (class_2680 blockState : block.method_9595().method_11662()) {
                    if (lightEmission == -1) {
                        lightEmission = blockState.method_26213();
                        continue;
                    }
                    if (lightEmission == blockState.method_26213()) continue;
                    lightEmission = -2;
                    row.put("LightEmission", "custom");
                    break;
                }
                if (lightEmission >= 0) {
                    row.put("LightEmission", Integer.toString(lightEmission));
                }
                if ((settings = KBlockSettings.of(block)) == null) {
                    settings = KBlockSettings.empty();
                }
                if (settings.glassType == null) {
                    row.put("GlassType", "");
                } else if (settings.glassType == CustomizationHooks.clearGlassType()) {
                    row.put("GlassType", "clear");
                } else {
                    row.put("GlassType", "unknown");
                }
                row.put("WaterLoggable", Boolean.toString(settings.hasComponent(KBlockComponents.WATER_LOGGABLE.get())));
                KBlockComponent.Type baseComponent = settings.components.keySet().stream().filter(baseComponents::contains).findFirst().orElse(null);
                row.put("BaseComponent", baseComponent == null ? "" : CustomizationRegistries.BLOCK_COMPONENT.method_10221((Object)baseComponent).method_12832());
                List<KBlockComponent> components = settings.components.values().stream().filter(component -> !KBlockComponents.WATER_LOGGABLE.is(component.type()) && !baseComponents.contains(component.type())).toList();
                if (components.isEmpty()) {
                    row.put("ExtraComponents", "");
                } else {
                    row.put("ExtraComponents", ExportBlocksCommand.toYaml(componentsCodec, components, null));
                }
                if (KiwiClientConfig.exportBlocksMore) {
                    KBlockSettings.MoreInfo moreInfo = MORE_INFO.getOrDefault(settings, fallbackMoreInfo);
                    row.put("Shape", Optional.ofNullable(moreInfo.shape()).map(Object::toString).orElse(""));
                    row.put("CollisionShape", Optional.ofNullable(moreInfo.collisionShape()).map(Object::toString).orElse(""));
                    row.put("InteractionShape", Optional.ofNullable(moreInfo.interactionShape()).map(Object::toString).orElse(""));
                }
                class_4970.class_2251 properties = block.field_23155;
                row.put("NoCollision", Boolean.toString(!properties.field_10664));
                row.put("NoOcclusion", Boolean.toString(!properties.field_20721));
                csvOutput.method_21630((Object[])row.values().toArray(Object[]::new));
            }
        }
        catch (Exception e) {
            Kiwi.LOGGER.error("Failed to export blocks", (Throwable)e);
            source.method_9213((class_2561)class_2561.method_43470((String)("Failed to export blocks: " + e.getMessage())));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"Blocks exported"), false);
        return 1;
    }

    public static void putMoreInfo(KBlockSettings settings, KBlockSettings.MoreInfo moreInfo) {
        MORE_INFO.put(settings, moreInfo);
    }

    public static <T> String toYaml(Codec<T> codec, T value, @Nullable UnaryOperator<JsonElement> decorator) {
        JsonElement json = (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).result().orElseThrow();
        if (decorator != null) {
            json = (JsonElement)decorator.apply(json);
        }
        if (json.isJsonObject() && json.getAsJsonObject().size() == 0) {
            return "";
        }
        Yaml yaml = YAML.get();
        return yaml.dump(yaml.load(json.toString())).trim();
    }
}

