/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_8494;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class ItemButton
extends class_4185 {
    private final class_1799 itemStack;
    private final boolean inContainer;
    private class_8000 tooltipPositioner;
    private float hoverProgress;
    private float pressTime = -1.0f;
    @Nullable
    public Consumer<ItemButton> onPress;
    @Nullable
    public Consumer<ItemButton> onRelease;
    @Nullable
    public class_7919 rawTooltip;

    protected ItemButton(Builder builder) {
        super(builder.field_40759, builder.field_40760, builder.field_40761, builder.field_40762, builder.field_40756, builder.field_40757, builder.field_40763);
        this.itemStack = builder.itemStack;
        this.inContainer = builder.inContainer;
    }

    public static Builder builder(class_1799 itemStack, boolean inContainer, class_4185.class_4241 pOnPress) {
        return new Builder(itemStack, inContainer, pOnPress);
    }

    public void method_47400(@Nullable class_7919 tooltip) {
        this.rawTooltip = tooltip;
    }

    @Nullable
    public class_7919 method_51254() {
        return this.rawTooltip;
    }

    public class_1799 item() {
        return this.itemStack;
    }

    public int pressTime() {
        return (int)this.pressTime;
    }

    public void unpress() {
        this.pressTime = -1.0f;
    }

    protected void method_48579(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        class_437 screen;
        if ((this.rawTooltip != null && this.method_49606() || this.method_25370() && class_310.method_1551().method_48186().method_48183()) && (screen = class_310.method_1551().field_1755) != null) {
            screen.method_47412(this.rawTooltip, class_8001.field_41687, true);
        }
        if (this.pressTime >= 0.0f) {
            int i = (int)this.pressTime;
            this.pressTime += pPartialTick;
            if (this.onPress != null && i != (int)this.pressTime) {
                this.onPress.accept(this);
            }
        }
        int x = this.method_46426();
        int y = this.method_46427();
        int width = this.method_25368() - 1;
        int height = this.method_25364() - 1;
        if (this.inContainer) {
            pGuiGraphics.method_25294(x + 1, y + 1, x + width - 1, y + height - 1, 0x222222 | (int)(this.field_22765 * 255.0f) << 24);
        } else {
            pGuiGraphics.method_25294(x, y, x + width, y + height, 0x222222 | (int)(this.field_22765 * 255.0f) << 24);
        }
        this.hoverProgress += this.method_25367() ? pPartialTick * 0.2f : -pPartialTick * 0.2f;
        this.hoverProgress = class_3532.method_15363((float)this.hoverProgress, (float)(this.inContainer ? 0.0f : 0.4f), (float)1.0f);
        int lineColor = 0xFFFFFF | (int)(this.hoverProgress * 255.0f) << 24;
        pGuiGraphics.method_25294(x, y, x + 1, y + height, lineColor);
        pGuiGraphics.method_25294(x + width - 1, y, x + width, y + height, lineColor);
        pGuiGraphics.method_25294(x + 1, y, x + width - 1, y + 1, lineColor);
        pGuiGraphics.method_25294(x + 1, y + height - 1, x + width - 1, y + height, lineColor);
        pGuiGraphics.method_51427(this.itemStack, x + 2, y + 2);
    }

    public void setTooltipPositioner(class_8000 tooltipPositioner) {
        this.tooltipPositioner = tooltipPositioner;
    }

    protected class_8000 method_47937() {
        return this.tooltipPositioner != null ? this.tooltipPositioner : super.method_47937();
    }

    public void method_25306() {
        super.method_25306();
        this.pressTime = 0.0f;
    }

    public void method_25357(double mouseX, double mouseY) {
        this.onRelease();
    }

    public boolean method_16803(int button, int p_94751_, int p_94752_) {
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        if (class_8494.method_51255((int)button)) {
            this.onRelease();
            return true;
        }
        return false;
    }

    public void onRelease() {
        if (this.onRelease != null && this.pressTime >= 0.0f) {
            this.onRelease.accept(this);
        }
        this.pressTime = -1.0f;
    }

    public static class Builder
    extends class_4185.class_7840 {
        private final class_1799 itemStack;
        private final boolean inContainer;

        protected Builder(class_1799 itemStack, boolean inContainer, class_4185.class_4241 pOnPress) {
            super(itemStack.method_7964(), pOnPress);
            this.itemStack = itemStack;
            this.inContainer = inContainer;
        }

        public ItemButton build() {
            return new ItemButton(this);
        }
    }
}

