/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.GlassType;
import snownee.kiwi.customization.block.behavior.CanSurviveHandler;
import snownee.kiwi.customization.block.component.DirectionalComponent;
import snownee.kiwi.customization.block.component.HorizontalComponent;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.component.WaterLoggableComponent;
import snownee.kiwi.customization.duck.KBlockProperties;
import snownee.kiwi.customization.placement.PlaceChoices;
import snownee.kiwi.customization.shape.BlockShapeType;
import snownee.kiwi.customization.shape.ConfiguringShape;
import snownee.kiwi.customization.shape.ShapeGenerator;

public class KBlockSettings {
    public final boolean customPlacement;
    @Nullable
    public final GlassType glassType;
    @Nullable
    public final CanSurviveHandler canSurviveHandler;
    @Nullable
    public final ToIntFunction<class_2680> analogOutputSignal;
    public final Map<KBlockComponent.Type<?>, KBlockComponent> components;
    @Nullable
    private ShapeGenerator[] shapes;
    @Nullable
    public PlaceChoices placeChoices;

    private KBlockSettings(Builder builder) {
        this.customPlacement = builder.customPlacement;
        this.glassType = builder.glassType;
        this.canSurviveHandler = builder.canSurviveHandler;
        this.analogOutputSignal = builder.getAnalogOutputSignal();
        this.components = Map.copyOf(builder.components);
        for (BlockShapeType type : BlockShapeType.VALUES) {
            this.setShape(type, builder.getShape(type));
        }
    }

    public static KBlockSettings empty() {
        return new KBlockSettings(KBlockSettings.builder());
    }

    public static Builder builder() {
        return new Builder(class_4970.class_2251.method_9637());
    }

    public static Builder copyProperties(class_2248 block) {
        return new Builder(class_4970.class_2251.method_9630((class_4970)block));
    }

    public static Builder copyProperties(class_2248 block, class_3620 mapColor) {
        return new Builder(class_4970.class_2251.method_9630((class_4970)block).method_31710(mapColor));
    }

    @Nullable
    public static KBlockSettings of(Object block) {
        return ((KBlockProperties)((class_4970)block).field_23155).kiwi$getSettings();
    }

    public static class_265 getGlassFaceShape(class_2680 blockState, class_2350 direction) {
        KBlockSettings settings = KBlockSettings.of(blockState.method_26204());
        if (settings == null) {
            class_265 shape = blockState.method_26172((class_1922)class_2682.field_12294, class_2338.field_10980, class_3726.method_16194());
            return class_2248.method_9614((class_265)shape) ? class_259.method_1077() : class_259.method_1073();
        }
        if (settings.glassType == null) {
            return class_259.method_1073();
        }
        class_265 shape = blockState.method_26172((class_1922)class_2682.field_12294, class_2338.field_10980, class_3726.method_16194());
        if (shape.method_1110()) {
            return class_259.method_1073();
        }
        return class_259.method_16344((class_265)shape, (class_2350)direction);
    }

    public boolean hasComponent(KBlockComponent.Type<?> type) {
        return this.components.containsKey(type);
    }

    public <T extends KBlockComponent> T getComponent(KBlockComponent.Type<T> type) {
        return (T)this.components.get(type);
    }

    public void injectProperties(class_2248 block, class_2689.class_2690<class_2248, class_2680> builder) {
        for (KBlockComponent component : this.components.values()) {
            component.injectProperties(block, builder);
        }
    }

    public class_2680 registerDefaultState(class_2680 state) {
        for (KBlockComponent component : this.components.values()) {
            state = component.registerDefaultState(state);
        }
        return state;
    }

    @Nullable
    public class_2680 getStateForPlacement(class_2680 blockState, class_1750 context) {
        for (KBlockComponent component : this.components.values()) {
            blockState = component.getStateForPlacement(this, blockState, context);
            if (blockState != null && blockState.method_27852(blockState.method_26204())) continue;
            return blockState;
        }
        if (!(this.placeChoices == null || this.placeChoices.skippable() && context.method_8046())) {
            blockState = this.placeChoices.getStateForPlacement(context.method_8045(), context.method_8037(), blockState);
        }
        return blockState;
    }

    public class_2680 updateShape(class_2680 pState, class_2350 pDirection, class_2680 pNeighborState, class_1936 pLevel, class_2338 pPos, class_2338 pNeighborPos) {
        for (KBlockComponent component : this.components.values()) {
            pState = component.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
        }
        return pState;
    }

    public class_2680 rotate(class_2680 pState, class_2470 pRotation) {
        for (KBlockComponent component : this.components.values()) {
            pState = component.rotate(pState, pRotation);
        }
        return pState;
    }

    public class_2680 mirror(class_2680 pState, class_2415 pMirror) {
        for (KBlockComponent component : this.components.values()) {
            pState = component.mirror(pState, pMirror);
        }
        return pState;
    }

    public boolean useShapeForLightOcclusion(class_2680 pState) {
        for (KBlockComponent component : this.components.values()) {
            if (!component.useShapeForLightOcclusion(pState)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Boolean canBeReplaced(class_2680 state, class_1750 context) {
        for (KBlockComponent component : this.components.values()) {
            Boolean result = component.canBeReplaced(state, context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public ConfiguringShape removeIfPossible(BlockShapeType shapeType) {
        ShapeGenerator shapeGenerator = this.getShape(shapeType);
        if (shapeGenerator instanceof ConfiguringShape) {
            ConfiguringShape shape = (ConfiguringShape)shapeGenerator;
            this.setShape(shapeType, null);
            return shape;
        }
        return null;
    }

    @Nullable
    public ShapeGenerator getShape(BlockShapeType shapeType) {
        return this.shapes != null ? this.shapes[shapeType.ordinal()] : null;
    }

    private void setShape(BlockShapeType shapeType, @Nullable ShapeGenerator shape) {
        if (shape != null) {
            if (this.shapes == null) {
                this.shapes = new ShapeGenerator[BlockShapeType.VALUES.size()];
            }
            this.shapes[shapeType.ordinal()] = shape;
        } else if (this.shapes != null) {
            this.shapes[shapeType.ordinal()] = null;
        }
    }

    public static class Builder {
        private final class_4970.class_2251 properties;
        private boolean customPlacement;
        @Nullable
        private GlassType glassType;
        private final ShapeGenerator[] shapes = new ShapeGenerator[BlockShapeType.VALUES.size()];
        @Nullable
        private CanSurviveHandler canSurviveHandler;
        private final Map<KBlockComponent.Type<?>, KBlockComponent> components = Maps.newLinkedHashMap();
        @Nullable
        private ToIntFunction<class_2680> analogOutputSignal;

        private Builder(class_4970.class_2251 properties) {
            this.properties = properties;
        }

        public class_4970.class_2251 get() {
            KBlockSettings settings = new KBlockSettings(this);
            ((KBlockProperties)this.properties).kiwi$setSettings(settings);
            return this.properties;
        }

        @CanIgnoreReturnValue
        public Builder configure(Consumer<class_4970.class_2251> configurator) {
            configurator.accept(this.properties);
            return this;
        }

        public Builder noOcclusion() {
            this.properties.method_22488();
            return this;
        }

        public Builder noCollision() {
            this.properties.method_9634();
            return this;
        }

        public Builder customPlacement() {
            this.customPlacement = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder glassType(GlassType glassType) {
            this.glassType = glassType;
            return this;
        }

        public Builder shape(BlockShapeType type, ShapeGenerator shape) {
            this.shapes[type.ordinal()] = shape;
            return this;
        }

        @Nullable
        private ShapeGenerator getShape(BlockShapeType type) {
            return this.shapes[type.ordinal()];
        }

        @CanIgnoreReturnValue
        public Builder canSurviveHandler(CanSurviveHandler canSurviveHandler) {
            this.canSurviveHandler = canSurviveHandler;
            return this;
        }

        public Builder component(KBlockComponent component) {
            KBlockComponent before = this.components.put(component.type(), component);
            Preconditions.checkState((before == null ? 1 : 0) != 0, (String)"Component %s is already present", component.type());
            return this;
        }

        public Builder waterLoggable() {
            return this.component(WaterLoggableComponent.getInstance());
        }

        public Builder horizontal() {
            return this.component(HorizontalComponent.getInstance(false));
        }

        public Builder directional() {
            return this.component(DirectionalComponent.getInstance(false));
        }

        public boolean hasComponent(KBlockComponent.Type<?> type) {
            return this.components.containsKey(type);
        }

        @CanIgnoreReturnValue
        public Builder removeComponent(KBlockComponent.Type<?> type) {
            this.components.remove(type);
            return this;
        }

        @Nullable
        public ToIntFunction<class_2680> getAnalogOutputSignal() {
            if (this.analogOutputSignal != null) {
                return this.analogOutputSignal;
            }
            for (KBlockComponent component : this.components.values()) {
                if (!component.hasAnalogOutputSignal()) continue;
                return component::getAnalogOutputSignal;
            }
            return null;
        }
    }

    @Deprecated
    public record MoreInfo(class_2960 shape, class_2960 collisionShape, class_2960 interactionShape) {
    }
}

