/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import snownee.kiwi.util.Util;
import snownee.kiwi.util.resource.AlternativesFileToIdConverter;
import snownee.kiwi.util.resource.OneTimeLoader;

public record CustomizationMetadata(ImmutableListMultimap<String, String> registryOrder, List<String> lenientBETypeNamespaces) {
    public static final Codec<CustomizationMetadata> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()).fieldOf("registry_order").forGetter($ -> {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : $.registryOrder().asMap().entrySet()) {
            map.put((String)entry.getKey(), List.copyOf((Collection)entry.getValue()));
        }
        return map;
    }), (App)Codec.STRING.listOf().optionalFieldOf("lenient_be_type_namespaces", List.of()).forGetter(CustomizationMetadata::lenientBETypeNamespaces)).apply((Applicative)instance, CustomizationMetadata::create));

    public static CustomizationMetadata create(Map<String, List<String>> map, List<String> lenientBETypeNamespaces) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        map.forEach((arg_0, arg_1) -> ((ImmutableListMultimap.Builder)builder).putAll(arg_0, arg_1));
        return new CustomizationMetadata((ImmutableListMultimap<String, String>)builder.build(), lenientBETypeNamespaces);
    }

    public static Map<String, CustomizationMetadata> loadMap(class_3300 resourceManager, OneTimeLoader.Context context) {
        CustomizationMetadata emptyMetadata = new CustomizationMetadata((ImmutableListMultimap<String, String>)ImmutableListMultimap.of(), List.of());
        AlternativesFileToIdConverter fileToIdConverter = AlternativesFileToIdConverter.yamlOrJson("kiwi");
        HashMap metadataMap = Maps.newHashMap();
        for (String namespace : resourceManager.method_14487()) {
            class_2960 file = fileToIdConverter.idToFile(new class_2960(namespace, "metadata"));
            Optional resource = resourceManager.method_14486(file);
            if (resource.isEmpty()) {
                metadataMap.put(namespace, emptyMetadata);
                continue;
            }
            DataResult<CustomizationMetadata> result = OneTimeLoader.parseFile(file, (class_3298)resource.get(), CODEC, context);
            if (result == null) {
                context.addDisabledNamespace(namespace);
                continue;
            }
            result.result().ifPresentOrElse(customizationMetadata -> metadataMap.put(namespace, customizationMetadata), () -> context.addDisabledNamespace(namespace));
        }
        return metadataMap;
    }

    public static <T> void sortedForEach(Map<String, CustomizationMetadata> metadataMap, String key, Map<class_2960, T> values, BiConsumer<class_2960, T> action) {
        CustomizationMetadata.sortedForEach(metadataMap, List.of(key), values, action);
    }

    public static <T> void sortedForEach(Map<String, CustomizationMetadata> metadataMap, List<String> keys, Map<class_2960, T> values, BiConsumer<class_2960, T> action) {
        LinkedHashSet order = Sets.newLinkedHashSet();
        for (String key : keys) {
            metadataMap.forEach((namespace, metadata) -> {
                for (String s : metadata.registryOrder().get((Object)key)) {
                    order.add(Util.RL(s, namespace));
                }
            });
        }
        for (class_2960 id2 : order) {
            T value2 = values.get(id2);
            if (value2 == null) continue;
            action.accept(id2, (class_2960)value2);
        }
        values.forEach((id, value) -> {
            if (!order.contains(id)) {
                action.accept((class_2960)id, (class_2960)value);
            }
        });
    }
}

