/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.renderlayers;

import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.api.LayerFeatureTransformerAPI;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.OffsetProvider;
import dev.tr7zw.skinlayers.api.PlayerData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_922;

public class CustomLayerFeatureRenderer
extends class_3887<class_742, class_591<class_742>> {
    private static final class_310 mc = class_310.method_1551();
    private final List<Layer> bodyLayers = new ArrayList<Layer>();
    private final boolean thinArms = ((PlayerEntityModelAccessor)this.method_17165()).hasThinArms();

    public CustomLayerFeatureRenderer(class_3883<class_742, class_591<class_742>> renderLayerParent) {
        super(renderLayerParent);
        this.bodyLayers.add(new Layer(PlayerData::getHeadMesh, class_1664.field_7563, OffsetProvider.HEAD, () -> ((class_591)this.method_17165()).field_3398, player -> {
            class_1799 itemStack = player.method_6118(class_1304.field_6169);
            if (itemStack != null && SkinLayersModBase.hideHeadLayers.contains(itemStack.method_7909())) {
                return false;
            }
            return SkinLayersModBase.config.enableHat;
        }));
        this.bodyLayers.add(new Layer(PlayerData::getLeftLegMesh, class_1664.field_7566, OffsetProvider.LEFT_LEG, () -> ((class_591)this.method_17165()).field_3397, player -> SkinLayersModBase.config.enableLeftPants));
        this.bodyLayers.add(new Layer(PlayerData::getRightLegMesh, class_1664.field_7565, OffsetProvider.RIGHT_LEG, () -> ((class_591)this.method_17165()).field_3392, player -> SkinLayersModBase.config.enableRightPants));
        this.bodyLayers.add(new Layer(PlayerData::getLeftArmMesh, class_1664.field_7568, this.thinArms ? OffsetProvider.LEFT_ARM_SLIM : OffsetProvider.LEFT_ARM, () -> ((class_591)this.method_17165()).field_27433, player -> SkinLayersModBase.config.enableLeftSleeve));
        this.bodyLayers.add(new Layer(PlayerData::getRightArmMesh, class_1664.field_7570, this.thinArms ? OffsetProvider.RIGHT_ARM_SLIM : OffsetProvider.RIGHT_ARM, () -> ((class_591)this.method_17165()).field_3401, player -> SkinLayersModBase.config.enableRightSleeve));
        this.bodyLayers.add(new Layer(PlayerData::getTorsoMesh, class_1664.field_7564, OffsetProvider.BODY, () -> ((class_591)this.method_17165()).field_3391, player -> SkinLayersModBase.config.enableJacket));
    }

    public void render(class_4587 poseStack, class_4597 multiBufferSource, int i, class_742 player, float f, float g, float h, float j, float k, float l) {
        if (SkinLayersModBase.config.compatibilityMode || player.method_5767()) {
            return;
        }
        if (CustomLayerFeatureRenderer.mc.field_1687 == null) {
            return;
        }
        if (player.method_5707(CustomLayerFeatureRenderer.mc.field_1773.method_19418().method_19326()) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        if (!SkinUtil.setup3dLayers(player, settings, this.thinArms)) {
            return;
        }
        class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_24294((class_2960)player.method_3117(), (boolean)true));
        int m = class_922.method_23622((class_1309)player, (float)0.0f);
        this.renderLayers(player, settings, poseStack, vertexConsumer, i, m);
    }

    public void renderLayers(class_742 abstractClientPlayer, PlayerSettings settings, class_4587 matrixStack, class_4588 vertices, int light, int overlay) {
        for (Layer layer : this.bodyLayers) {
            Mesh mesh = layer.meshGetter.apply(settings);
            if (mesh == null || !abstractClientPlayer.method_7348(layer.modelPart) || !layer.vanillaGetter.get().field_3665 || !layer.configGetter.apply(abstractClientPlayer).booleanValue()) continue;
            matrixStack.method_22903();
            LayerFeatureTransformerAPI.getTransformer().transform(abstractClientPlayer, matrixStack, layer.vanillaGetter.get());
            layer.vanillaGetter.get().method_22703(matrixStack);
            layer.offset.applyOffset(matrixStack, mesh);
            mesh.render(layer.vanillaGetter.get(), matrixStack, vertices, light, overlay, -1);
            matrixStack.method_22909();
        }
    }

    private static class Layer {
        private final Function<PlayerSettings, Mesh> meshGetter;
        private final class_1664 modelPart;
        private final OffsetProvider offset;
        private final Supplier<class_630> vanillaGetter;
        private final Function<class_742, Boolean> configGetter;

        @Generated
        public Layer(Function<PlayerSettings, Mesh> meshGetter, class_1664 modelPart, OffsetProvider offset, Supplier<class_630> vanillaGetter, Function<class_742, Boolean> configGetter) {
            this.meshGetter = meshGetter;
            this.modelPart = modelPart;
            this.offset = offset;
            this.vanillaGetter = vanillaGetter;
            this.configGetter = configGetter;
        }
    }
}

