/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.client.GuiGraphicsUtils;
import io.wispforest.accessories.client.gui.AccessoriesInternalSlot;
import io.wispforest.accessories.client.gui.SpriteGetter;
import io.wispforest.accessories.client.gui.ToggleButton;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.impl.SlotGroupImpl;
import io.wispforest.accessories.mixin.client.ScreenAccessor;
import io.wispforest.accessories.networking.holder.HolderProperty;
import io.wispforest.accessories.networking.holder.SyncHolderChange;
import io.wispforest.accessories.networking.server.MenuScroll;
import io.wispforest.accessories.pond.ContainerScreenExtension;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7919;
import org.apache.commons.lang3.Range;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector4i;

public class AccessoriesScreen
extends class_465<AccessoriesMenu>
implements ContainerScreenExtension {
    private static final class_2960 SLOT = Accessories.of("textures/gui/slot.png");
    private static final class_2960 ACCESSORIES_INVENTORY_LOCATION = Accessories.of("textures/gui/container/accessories_inventory.png");
    private static final class_2960 BACKGROUND_PATCH = Accessories.of("background_patch");
    private static final class_2960 SCROLL_BAR_PATCH = Accessories.of("scroll_bar_patch");
    private static final class_2960 SCROLL_BAR = Accessories.of("scroll_bar");
    private static final class_2960 HORIZONTAL_TABS;
    public static final SpriteGetter<class_4264> SPRITES_12X12;
    public static final SpriteGetter<class_4264> SPRITES_8X8;
    private static final class_2960 BACk_ICON;
    private static final class_2960 LINE_HIDDEN;
    private static final class_2960 LINE_SHOWN;
    private static final class_2960 UNUSED_SLOTS_HIDDEN;
    private static final class_2960 UNUSED_SLOTS_SHOWN;
    public static Vector4i SCISSOR_BOX;
    public static boolean IS_RENDERING_UI_ENTITY;
    public static boolean IS_RENDERING_LINE_TARGET;
    public static boolean COLLECT_ACCESSORY_POSITIONS;
    public static final Map<String, Vector3d> NOT_VERY_NICE_POSITIONS;
    public static boolean FORCE_TOOLTIP_LEFT;
    private final List<Pair<Vector3d, Vector3d>> accessoryLines = new ArrayList<Pair<Vector3d, Vector3d>>();
    private final List<Vector3d> accessoryPositions = new ArrayList<Vector3d>();
    private final Map<AccessoriesInternalSlot, ToggleButton> cosmeticButtons = new LinkedHashMap<AccessoriesInternalSlot, ToggleButton>();
    private int currentTabPage = 1;
    private int scrollBarHeight = 0;
    private boolean isScrolling = false;
    private static final int upperPadding = 8;
    private class_4185 backButton = null;
    private class_4185 cosmeticToggleButton = null;
    private class_4185 linesToggleButton = null;
    private class_4185 unusedSlotsToggleButton = null;
    private class_4185 uniqueSlotsToggleButton = null;
    private class_4185 tabUpButton = null;
    private class_4185 tabDownButton = null;

    public AccessoriesScreen(AccessoriesMenu menu, class_1661 inventory, class_2561 component) {
        super((class_1703)menu, inventory, (class_2561)class_2561.method_43473());
        this.field_25267 = 97;
        this.field_25269 = 42069;
    }

    public int getPanelHeight() {
        return this.getPanelHeight(8);
    }

    public int getPanelHeight(int upperPadding) {
        return 14 + Math.min(((AccessoriesMenu)this.field_2797).totalSlots, 8) * 18 + upperPadding;
    }

    public int getPanelWidth() {
        int width = 44;
        if (((AccessoriesMenu)this.field_2797).isCosmeticsOpen()) {
            width += 20;
        }
        if (!((AccessoriesMenu)this.field_2797).overMaxVisibleSlots) {
            width -= 12;
        }
        return width;
    }

    public int getStartingPanelX() {
        int x = this.field_2776 - (((AccessoriesMenu)this.field_2797).isCosmeticsOpen() ? 72 : 52);
        if (!((AccessoriesMenu)this.field_2797).overMaxVisibleSlots) {
            x += 12;
        }
        return x;
    }

    public int leftPos() {
        return this.field_2776;
    }

    public int topPos() {
        return this.field_2800;
    }

    public final class_1309 targetEntityDefaulted() {
        class_1309 targetEntity = ((AccessoriesMenu)this.field_2797).targetEntity();
        return targetEntity != null ? targetEntity : this.field_22787.field_1724;
    }

    protected boolean insideScrollbar(double mouseX, double mouseY) {
        int x = this.getStartingPanelX() + 13;
        int y = this.field_2800 + 7 + 8;
        int height = this.getPanelHeight() - 22;
        int width = 8;
        return ((AccessoriesMenu)this.field_2797).overMaxVisibleSlots && mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + width) && mouseY < (double)(y + height);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean bl = super.method_25402(mouseX, mouseY, button);
        if (this.method_25399() instanceof class_4185) {
            ((ScreenAccessor)((Object)this)).call$clearFocus();
        }
        if (this.insideScrollbar(mouseX, mouseY)) {
            this.isScrolling = true;
            return true;
        }
        if (Accessories.getConfig().clientData.showGroupTabs && ((AccessoriesMenu)this.field_2797).maxScrollableIndex() > 0) {
            int x = this.getStartingPanelX();
            int y = this.field_2800;
            for (SlotGroupData value : this.getGroups(x, y).values()) {
                if (!value.isInBounds((int)Math.round(mouseX), (int)Math.round(mouseY))) continue;
                int index = value.startingIndex;
                if (index > ((AccessoriesMenu)this.field_2797).maxScrollableIndex()) {
                    index = ((AccessoriesMenu)this.field_2797).maxScrollableIndex();
                }
                if (index == ((AccessoriesMenu)this.field_2797).scrolledIndex) break;
                AccessoriesInternals.getNetworkHandler().sendToServer(new MenuScroll(index, false));
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                break;
            }
        }
        return bl;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.insideScrollbar(mouseX, mouseY) && button == 0) {
            this.isScrolling = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        AccessoriesInternalSlot slot2;
        class_1735 class_17352;
        this.method_25420(guiGraphics);
        int leftPos = this.field_2776;
        int topPos = this.field_2800;
        guiGraphics.method_25302(ACCESSORIES_INVENTORY_LOCATION, leftPos, topPos, 0, 0, this.field_2792, this.field_2779);
        Vector2i scissorStart = new Vector2i(leftPos + 26, topPos + 8);
        Vector2i scissorEnd = new Vector2i(leftPos + 26 + 124, topPos + 8 + 70);
        Vector2i size = new Vector2i((scissorEnd.x - scissorStart.x) / 2, scissorEnd.y - scissorStart.y);
        SCISSOR_BOX.set(scissorStart.x, scissorStart.y, scissorEnd.x, scissorEnd.y);
        COLLECT_ACCESSORY_POSITIONS = Accessories.getConfig().clientData.hoverOptions.hoveredOptions.line || Accessories.getConfig().clientData.hoverOptions.hoveredOptions.clickbait;
        IS_RENDERING_UI_ENTITY = true;
        IS_RENDERING_LINE_TARGET = true;
        this.renderEntityInInventoryFollowingMouseRotated(guiGraphics, scissorStart, size, scissorStart, scissorEnd, mouseX, mouseY, 0.0f);
        IS_RENDERING_LINE_TARGET = false;
        this.renderEntityInInventoryFollowingMouseRotated(guiGraphics, new Vector2i((Vector2ic)scissorStart).add(size.x, 0), size, scissorStart, scissorEnd, mouseX, mouseY, 180.0f);
        IS_RENDERING_UI_ENTITY = false;
        COLLECT_ACCESSORY_POSITIONS = false;
        class_4587 pose = guiGraphics.method_51448();
        pose.method_22903();
        pose.method_46416(0.0f, 0.0f, 0.0f);
        int x = this.getStartingPanelX();
        int y = this.field_2800;
        int height = this.getPanelHeight();
        int width = this.getPanelWidth();
        GuiGraphicsUtils.blitSpriteBatched(guiGraphics, BACKGROUND_PATCH, x + 6, y, width, height);
        if (((AccessoriesMenu)this.field_2797).overMaxVisibleSlots) {
            GuiGraphicsUtils.blitSpriteBatched(guiGraphics, SCROLL_BAR_PATCH, x + 13, y + 7 + 8, 8, height - 22);
        }
        pose.method_22909();
        pose.method_22903();
        pose.method_46416(-1.0f, -1.0f, 0.0f);
        GuiGraphicsUtils.batched(guiGraphics, SLOT, ((AccessoriesMenu)this.field_2797).field_7761, (bufferBuilder, poseStack, slot) -> {
            if (!(slot.field_7871 instanceof ExpandedSimpleContainer) || !slot.method_7682()) {
                return;
            }
            GuiGraphicsUtils.blit(bufferBuilder, poseStack, slot.field_7873 + this.field_2776, slot.field_7872 + this.field_2800, 18);
        });
        if (this.getHoveredSlot() != null && (class_17352 = this.getHoveredSlot()) instanceof AccessoriesInternalSlot && (slot2 = (AccessoriesInternalSlot)class_17352).method_7682() && !slot2.method_7677().method_7960() && NOT_VERY_NICE_POSITIONS.containsKey(slot2.accessoriesContainer.getSlotName() + slot2.method_34266())) {
            this.accessoryPositions.add(NOT_VERY_NICE_POSITIONS.get(slot2.accessoriesContainer.getSlotName() + slot2.method_34266()));
            String positionKey = slot2.accessoriesContainer.getSlotName() + slot2.method_34266();
            Vector3d vec = NOT_VERY_NICE_POSITIONS.getOrDefault(positionKey, null);
            if (!slot2.isCosmetic && vec != null && ((AccessoriesMenu)this.field_2797).areLinesShown()) {
                Vector3d start = new Vector3d((double)(slot2.field_7873 + this.field_2776 + 17), (double)(slot2.field_7872 + this.field_2800 + 9), 5000.0);
                Vector3d vec3 = vec.add(0.0, 0.0, 5000.0);
                this.accessoryLines.add((Pair<Vector3d, Vector3d>)Pair.of((Object)start, (Object)vec3));
            }
        }
        pose.method_22909();
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        int index;
        if ((this.insideScrollbar(mouseX, mouseY) || Accessories.getConfig().clientData.allowSlotScrolling && this.field_2787 instanceof AccessoriesInternalSlot) && (index = (int)Math.max(Math.min(-scrollY + (double)((AccessoriesMenu)this.field_2797).scrolledIndex, (double)((AccessoriesMenu)this.field_2797).maxScrollableIndex()), 0.0)) != ((AccessoriesMenu)this.field_2797).scrolledIndex) {
            AccessoriesInternals.getNetworkHandler().sendToServer(new MenuScroll(index, false));
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollY);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            int patchYOffset = this.field_2800 + 7 + 8;
            int height = this.getPanelHeight();
            ((AccessoriesMenu)this.field_2797).smoothScroll = class_3532.method_15363((float)((float)(mouseY - (double)patchYOffset) / ((float)height - 22.0f)), (float)0.0f, (float)1.0f);
            int index = Math.round(((AccessoriesMenu)this.field_2797).smoothScroll * (float)((AccessoriesMenu)this.field_2797).maxScrollableIndex());
            if (index != ((AccessoriesMenu)this.field_2797).scrolledIndex) {
                AccessoriesInternals.getNetworkHandler().sendToServer(new MenuScroll(index, true));
                return true;
            }
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        for (ToggleButton cosmeticButton : this.cosmeticButtons.values()) {
            cosmeticButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        int x = this.getStartingPanelX();
        int y = this.field_2800;
        int panelHeight = this.getPanelHeight();
        if (((AccessoriesMenu)this.field_2797).overMaxVisibleSlots) {
            int startingY = y + 8 + 8;
            startingY = (int)((float)startingY + ((AccessoriesMenu)this.field_2797).smoothScroll * (float)(panelHeight - 24 - this.scrollBarHeight));
            GuiGraphicsUtils.blitSpriteBatched(guiGraphics, SCROLL_BAR, x + 14, startingY, 6, this.scrollBarHeight);
        }
        class_4587 pose = guiGraphics.method_51448();
        if (Accessories.getConfig().clientData.showGroupTabs) {
            for (Map.Entry<SlotGroup, SlotGroupData> entry : this.getGroups(x, y).entrySet()) {
                SlotGroup group = entry.getKey();
                SlotGroupData pair = entry.getValue();
                Vector4i vector = pair.dimensions();
                int v = pair.isSelected() ? vector.w : vector.w * 3;
                guiGraphics.method_25290(HORIZONTAL_TABS, vector.x, vector.y, 0.0f, (float)v, vector.z, vector.w, 19, vector.w * 4);
                pose.method_22903();
                pose.method_46416((float)(vector.x + 3), (float)(vector.y + 3), 0.0f);
                pose.method_46416(1.0f, 1.0f, 0.0f);
                if (pair.isSelected) {
                    pose.method_46416(2.0f, 0.0f, 0.0f);
                }
                guiGraphics.method_25290(group.icon().method_45138("textures/").method_48331(".png"), 0, 0, 0.0f, 0.0f, 8, 8, 8, 8);
                pose.method_22909();
            }
        }
        if (Accessories.getConfig().clientData.hoverOptions.hoveredOptions.clickbait) {
            this.accessoryPositions.forEach(pos -> {
                class_4587 matrix = guiGraphics.method_51448();
                matrix.method_22903();
                matrix.method_46416((float)pos.x - 128.0f, (float)pos.y - 128.0f, 200.0f);
                matrix.method_22905(0.5f, 0.5f, 0.0f);
                guiGraphics.method_25291(Accessories.of("textures/gui/sprites/highlight/clickbait.png"), 0, 0, 0, 0.0f, 0.0f, 512, 512, 512, 512);
                matrix.method_22909();
            });
            this.accessoryPositions.clear();
        }
        this.method_2380(guiGraphics, mouseX, mouseY);
        if (!this.accessoryLines.isEmpty() && Accessories.getConfig().clientData.hoverOptions.hoveredOptions.line) {
            class_4588 buf = guiGraphics.method_51450().getBuffer((class_1921)class_1921.field_21695);
            Matrix3f lastPose = guiGraphics.method_51448().method_23760().method_23762();
            for (Pair<Vector3d, Vector3d> line : this.accessoryLines) {
                Vector3f normalVec = ((Vector3d)line.second()).sub((Vector3dc)line.first(), new Vector3d()).normalize().get(new Vector3f());
                double segments = Math.max(10, (int)(((Vector3d)line.first()).distance((Vector3dc)line.second()) * 10.0) / 100);
                double movement = (double)System.currentTimeMillis() / ((segments *= 2.0) * 1000.0) % 1.0;
                double delta = movement % (2.0 / segments) % segments;
                Vector3f firstVec = ((Vector3d)line.first()).get(new Vector3f());
                if (delta > 0.05) {
                    buf.method_22912((double)firstVec.x(), (double)firstVec.y(), (double)firstVec.z()).method_1336(255, 255, 255, 255).method_22922(class_4608.field_21444).method_22916(240).method_23763(lastPose, normalVec.x, normalVec.y, normalVec.z).method_1344();
                    Vector3f pos2 = new Vector3d(class_3532.method_16436((double)(delta - 0.05), (double)((Vector3d)line.first()).x, (double)((Vector3d)line.second()).x), class_3532.method_16436((double)(delta - 0.05), (double)((Vector3d)line.first()).y, (double)((Vector3d)line.second()).y), class_3532.method_16436((double)(delta - 0.05), (double)((Vector3d)line.first()).z, (double)((Vector3d)line.second()).z)).get(new Vector3f());
                    buf.method_22912((double)pos2.x(), (double)pos2.y(), (double)pos2.z()).method_1336(255, 255, 255, 255).method_22922(class_4608.field_21444).method_22916(240).method_23763(lastPose, normalVec.x, normalVec.y, normalVec.z).method_1344();
                }
                int i = 0;
                while ((double)i < segments / 2.0) {
                    double delta1 = ((double)(i * 2) / segments + movement) % 1.0;
                    double delta2 = ((double)(i * 2 + 1) / segments + movement) % 1.0;
                    Vector3f pos1 = new Vector3d(class_3532.method_16436((double)delta1, (double)((Vector3d)line.first()).x, (double)((Vector3d)line.second()).x), class_3532.method_16436((double)delta1, (double)((Vector3d)line.first()).y, (double)((Vector3d)line.second()).y), class_3532.method_16436((double)delta1, (double)((Vector3d)line.first()).z, (double)((Vector3d)line.second()).z)).get(new Vector3f());
                    Vector3f pos2 = (delta2 > delta1 ? new Vector3d(class_3532.method_16436((double)delta2, (double)((Vector3d)line.first()).x, (double)((Vector3d)line.second()).x), class_3532.method_16436((double)delta2, (double)((Vector3d)line.first()).y, (double)((Vector3d)line.second()).y), class_3532.method_16436((double)delta2, (double)((Vector3d)line.first()).z, (double)((Vector3d)line.second()).z)) : (Vector3d)line.second()).get(new Vector3f());
                    buf.method_22912((double)pos1.x(), (double)pos1.y(), (double)pos1.z()).method_1336(255, 255, 255, 255).method_22922(class_4608.field_21444).method_22916(240).method_23763(lastPose, normalVec.x, normalVec.y, normalVec.z).method_1344();
                    buf.method_22912((double)pos2.x(), (double)pos2.y(), (double)pos2.z()).method_1336(255, 255, 255, 255).method_22922(class_4608.field_21444).method_22916(240).method_23763(lastPose, normalVec.x, normalVec.y, normalVec.z).method_1344();
                    ++i;
                }
            }
            this.field_22787.method_22940().method_23000().method_22994((class_1921)class_1921.field_21695);
            this.accessoryLines.clear();
        }
    }

    protected void method_25426() {
        boolean anyUniqueSlots;
        super.method_25426();
        this.currentTabPage = 1;
        this.cosmeticButtons.clear();
        this.backButton = (class_4185)((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43473(), btn -> this.field_22787.method_1507((class_437)new class_490((class_1657)this.field_22787.field_1724))).method_46434(this.field_2776 + 141, this.field_2800 + 9, 8, 8).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)Accessories.translation("back.screen")))).method_46431())).adjustRendering((button, guiGraphics, sprite, x, y, width, height) -> {
            guiGraphics.method_25290(SPRITES_8X8.getLocation(button), x, y, (float)width, (float)height, 8, 8, 8, 8);
            class_4587 pose = guiGraphics.method_51448();
            return true;
        });
        boolean cosmeticsOpen = ((AccessoriesMenu)this.field_2797).isCosmeticsOpen();
        this.cosmeticToggleButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43473(), btn -> AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.COSMETIC_PROP, ((AccessoriesMenu)this.method_17577()).owner(), bl -> bl == false))).method_46436(AccessoriesScreen.cosmeticsToggleTooltip(cosmeticsOpen)).method_46434(this.field_2776 - 27 + (cosmeticsOpen ? -20 : 0), this.field_2800 + 7, cosmeticsOpen ? 38 : 18, 6).method_46431());
        int btnOffset = this.field_2800 + 7;
        this.unusedSlotsToggleButton = (class_4185)((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43473(), btn -> AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.UNUSED_PROP, ((AccessoriesMenu)this.method_17577()).owner(), bl -> bl == false))).method_46436(AccessoriesScreen.unusedSlotsToggleButton(((AccessoriesMenu)this.field_2797).areUnusedSlotsShown())).method_46434(this.field_2776 + 154, btnOffset, 12, 12).method_46431())).adjustRendering((button, guiGraphics, sprite, x, y, width, height) -> {
            guiGraphics.method_25290(SPRITES_12X12.getLocation(button), x, y, (float)width, (float)height, 12, 12, 12, 12);
            guiGraphics.method_25290(((AccessoriesMenu)this.field_2797).areUnusedSlotsShown() ? UNUSED_SLOTS_SHOWN : UNUSED_SLOTS_HIDDEN, x, y, (float)width, (float)height, 12, 12, 12, 12);
            return true;
        });
        btnOffset += 15;
        if (Accessories.getConfig().clientData.showUniqueRendering && (anyUniqueSlots = EntitySlotLoader.getEntitySlots(this.targetEntityDefaulted()).values().stream().anyMatch(slotType -> UniqueSlotHandling.isUniqueSlot(slotType.name())))) {
            this.uniqueSlotsToggleButton = (class_4185)((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43473(), btn -> AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.UNIQUE_PROP, ((AccessoriesMenu)this.method_17577()).owner(), bl -> bl == false))).method_46436(AccessoriesScreen.uniqueSlotsToggleButton(((AccessoriesMenu)this.field_2797).areUniqueSlotsShown())).method_46434(this.field_2776 + 154, btnOffset, 12, 12).method_46431())).adjustRendering((button, guiGraphics, sprite, x, y, width, height) -> {
                guiGraphics.method_25290(SPRITES_12X12.getLocation(button), x, y, (float)width, (float)height, 12, 12, 12, 12);
                guiGraphics.method_25290(((AccessoriesMenu)this.field_2797).areUniqueSlotsShown() ? UNUSED_SLOTS_SHOWN : UNUSED_SLOTS_HIDDEN, x, y, (float)width, (float)height, 12, 12, 12, 12);
                return true;
            });
            btnOffset += 15;
        }
        int accessoriesSlots = 0;
        for (class_1735 slot : ((AccessoriesMenu)this.field_2797).field_7761) {
            if (!(slot instanceof AccessoriesInternalSlot)) continue;
            AccessoriesInternalSlot accessoriesSlot = (AccessoriesInternalSlot)slot;
            if (accessoriesSlot.isCosmetic) continue;
            ToggleButton slotButton = ToggleButton.ofSlot(slot.field_7873 + this.field_2776 + 13, slot.field_7872 + this.field_2800 - 2, 300, accessoriesSlot);
            slotButton.field_22764 = accessoriesSlot.method_7682();
            slotButton.field_22763 = accessoriesSlot.method_7682();
            this.cosmeticButtons.put(accessoriesSlot, (ToggleButton)this.method_25429((class_364)slotButton));
            ++accessoriesSlots;
        }
        if (AccessoriesScreen.tabPageCount() > 1) {
            this.tabDownButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2b06"), button -> this.onTabPageChange(true)).method_46434(this.field_2776 - 56, this.field_2800 - 11, 10, 10).method_46431());
            this.tabDownButton.field_22763 = false;
            int height2 = this.getPanelHeight();
            this.tabUpButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2b07"), button -> this.onTabPageChange(false)).method_46434(this.field_2776 - 56, this.field_2800 + height2 + 0, 10, 10).method_46431());
            this.tabUpButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Page 2")));
            this.tabUpButton.field_22763 = AccessoriesScreen.tabPageCount() != 1;
        }
        ((AccessoriesMenu)this.field_2797).setScrollEvent(this::updateAccessoryToggleButtons);
        this.scrollBarHeight = class_3532.method_48781((float)Math.min((float)accessoriesSlots / 20.0f, 1.0f), (int)101, (int)31);
        if (this.scrollBarHeight % 2 == 0) {
            ++this.scrollBarHeight;
        }
    }

    private void onTabPageChange(boolean isDown) {
        if (this.currentTabPage <= 1 && isDown || this.currentTabPage > AccessoriesScreen.tabPageCount() && !isDown) {
            return;
        }
        this.currentTabPage += isDown ? -1 : 1;
        String lowerLabel = "Page " + (this.currentTabPage - 1);
        String upperLabel = "Page " + (this.currentTabPage + 1);
        this.tabDownButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)lowerLabel)));
        this.tabUpButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)upperLabel)));
        if (this.currentTabPage <= 1) {
            this.tabDownButton.field_22763 = false;
        } else if (!this.tabDownButton.field_22763) {
            this.tabDownButton.field_22763 = true;
        }
        if (this.currentTabPage >= AccessoriesScreen.tabPageCount()) {
            this.tabUpButton.field_22763 = false;
        } else if (!this.tabUpButton.field_22763) {
            this.tabUpButton.field_22763 = true;
        }
    }

    public void updateButtons(String name) {
        switch (name) {
            case "lines": {
                this.updateLinesButton();
                break;
            }
            case "cosmetic": {
                this.updateCosmeticToggleButton();
                break;
            }
            case "unused_slots": {
                this.updateUnusedSlotToggleButton();
                break;
            }
            case "unique_slots": {
                this.updateUniqueSlotToggleButton();
            }
        }
    }

    public void updateLinesButton() {
    }

    public void updateCosmeticToggleButton() {
        class_4185 btn = this.cosmeticToggleButton;
        btn.method_25358(((AccessoriesMenu)this.field_2797).isCosmeticsOpen() ? 38 : 18);
        btn.method_46421(btn.method_46426() + (((AccessoriesMenu)this.field_2797).isCosmeticsOpen() ? -20 : 20));
        btn.method_47400(AccessoriesScreen.cosmeticsToggleTooltip(((AccessoriesMenu)this.field_2797).isCosmeticsOpen()));
    }

    public void updateUnusedSlotToggleButton() {
        this.unusedSlotsToggleButton.method_47400(AccessoriesScreen.unusedSlotsToggleButton(((AccessoriesMenu)this.field_2797).areUnusedSlotsShown()));
        ((AccessoriesMenu)this.field_2797).reopenMenu();
    }

    public void updateUniqueSlotToggleButton() {
        this.uniqueSlotsToggleButton.method_47400(AccessoriesScreen.uniqueSlotsToggleButton(((AccessoriesMenu)this.field_2797).areUniqueSlotsShown()));
        ((AccessoriesMenu)this.field_2797).reopenMenu();
    }

    public void updateAccessoryToggleButtons() {
        for (Map.Entry<AccessoriesInternalSlot, ToggleButton> entry : this.cosmeticButtons.entrySet()) {
            AccessoriesInternalSlot accessoriesSlot = entry.getKey();
            ToggleButton btn = entry.getValue();
            if (!accessoriesSlot.method_7682()) {
                btn.field_22763 = false;
                btn.field_22764 = false;
                continue;
            }
            btn.method_47400(AccessoriesScreen.toggleTooltip(accessoriesSlot.accessoriesContainer.shouldRender(accessoriesSlot.method_34266())));
            btn.method_46421(accessoriesSlot.field_7873 + this.field_2776 + 13);
            btn.method_46419(accessoriesSlot.field_7872 + this.field_2800 - 2);
            btn.toggled(accessoriesSlot.accessoriesContainer.shouldRender(accessoriesSlot.method_34266()));
            btn.field_22763 = true;
            btn.field_22764 = true;
        }
    }

    private static class_7919 cosmeticsToggleTooltip(boolean value) {
        return AccessoriesScreen.createToggleTooltip("slot.cosmetics", value);
    }

    private static class_7919 linesToggleTooltip(boolean value) {
        return AccessoriesScreen.createToggleTooltip("lines", value);
    }

    private static class_7919 unusedSlotsToggleButton(boolean value) {
        return AccessoriesScreen.createToggleTooltip("unused_slots", value);
    }

    private static class_7919 uniqueSlotsToggleButton(boolean value) {
        return AccessoriesScreen.createToggleTooltip("unique_slots", value);
    }

    private static class_7919 toggleTooltip(boolean value) {
        return AccessoriesScreen.createToggleTooltip("display", value);
    }

    private static class_7919 createToggleTooltip(String type, boolean value) {
        String key = type + ".toggle." + (!value ? "show" : "hide");
        return class_7919.method_47407((class_2561)class_2561.method_43471((String)Accessories.translation(key)));
    }

    @Override
    @Nullable
    public Boolean isHovering(class_1735 slot, double mouseX, double mouseY) {
        for (class_364 child : this.method_25396()) {
            ToggleButton btn;
            if (!(child instanceof ToggleButton) || !(btn = (ToggleButton)child).method_25405(mouseX, mouseY)) continue;
            return false;
        }
        return ContainerScreenExtension.super.isHovering(slot, mouseX, mouseY);
    }

    protected void method_2380(class_332 guiGraphics, int x, int y) {
        class_1735 class_17352 = this.field_2787;
        if (class_17352 instanceof AccessoriesInternalSlot) {
            AccessoriesInternalSlot slot = (AccessoriesInternalSlot)class_17352;
            FORCE_TOOLTIP_LEFT = true;
            if (slot.method_7677().method_7960() && slot.accessoriesContainer.slotType() != null) {
                guiGraphics.method_51437(class_310.method_1551().field_1772, slot.getTooltipData(), Optional.empty(), x, y);
                return;
            }
        }
        if (Accessories.getConfig().clientData.showGroupTabs) {
            int panelX = this.getStartingPanelX();
            int panelY = this.field_2800;
            for (Map.Entry<SlotGroup, SlotGroupData> entry : this.getGroups(panelX, panelY).entrySet()) {
                if (!entry.getValue().isInBounds(x, y)) continue;
                ArrayList<class_5250> tooltipData = new ArrayList<class_5250>();
                SlotGroup group = entry.getKey();
                tooltipData.add(class_2561.method_43471((String)group.translation()));
                if (UniqueSlotHandling.isUniqueGroup(group.name(), true)) {
                    tooltipData.add(class_2561.method_43470((String)group.name()).method_27695(new class_124[]{class_124.field_1078, class_124.field_1056}));
                }
                guiGraphics.method_51437(class_310.method_1551().field_1772, tooltipData, Optional.empty(), x, y);
                break;
            }
        }
        super.method_2380(guiGraphics, x, y);
        FORCE_TOOLTIP_LEFT = false;
    }

    protected boolean method_2381(double mouseX, double mouseY, int x, int y, int mouseButton) {
        int leftPos = this.field_2776;
        int topPos = this.field_2800;
        boolean insideMainPanel = mouseX >= (double)leftPos && mouseX <= (double)(leftPos + this.field_2792) && mouseY >= (double)topPos && mouseY <= (double)(topPos + this.field_2779);
        int sidePanelX = this.getStartingPanelX();
        int sidePanelY = topPos;
        boolean insideSidePanel = mouseX >= (double)sidePanelX && mouseX <= (double)(sidePanelX + this.getPanelWidth() + this.field_2792) && mouseY >= (double)sidePanelY && mouseY <= (double)(sidePanelY + this.getPanelHeight());
        boolean insideGroupPanel = false;
        if (Accessories.getConfig().clientData.showGroupTabs && ((AccessoriesMenu)this.field_2797).maxScrollableIndex() > 0) {
            for (SlotGroupData value : this.getGroups(sidePanelX, sidePanelY).values()) {
                if (!value.isInBounds((int)Math.round(mouseX), (int)Math.round(mouseY))) continue;
                insideGroupPanel = true;
                break;
            }
        }
        return !insideMainPanel && !insideSidePanel && !insideGroupPanel;
    }

    public static int tabPageCount() {
        List<SlotGroup> groups = SlotGroupLoader.INSTANCE.getGroups(true, true);
        return (int)Math.ceil((float)groups.size() / 9.0f);
    }

    private Map<SlotGroup, SlotGroupData> getGroups(int x, int y) {
        List<SlotGroup> groups = ((AccessoriesMenu)this.method_17577()).validGroups().stream().sorted(Comparator.comparingInt(SlotGroup::order).reversed()).toList();
        if (AccessoriesScreen.tabPageCount() > 1) {
            int lowerBound = (this.currentTabPage - 1) * 9;
            int upperBound = lowerBound + 9;
            if (upperBound > groups.size()) {
                upperBound = groups.size();
            }
            groups = groups.subList(lowerBound, upperBound);
        }
        int bottomIndex = ((AccessoriesMenu)this.field_2797).scrolledIndex;
        int upperIndex = bottomIndex + 8 - 1;
        Range scrollRange = Range.between((Object)bottomIndex, (Object)upperIndex, Integer::compareTo);
        class_1309 targetEntity = this.targetEntityDefaulted();
        Map<String, AccessoriesContainer> containers = targetEntity.accessoriesCapability().getContainers();
        HashMap<String, Integer> slotToSize = new HashMap<String, Integer>();
        for (SlotType slotType : EntitySlotLoader.getEntitySlots(targetEntity).values()) {
            Object container;
            Set<SlotType> usedSlots = ((AccessoriesMenu)this.method_17577()).usedSlots();
            if (usedSlots != null && !usedSlots.contains(slotType) || (container = containers.get(slotType.name())) == null) continue;
            slotToSize.put(slotType.name(), container.getAccessories().method_5439());
        }
        int currentIndexOffset = 0;
        HashMap<SlotGroup, Integer> groupToIndex = new HashMap<SlotGroup, Integer>();
        HashSet<String> selectedGroup = new HashSet<String>();
        for (SlotGroup group : groups) {
            int groupSize = slotToSize.entrySet().stream().filter(entry -> group.slots().contains(entry.getKey())).mapToInt(Map.Entry::getValue).sum();
            if (groupSize <= 0) continue;
            int groupMinIndex = currentIndexOffset;
            int groupMaxIndex = groupMinIndex + groupSize - 1;
            Range groupRange = Range.between((Object)groupMinIndex, (Object)groupMaxIndex, Integer::compareTo);
            if (groupRange.isOverlappedBy(scrollRange)) {
                selectedGroup.add(group.name());
            }
            groupToIndex.put(group, groupMinIndex);
            currentIndexOffset += groupSize;
        }
        int maxHeight = this.getPanelHeight() - 4;
        int width = 19;
        int height = 16;
        int tabY = y + 4;
        int tabX = x - (width - 10);
        int yOffset = 0;
        HashMap<SlotGroup, SlotGroupData> groupValues = new HashMap<SlotGroup, SlotGroupData>();
        for (SlotGroup group : groups) {
            if (yOffset + height > maxHeight) break;
            boolean selected = selectedGroup.contains(group.name());
            int xOffset = selected ? 0 : 2;
            Integer index = (Integer)groupToIndex.get(group);
            if (index == null) continue;
            groupValues.put(group, new SlotGroupData(new Vector4i(tabX + xOffset, tabY + yOffset, width - xOffset, height), selected, index));
            yOffset += height + 1;
        }
        return groupValues;
    }

    private static SlotGroupImpl copy(SlotGroup group) {
        return new SlotGroupImpl(group.name() + "1", group.order(), group.slots(), group.icon());
    }

    private void renderEntityInInventoryFollowingMouseRotated(class_332 guiGraphics, Vector2i pos, Vector2i size, Vector2i scissorStart, Vector2i scissorEnd, float mouseX, float mouseY, float rotation) {
        int scale = 30;
        float yOffset = 0.0625f;
        class_1309 entity = this.targetEntityDefaulted();
        float f = (float)(pos.x + pos.x + size.x) / 2.0f;
        float g = (float)(pos.y + pos.y + size.y) / 2.0f;
        guiGraphics.method_44379(scissorStart.x, scissorStart.y, scissorEnd.x, scissorEnd.y);
        float h = (float)Math.atan(((float)(scissorStart.x + scissorStart.x + size.x) / 2.0f - mouseX) / 40.0f);
        float i = (float)Math.atan(((float)(scissorStart.y + scissorStart.y + size.y) / 2.0f - mouseY) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)((double)rotation * (Math.PI / 180)));
        Quaternionf quaternionf2 = new Quaternionf().rotateX(i * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float j = entity.field_6283;
        float k = entity.method_36454();
        float l = entity.method_36455();
        float m = entity.field_6259;
        float n = entity.field_6241;
        entity.field_6283 = 180.0f + h * 30.0f;
        entity.method_36456(180.0f + h * 40.0f);
        entity.method_36457(-i * 20.0f);
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        class_490.method_48472((class_332)guiGraphics, (int)((int)f), (int)((int)(g + (entity.method_17682() * 17.0f + yOffset))), (int)28, (Quaternionf)quaternionf, (Quaternionf)quaternionf2, (class_1309)entity);
        entity.field_6283 = j;
        entity.method_36456(k);
        entity.method_36457(l);
        entity.field_6259 = m;
        entity.field_6241 = n;
        guiGraphics.method_44380();
    }

    public class_1735 getHoveredSlot() {
        return this.field_2787;
    }

    static {
        GuiGraphicsUtils.register(BACKGROUND_PATCH, GuiGraphicsUtils.NineSlicingDimensionImpl.of(Accessories.of("textures/gui/sprites/background_patch.png"), 15, 15, 5));
        GuiGraphicsUtils.register(SCROLL_BAR_PATCH, GuiGraphicsUtils.NineSlicingDimensionImpl.of(Accessories.of("textures/gui/sprites/scroll_bar_patch.png"), 6, 6, 2));
        GuiGraphicsUtils.register(SCROLL_BAR, GuiGraphicsUtils.NineSlicingDimensionImpl.of(Accessories.of("textures/gui/sprites/scroll_bar.png"), 6, 6, 2));
        HORIZONTAL_TABS = Accessories.of("textures/gui/container/horizontal_tabs_small.png");
        SPRITES_12X12 = SpriteGetter.ofButton(Accessories.of("textures/gui/sprites/widget/12x12/button.png"), Accessories.of("textures/gui/sprites/widget/12x12/button_disabled.png"), Accessories.of("textures/gui/sprites/widget/12x12/button_highlighted.png"));
        SPRITES_8X8 = SpriteGetter.ofButton(Accessories.of("textures/gui/sprites/widget/8x8/button.png"), Accessories.of("textures/gui/sprites/widget/8x8/button_disabled.png"), Accessories.of("textures/gui/sprites/widget/8x8/button_highlighted.png"));
        BACk_ICON = Accessories.of("textures/gui/sprites/widget/back.png");
        LINE_HIDDEN = Accessories.of("textures/gui/sprites/widget/line_hidden.png");
        LINE_SHOWN = Accessories.of("textures/gui/sprites/widget/line_shown.png");
        UNUSED_SLOTS_HIDDEN = Accessories.of("textures/gui/sprites/widget/unused_slots_hidden.png");
        UNUSED_SLOTS_SHOWN = Accessories.of("textures/gui/sprites/widget/unused_slots_shown.png");
        SCISSOR_BOX = new Vector4i();
        IS_RENDERING_UI_ENTITY = false;
        IS_RENDERING_LINE_TARGET = false;
        COLLECT_ACCESSORY_POSITIONS = false;
        NOT_VERY_NICE_POSITIONS = new HashMap<String, Vector3d>();
        FORCE_TOOLTIP_LEFT = false;
    }

    private record SlotGroupData(Vector4i dimensions, boolean isSelected, int startingIndex) {
        private boolean isInBounds(int x, int y) {
            return x > this.dimensions.x && y > this.dimensions.y && x < this.dimensions.x + this.dimensions.z && y < this.dimensions.y + this.dimensions.w;
        }
    }
}

