/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;

public class GuiGraphicsUtils {
    public static final Map<class_2960, BaseDimension> sprites = new HashMap<class_2960, BaseDimension>();

    public static void blitSpriteBatched(class_332 guiGraphics, class_2960 sprite, int x, int y, int width, int height) {
        GuiGraphicsUtils.blitSpriteBatched(guiGraphics, sprite, x, y, 0, width, height);
    }

    public static void blitSpriteBatched(class_332 guiGraphics, class_2960 sprite, int x, int y, int blitOffset, int width, int height) {
        BaseDimension tile = sprites.get(sprite);
        if (tile instanceof NineSlicingDimension) {
            NineSlicingDimension nineSlice = (NineSlicingDimension)tile;
            GuiGraphicsUtils.blitNineSlicedSpriteBatched(guiGraphics, nineSlice, x, y, blitOffset, width, height);
        } else if (tile != null) {
            GuiGraphicsUtils.blitTiledSpriteBatched(guiGraphics, tile, x, y, blitOffset, width, height, 0, 0, tile.width(), tile.height(), tile.width(), tile.height());
        }
    }

    private static void blitNineSlicedSpriteBatched(class_332 guiGraphics, NineSlicingDimension nineSlice, int x, int y, int blitOffset, int width, int height) {
        int i = Math.min(nineSlice.left(), width / 2);
        int j = Math.min(nineSlice.right(), width / 2);
        int k = Math.min(nineSlice.top(), height / 2);
        int l = Math.min(nineSlice.bottom(), height / 2);
        GuiGraphicsUtils.batched(guiGraphics, nineSlice.textureLocation(), (BiConsumer<class_287, class_4587>)((BiConsumer)(bufferBuilder, poseStack) -> {
            if (width == nineSlice.width() && height == nineSlice.height()) {
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, nineSlice.width(), nineSlice.height(), 0, 0, x, y, blitOffset, width, height);
            } else if (height == nineSlice.height()) {
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, nineSlice.width(), nineSlice.height(), 0, 0, x, y, blitOffset, i, height);
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, x + i, y, blitOffset, width - j - i, height, i, 0, nineSlice.width() - j - i, nineSlice.height(), nineSlice.width(), nineSlice.height());
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, nineSlice.width(), nineSlice.height(), nineSlice.width() - j, 0, x + width - j, y, blitOffset, j, height);
            } else if (width == nineSlice.width()) {
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, nineSlice.width(), nineSlice.height(), 0, 0, x, y, blitOffset, width, k);
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, x, y + k, blitOffset, width, height - l - k, 0, k, nineSlice.width(), nineSlice.height() - l - k, nineSlice.width(), nineSlice.height());
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - l, x, y + height - l, blitOffset, width, l);
            } else {
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, nineSlice.width(), nineSlice.height(), 0, 0, x, y, blitOffset, i, k);
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, x + i, y, blitOffset, width - j - i, k, i, 0, nineSlice.width() - j - i, k, nineSlice.width(), nineSlice.height());
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, nineSlice.width(), nineSlice.height(), nineSlice.width() - j, 0, x + width - j, y, blitOffset, j, k);
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - l, x, y + height - l, blitOffset, i, l);
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, x + i, y + height - l, blitOffset, width - j - i, l, i, nineSlice.height() - l, nineSlice.width() - j - i, l, nineSlice.width(), nineSlice.height());
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, nineSlice.width(), nineSlice.height(), nineSlice.width() - j, nineSlice.height() - l, x + width - j, y + height - l, blitOffset, j, l);
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, x, y + k, blitOffset, i, height - l - k, 0, k, i, nineSlice.height() - l - k, nineSlice.width(), nineSlice.height());
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, x + i, y + k, blitOffset, width - j - i, height - l - k, i, k, nineSlice.width() - j - i, nineSlice.height() - l - k, nineSlice.width(), nineSlice.height());
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, x + width - j, y + k, blitOffset, i, height - l - k, nineSlice.width() - j, k, j, nineSlice.height() - l - k, nineSlice.width(), nineSlice.height());
            }
        }));
    }

    private static void blitTiledSpriteBatched(class_332 guiGraphics, BaseDimension sprite, int x, int y, int blitOffset, int width, int height, int i, int j, int spriteWidth, int spriteHeight, int nineSliceWidth, int nineSliceHeight) {
        GuiGraphicsUtils.batched(guiGraphics, sprite.textureLocation(), (BiConsumer<class_287, class_4587>)((BiConsumer)(bufferBuilder, poseStack) -> {
            if (width <= 0 || height <= 0) {
                return;
            }
            if (spriteWidth <= 0 || spriteHeight <= 0) {
                throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + spriteWidth + "x" + spriteHeight);
            }
            for (int k = 0; k < width; k += spriteWidth) {
                int l = Math.min(spriteWidth, width - k);
                for (int m = 0; m < height; m += spriteHeight) {
                    int n = Math.min(spriteHeight, height - m);
                    GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, nineSliceWidth, nineSliceHeight, i, j, x + k, y + m, blitOffset, l, n);
                }
            }
        }));
    }

    private static void blitTiledSprite(class_287 bufferBuilder, class_4587 poseStack, int x, int y, int blitOffset, int width, int height, int i, int j, int spriteWidth, int spriteHeight, int nineSliceWidth, int nineSliceHeight) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (spriteWidth <= 0 || spriteHeight <= 0) {
            throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + spriteWidth + "x" + spriteHeight);
        }
        for (int k = 0; k < width; k += spriteWidth) {
            int l = Math.min(spriteWidth, width - k);
            for (int m = 0; m < height; m += spriteHeight) {
                int n = Math.min(spriteHeight, height - m);
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, nineSliceWidth, nineSliceHeight, i, j, x + k, y + m, blitOffset, l, n);
            }
        }
    }

    public static <T> void batched(class_332 guiGraphics, class_2960 location, List<T> list, TriConsumer<class_287, class_4587, T> consumer) {
        GuiGraphicsUtils.batched(guiGraphics, location, (BiConsumer<class_287, class_4587>)((BiConsumer)(bufferBuilder, poseStack) -> list.forEach(t -> consumer.accept(bufferBuilder, poseStack, t))));
    }

    public static void batched(class_332 guiGraphics, class_2960 location, BiConsumer<class_287, class_4587> consumer) {
        RenderSystem.setShaderTexture((int)0, (class_2960)location);
        RenderSystem.setShader(class_757::method_34542);
        class_4587 poseStack = guiGraphics.method_51448();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        consumer.accept((Object)bufferBuilder, (Object)poseStack);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    private static void blitSprite(class_287 bufferBuilder, class_4587 poseStack, int sliceWidth, int sliceHeight, int uOffset, int vOffset, int x, int y, int blitOffset, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        GuiGraphicsUtils.blitInner(bufferBuilder, poseStack, x, x + width, y, y + height, blitOffset, (float)uOffset / (float)sliceWidth, (float)(uOffset + width) / (float)sliceWidth, (float)vOffset / (float)sliceHeight, (float)(vOffset + height) / (float)sliceHeight);
    }

    public static void blit(class_287 bufferBuilder, class_4587 poseStack, int x, int y, int size) {
        GuiGraphicsUtils.blit(bufferBuilder, poseStack, x, y, 0, 0.0f, 0.0f, size, size, size, size);
    }

    public static void blit(class_287 bufferBuilder, class_4587 poseStack, int x1, int y1, int blitOffset, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        float minU = uOffset / (float)textureWidth;
        float maxU = (uOffset + (float)width) / (float)textureWidth;
        float minV = vOffset / (float)textureHeight;
        float maxV = (vOffset + (float)height) / (float)textureHeight;
        GuiGraphicsUtils.blitInner(bufferBuilder, poseStack, x1, x1 + width, y1, y1 + height, blitOffset, minU, maxU, minV, maxV);
    }

    public static void blitInner(class_287 bufferBuilder, class_4587 poseStack, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)blitOffset).method_22913(minU, minV).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)blitOffset).method_22913(minU, maxV).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)blitOffset).method_22913(maxU, maxV).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)blitOffset).method_22913(maxU, minV).method_1344();
    }

    public static void register(class_2960 location, BaseDimension dimensions) {
        sprites.put(location, dimensions);
    }

    public static interface BaseDimension {
        public class_2960 textureLocation();

        public int width();

        public int height();
    }

    public static interface NineSlicingDimension
    extends BaseDimension {
        public int left();

        public int right();

        public int top();

        public int bottom();
    }

    public record NineSlicingDimensionImpl(class_2960 textureLocation, int width, int height, int left, int right, int top, int bottom) implements NineSlicingDimension
    {
        public static NineSlicingDimensionImpl of(class_2960 textureLocation, int width, int height, int border) {
            return new NineSlicingDimensionImpl(textureLocation, width, height, border, border, border, border);
        }
    }

    public record Tile(class_2960 textureLocation, int width, int height) implements BaseDimension
    {
    }
}

