/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay.utils;

import dev.architectury.platform.Platform;
import io.bluebeaker.backpackdisplay.ConfigProvider;

public class NumberUtils {
    public static String getItemCountRepresentation(long number) {
        if (Math.log10(number) < (double)ConfigProvider.getConfig().appearance.full_digits) {
            return String.valueOf(number);
        }
        if (number >= 1000000000L) {
            return String.format("%.1fG", (double)(number / 100000000L) / 10.0);
        }
        if (number >= 100000000L) {
            return String.format("%dM", number / 1000000L);
        }
        if (number >= 1000000L) {
            return String.format("%.1fM", (double)(number / 100000L) / 10.0);
        }
        if (number >= 100000L) {
            return String.format("%dk", number / 1000L);
        }
        if (number >= 1000L) {
            return String.format("%.1fk", (double)(number / 100L) / 10.0);
        }
        return String.valueOf(number);
    }

    public static String getFluidCountRepresentation(long number) {
        int bucketSize = NumberUtils.getBucketSize();
        if (number >= 100000L) {
            return NumberUtils.getItemCountRepresentation(number / (long)bucketSize) + "B";
        }
        if (number >= (long)bucketSize) {
            return String.format("%.1fB", (double)(number / (long)(bucketSize / 10)) / 10.0);
        }
        return Platform.isFabric() ? String.valueOf(number) : String.valueOf(number) + "mB";
    }

    public static int getBucketSize() {
        return Platform.isFabric() ? 81000 : 1000;
    }
}

