/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay.section.item;

import io.bluebeaker.backpackdisplay.BackpackDisplayMod;
import io.bluebeaker.backpackdisplay.ConfigProvider;
import io.bluebeaker.backpackdisplay.displayslot.DisplaySlotEntryBase;
import io.bluebeaker.backpackdisplay.displayslot.DisplaySlotEntryList;
import io.bluebeaker.backpackdisplay.displayslot.DisplaySlotEntrySingle;
import io.bluebeaker.backpackdisplay.displayslot.IDisplaySlotEntry;
import io.bluebeaker.backpackdisplay.utils.ItemUtils;
import io.bluebeaker.backpackdisplay.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;

public class BPDRegistryItems {
    public static HashMap<class_1792, List<IDisplaySlotEntry>> registry = new HashMap();

    public static void updateFromConfig() {
        registry.clear();
        for (String rule : ConfigProvider.getConfig().itemSection.displayRules) {
            List<String> filledRules = StringUtils.fillInTemplates(rule);
            for (String filledRule : filledRules) {
                try {
                    BPDRegistryItems.addRule(filledRule);
                }
                catch (Exception e) {
                    BackpackDisplayMod.logError("Error when processing rule '" + filledRule + "': \n" + e.toString());
                }
            }
        }
    }

    public static void addRule(String rule) {
        String resourceid;
        String[] splitted = rule.split("(?<!\\\\)#");
        if (splitted.length < 3) {
            return;
        }
        String itemStr = splitted[0].trim();
        String type = splitted[1].trim().toLowerCase();
        String nbtRule = splitted[2].trim();
        String[] itemsplit = itemStr.split(":");
        String modid = itemsplit[0];
        class_2960 itemID = new class_2960(modid, resourceid = itemsplit[1]);
        class_1792 item = ItemUtils.getItemFromID(itemID);
        if (item == null || item == class_1802.field_8162) {
            return;
        }
        IDisplaySlotEntry entry = BPDRegistryItems.buildEntryFromStringRule(type, nbtRule);
        BPDRegistryItems.addEntry(item, entry);
        if (ConfigProvider.getConfig().verbose_info) {
            BackpackDisplayMod.logInfo("Adding entry with " + item.toString() + "type:" + type + ", entry: " + entry.toString());
        }
    }

    public static IDisplaySlotEntry buildEntryFromStringRule(String type, String nbtRule) {
        DisplaySlotEntryBase entry = switch (type) {
            case "single" -> new DisplaySlotEntrySingle(nbtRule);
            case "list" -> new DisplaySlotEntryList(nbtRule);
            default -> new DisplaySlotEntryBase(nbtRule);
        };
        return entry;
    }

    public static void addEntry(class_1792 item, IDisplaySlotEntry entry) {
        if (!registry.containsKey(item)) {
            registry.put(item, new ArrayList());
        }
        registry.get(item).add(entry);
    }
}

