/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import io.bluebeaker.backpackdisplay.crafttweaker.IContainerFunction;
import io.bluebeaker.backpackdisplay.utils.IngredientMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.backpackdisplay.BackpackDisplay")
@ZenRegister
public class BackpackDisplayItemsCT {
    private static final IngredientMap<IContainerFunction> PREVIEW_FUNCTIONS = new IngredientMap();

    @ZenCodeType.Method
    public static void addBackDisplay(IIngredient ingredient, IContainerFunction function) {
        CraftTweakerAPI.apply((IAction)new AddBackpackDisplayAction(ingredient, function));
    }

    public static List<IContainerFunction> getFunctions(IItemStack item) {
        return PREVIEW_FUNCTIONS.getEntries(item);
    }

    public static List<IItemStack> getDisplayItems(IItemStack item) {
        ArrayList<IItemStack> items = new ArrayList<IItemStack>();
        for (IContainerFunction func : BackpackDisplayItemsCT.getFunctions(item)) {
            items.addAll(Arrays.asList(func.process(item)));
        }
        return items;
    }

    public static class AddBackpackDisplayAction
    implements IUndoableAction {
        private final IIngredient ingredient;
        private final IContainerFunction function;
        @Nullable
        private IngredientMap.IngredientMapEntry<IContainerFunction> entry;

        public AddBackpackDisplayAction(IIngredient ingredient, IContainerFunction function) {
            this.ingredient = ingredient;
            this.function = function;
        }

        public void apply() {
            this.entry = PREVIEW_FUNCTIONS.register(this.ingredient, this.function);
        }

        public void undo() {
            PREVIEW_FUNCTIONS.unregister(this.entry);
        }

        public String describe() {
            return "Adding backpack display items for " + String.valueOf(this.ingredient);
        }

        public String describeUndo() {
            return "Removing backpack display item for " + String.valueOf(this.ingredient);
        }

        public String systemName() {
            return "backpackdisplay-Item";
        }
    }
}

