/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Stack;
import journeymap.client.api.display.Context;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.model.TextProperties;
import journeymap.client.api.util.PolygonHelper;
import journeymap.client.io.nbt.RegionLoader;
import journeymap.client.model.RegionCoord;
import journeymap.client.ui.fullscreen.Fullscreen;
import net.minecraft.class_2338;
import net.minecraft.class_310;

public class RegionRenderer {
    private static RegionRenderer instance;
    public static boolean TOGGLED;

    private RegionRenderer() {
    }

    public static void render(boolean toggled) {
        if (instance == null) {
            instance = new RegionRenderer();
        }
        TOGGLED = toggled;
        if (toggled) {
            ClientAPI.INSTANCE.flagOverlaysForRerender();
            PolygonOverlay overlay = instance.createOverlay((RegionCoord)instance.getRegions().firstElement());
            ClientAPI.INSTANCE.show((Displayable)overlay);
        } else {
            ClientAPI.INSTANCE.removeAll("journeymap", DisplayType.Polygon);
        }
    }

    private Stack<RegionCoord> getRegions() {
        try {
            class_310 minecraft = class_310.method_1551();
            RegionLoader regionLoader = new RegionLoader(minecraft, Fullscreen.state().getMapType(), true);
            return regionLoader.getRegions();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load regions", e);
        }
    }

    protected PolygonOverlay createOverlay(RegionCoord rCoord) {
        String displayId = "Region Display" + rCoord;
        String groupName = "Region";
        String label = "x:" + rCoord.regionX + ", z:" + rCoord.regionZ;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(5.0f).setStrokeColor(0xFF0000).setStrokeOpacity(0.7f).setFillOpacity(0.2f);
        TextProperties textProps = new TextProperties().setBackgroundColor(34).setBackgroundOpacity(0.5f).setColor(65280).setOpacity(1.0f).setFontShadow(true);
        int x = rCoord.getMinChunkX() << 4;
        int y = 70;
        int z = rCoord.getMinChunkZ() << 4;
        int maxX = (rCoord.getMaxChunkX() << 4) + 15;
        int maxZ = (rCoord.getMaxChunkZ() << 4) + 15;
        ArrayList<class_2338> blockPosList = new ArrayList<class_2338>();
        blockPosList.add(new class_2338(384, 256, 128));
        blockPosList.add(new class_2338(144, 256, 304));
        blockPosList.add(new class_2338(144, 256, 224));
        blockPosList.add(new class_2338(160, 256, 224));
        blockPosList.add(new class_2338(160, 256, 128));
        blockPosList.add(new class_2338(272, 256, 128));
        blockPosList.add(new class_2338(272, 256, 144));
        blockPosList.add(new class_2338(288, 256, 144));
        blockPosList.add(new class_2338(288, 256, 128));
        blockPosList.add(new class_2338(368, 256, 128));
        MapPolygon hole = PolygonHelper.createChunkPolygonForWorldCoords((int)284, (int)70, (int)197);
        PolygonOverlay overlay = new PolygonOverlay("journeymap", displayId, rCoord.dimension, shapeProps, new MapPolygon(blockPosList), Collections.singletonList(hole));
        overlay.setOverlayGroupName(groupName).setTitle("Test Title").setLabel(label).setTextProperties(textProps).setActiveUIs(EnumSet.of(Context.UI.Fullscreen, Context.UI.Minimap, Context.UI.Webmap)).setActiveMapTypes(EnumSet.of(Context.MapType.Any));
        return overlay;
    }

    static {
        TOGGLED = false;
    }
}

