/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.datagen.recipes;

import java.util.Arrays;
import java.util.function.UnaryOperator;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_5258;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.valhelsia.valhelsia_core.api.common.item.ingredient.PlatformDependentIngredient;
import net.valhelsia.valhelsia_core.api.datagen.recipes.RecipePart;
import net.valhelsia.valhelsia_core.api.datagen.recipes.ValhelsiaRecipeProvider;
import net.valhelsia.valhelsia_core.api.datagen.recipes.ValhelsiaShapedRecipeBuilder;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeSubProvider {
    public static final class_6862<class_1792> FORGE_WOODEN_CHESTS_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("forge", "chests/wooden"));
    public static final class_6862<class_1792> FABRIC_CHESTS_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("c", "chests"));
    public static final class_1856 WOODEN_STICK_INGREDIENT = PlatformDependentIngredient.createIngredient(new class_2960("forge", "rods/wooden"), (class_1935)class_1802.field_8600);
    public static final class_1856 WOODEN_CHEST_INGREDIENT = PlatformDependentIngredient.createIngredient(FORGE_WOODEN_CHESTS_TAG.comp_327(), FABRIC_CHESTS_TAG.comp_327());
    private final ValhelsiaRecipeProvider provider;

    public RecipeSubProvider(ValhelsiaRecipeProvider provider) {
        this.provider = provider;
    }

    protected abstract void registerRecipes();

    public void add(class_5797 builder) {
        builder.method_10431(this.provider.getFinishedRecipeConsumer());
    }

    public void add(class_5797 builder, String path) {
        builder.method_17972(this.provider.getFinishedRecipeConsumer(), new class_2960(this.provider.getModId(), path));
    }

    public void storageRecipe(class_1935 item, class_1935 block) {
        this.storageRecipe(item, block, null, null);
    }

    public void storageRecipe(class_1935 item, class_1935 block, @Nullable String groupItem, @Nullable String groupBlock) {
        this.shaped(class_7800.field_40642, block, builder -> builder.group(groupBlock).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), item).unlockedBy(this, item), RecipeSubProvider.getName(block) + "_from_" + RecipeSubProvider.getName(item));
        this.shapeless(class_7800.field_40634, item, 9, builder -> builder.method_10452(groupItem).method_10454(block).method_10442("has_item", (class_184)RecipeSubProvider.has(block)), RecipeSubProvider.getName(item) + "_from_" + RecipeSubProvider.getName(block));
    }

    public void simple2x2(class_7800 category, class_1935 result, RecipePart<?> item) {
        this.shaped(category, result, builder -> builder.pattern("##").pattern("##").define(Character.valueOf('#'), item).unlockedBy(this, item));
    }

    public void singleRow(class_7800 category, class_1935 result, RecipePart<?> item) {
        this.shaped(category, result, builder -> builder.pattern("###").define(Character.valueOf('#'), item).unlockedBy(this, item));
    }

    public void surroundingItem(class_7800 category, class_1935 result, RecipePart<?> middle, RecipePart<?> outside, int amount) {
        this.shaped(category, result, amount, builder -> builder.pattern("###").pattern("#X#").pattern("###").define(Character.valueOf('#'), outside).define(Character.valueOf('X'), middle).unlockedBy(this.getHasName(middle), (class_184)this.has(middle)).unlockedBy(this, outside));
    }

    public void wood(class_1935 result, RecipePart<?> log) {
        this.shaped(class_7800.field_40634, result, 3, builder -> builder.group("bark").pattern("##").pattern("##").define(Character.valueOf('#'), log).unlockedBy(this, log));
    }

    public void planks(class_1935 result, class_6862<class_1792> log) {
        this.planks(result, log, 4);
    }

    public void planks(class_1935 result, class_6862<class_1792> log, int count) {
        this.shapeless(class_7800.field_40634, result, count, builder -> builder.method_10446(log).method_10442("has_log", (class_184)RecipeSubProvider.has(log)));
    }

    public void slab(class_1935 result, RecipePart<?> planks) {
        this.shaped(class_7800.field_40634, result, 6, builder -> builder.pattern("###").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void woodenSlab(class_1935 result, RecipePart<?> planks) {
        this.shaped(class_7800.field_40634, result, 6, builder -> builder.group("wooden_slab").pattern("###").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void stairs(class_1935 result, RecipePart<?> planks) {
        this.shaped(class_7800.field_40634, result, 4, builder -> builder.pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void sword(class_1935 result, RecipePart<?> material) {
        this.shaped(class_7800.field_40639, result, builder -> builder.pattern("#").pattern("#").pattern("X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), WOODEN_STICK_INGREDIENT).unlockedBy(this, material));
    }

    public void shovel(class_1935 result, RecipePart<?> material) {
        this.shaped(class_7800.field_40638, result, builder -> builder.pattern("#").pattern("X").pattern("X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), WOODEN_STICK_INGREDIENT).unlockedBy(this, material));
    }

    public void pickaxe(class_1935 result, RecipePart<?> material) {
        this.shaped(class_7800.field_40638, result, builder -> builder.pattern("###").pattern(" X ").pattern(" X ").define(Character.valueOf('#'), material).define(Character.valueOf('X'), WOODEN_STICK_INGREDIENT).unlockedBy(this, material));
    }

    public void axe(class_1935 result, RecipePart<?> material) {
        this.shaped(class_7800.field_40638, result, builder -> builder.pattern("##").pattern("#X").pattern(" X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), WOODEN_STICK_INGREDIENT).unlockedBy(this, material));
    }

    public void hoe(class_1935 result, RecipePart<?> material) {
        this.shaped(class_7800.field_40638, result, builder -> builder.pattern("##").pattern(" X").pattern(" X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), WOODEN_STICK_INGREDIENT).unlockedBy(this, material));
    }

    public void helmet(class_1935 result, RecipePart<?> material) {
        this.shaped(class_7800.field_40639, result, builder -> builder.pattern("###").pattern("# #").define(Character.valueOf('#'), material).unlockedBy(this, material));
    }

    public void chestplate(class_1935 result, RecipePart<?> material) {
        this.shaped(class_7800.field_40639, result, builder -> builder.pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), material).unlockedBy(this, material));
    }

    public void leggings(class_1935 result, RecipePart<?> material) {
        this.shaped(class_7800.field_40639, result, builder -> builder.pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), material).unlockedBy(this, material));
    }

    public void boots(class_1935 result, RecipePart<?> material) {
        this.shaped(class_7800.field_40639, result, builder -> builder.pattern("# #").pattern("# #").define(Character.valueOf('#'), material).unlockedBy(this, material));
    }

    public void boat(class_1935 result, RecipePart<?> material) {
        this.shaped(class_7800.field_40637, result, builder -> builder.pattern("# #").pattern("###").define(Character.valueOf('#'), material).unlockedBy(this, material));
    }

    public void chestBoat(class_1935 result, class_1935 boat) {
        this.shapeless(class_7800.field_40637, result, builder -> builder.method_10454(boat).method_10451(WOODEN_CHEST_INGREDIENT).method_10442("has_" + RecipeSubProvider.getName(boat), (class_184)RecipeSubProvider.has(boat)).method_10442("has_chest", (class_184)RecipeSubProvider.has(FORGE_WOODEN_CHESTS_TAG, FABRIC_CHESTS_TAG)));
    }

    public void glassPane(class_1935 result, RecipePart<?> glass) {
        this.shaped(class_7800.field_40634, result, 16, builder -> builder.pattern("###").pattern("###").define(Character.valueOf('#'), glass).unlockedBy(this, glass));
    }

    public void woodenStairs(class_1935 result, RecipePart<?> planks) {
        this.shaped(class_7800.field_40634, result, 4, builder -> builder.group("wooden_stairs").pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void sign(class_1935 result, RecipePart<?> planks) {
        this.shaped(class_7800.field_40635, result, 3, builder -> builder.pattern("###").pattern("###").pattern(" X ").define(Character.valueOf('#'), planks).define(Character.valueOf('X'), WOODEN_STICK_INGREDIENT).unlockedBy(this, planks));
    }

    public void door(class_1935 result, RecipePart<?> planks) {
        this.shaped(class_7800.field_40634, result, 3, builder -> builder.pattern("##").pattern("##").pattern("##").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void trapdoor(class_1935 result, RecipePart<?> planks) {
        this.shaped(class_7800.field_40634, result, 2, builder -> builder.pattern("###").pattern("###").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void fence(class_1935 result, RecipePart<?> planks) {
        this.shaped(class_7800.field_40634, result, 3, builder -> builder.pattern("#X#").pattern("#X#").define(Character.valueOf('#'), planks).define(Character.valueOf('X'), WOODEN_STICK_INGREDIENT).unlockedBy(this, planks));
    }

    public void fenceGate(class_1935 result, RecipePart<?> planks) {
        this.shaped(class_7800.field_40634, result, builder -> builder.pattern("#X#").pattern("#X#").define(Character.valueOf('X'), planks).define(Character.valueOf('#'), WOODEN_STICK_INGREDIENT).unlockedBy(this, planks));
    }

    public void button(class_1935 result, class_1935 planks) {
        this.shapeless(class_7800.field_40636, result, builder -> builder.method_10454(planks).method_10442("has_planks", (class_184)RecipeSubProvider.has(planks)));
    }

    public void pressurePlate(class_1935 result, RecipePart<?> planks) {
        this.shaped(class_7800.field_40636, result, builder -> builder.pattern("##").define(Character.valueOf('#'), planks).unlockedBy(this, planks));
    }

    public void carpet(class_1935 result, RecipePart<?> material) {
        this.shaped(class_7800.field_40635, result, 3, builder -> builder.pattern("##").define(Character.valueOf('#'), material).unlockedBy(this, material));
    }

    public void shaped(class_7800 category, class_1935 result, UnaryOperator<ValhelsiaShapedRecipeBuilder> recipe) {
        this.add((class_5797)((ValhelsiaShapedRecipeBuilder)recipe.apply(ValhelsiaShapedRecipeBuilder.shaped(category, result))).builder());
    }

    public void shaped(class_7800 category, class_1935 result, UnaryOperator<ValhelsiaShapedRecipeBuilder> recipe, String path) {
        this.add((class_5797)((ValhelsiaShapedRecipeBuilder)recipe.apply(ValhelsiaShapedRecipeBuilder.shaped(category, result))).builder(), path);
    }

    public void shaped(class_7800 category, class_1935 result, int count, UnaryOperator<ValhelsiaShapedRecipeBuilder> recipe) {
        this.add((class_5797)((ValhelsiaShapedRecipeBuilder)recipe.apply(ValhelsiaShapedRecipeBuilder.shaped(category, result, count))).builder());
    }

    public void shaped(class_7800 category, class_1935 result, int count, UnaryOperator<ValhelsiaShapedRecipeBuilder> recipe, String path) {
        this.add((class_5797)((ValhelsiaShapedRecipeBuilder)recipe.apply(ValhelsiaShapedRecipeBuilder.shaped(category, result, count))).builder(), path);
    }

    public void shapeless(class_7800 category, class_1935 result, UnaryOperator<class_2450> recipe) {
        this.add((class_5797)recipe.apply(class_2450.method_10447((class_7800)category, (class_1935)result)));
    }

    public void shapeless(class_7800 category, class_1935 result, UnaryOperator<class_2450> recipe, String path) {
        this.add((class_5797)recipe.apply(class_2450.method_10447((class_7800)category, (class_1935)result)), path);
    }

    public void shapeless(class_7800 category, class_1935 result, int count, UnaryOperator<class_2450> recipe) {
        this.add((class_5797)recipe.apply(class_2450.method_10448((class_7800)category, (class_1935)result, (int)count)));
    }

    public void shapeless(class_7800 category, class_1935 result, int count, UnaryOperator<class_2450> recipe, String path) {
        this.add((class_5797)recipe.apply(class_2450.method_10448((class_7800)category, (class_1935)result, (int)count)), path);
    }

    public static String getName(class_1935 item) {
        return class_7923.field_41178.method_10221((Object)item.method_8389()).method_12832();
    }

    public class_2066.class_2068 has(RecipePart<?> part) {
        Object obj = part.get();
        if (obj instanceof class_1935) {
            class_1935 itemLike = (class_1935)obj;
            return RecipeSubProvider.has(itemLike);
        }
        obj = part.get();
        if (obj instanceof class_6862) {
            class_6862 tagKey = (class_6862)obj;
            return RecipeSubProvider.has((class_6862<class_1792>)tagKey);
        }
        obj = part.get();
        if (obj instanceof class_1856) {
            class_1856 ingredient = (class_1856)obj;
            class_1935[] itemLikes = (class_1935[])Arrays.stream(ingredient.method_8105()).map(class_1799::method_7909).toArray(class_1935[]::new);
            return RecipeSubProvider.inventoryTrigger(class_2073.class_2074.method_8973().method_8977(itemLikes).method_8976());
        }
        throw new IllegalArgumentException("Invalid type: " + part.get().getClass());
    }

    public String getHasName(RecipePart<?> part) {
        Object obj = part.get();
        if (obj instanceof class_1935) {
            class_1935 itemLike = (class_1935)obj;
            return RecipeSubProvider.getHasName(itemLike);
        }
        obj = part.get();
        if (obj instanceof class_6862) {
            class_6862 tagKey = (class_6862)obj;
            return "has_" + tagKey.comp_327().method_12832();
        }
        if (part.get() instanceof class_1856) {
            return "has_item";
        }
        throw new IllegalArgumentException("Invalid type: " + part.get().getClass());
    }

    public RecipePart<class_1935> item(class_1935 itemLike) {
        return RecipePart.of(itemLike);
    }

    public RecipePart<class_6862<class_1792>> tag(class_6862<class_1792> itemTagKey) {
        return RecipePart.of(itemTagKey);
    }

    public RecipePart<class_1856> ingredient(class_1856 ingredient) {
        return RecipePart.of(ingredient);
    }

    protected static class_2066.class_2068 has(class_1935 ... items) {
        return RecipeSubProvider.inventoryTrigger(class_2073.class_2074.method_8973().method_8977(items).method_8976());
    }

    protected static class_2066.class_2068 has(class_6862<class_1792> tagKey) {
        return RecipeSubProvider.inventoryTrigger(class_2073.class_2074.method_8973().method_8975(tagKey).method_8976());
    }

    protected static class_2066.class_2068 has(class_6862<class_1792> forgeTag, class_6862<class_1792> fabricTag) {
        return RecipeSubProvider.inventoryTrigger(class_2073.class_2074.method_8973().method_8975(forgeTag).method_8976(), class_2073.class_2074.method_8973().method_8975(fabricTag).method_8976());
    }

    protected static class_2066.class_2068 inventoryTrigger(class_2073 ... predicates) {
        return new class_2066.class_2068(class_5258.field_24388, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, predicates);
    }

    protected static String getHasName(class_1935 itemLike) {
        return "has_" + RecipeSubProvider.getName(itemLike);
    }
}

