/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.reward;

import com.vecoo.extraquests.task.KeyValueTask;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class KeyValueReward
extends Reward {
    public static RewardType TYPE;
    private String key = "key";
    private long value = 5L;
    private boolean ignore = false;

    public KeyValueReward(long id, Quest quest) {
        super(id, quest);
    }

    public RewardType getType() {
        return TYPE;
    }

    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("key", this.key);
        nbt.method_10544("value", this.value);
        nbt.method_10556("ignore", this.ignore);
    }

    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.key = nbt.method_10558("key");
        this.value = nbt.method_10537("value");
        this.ignore = nbt.method_10577("ignore");
    }

    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10788(this.key, Short.MAX_VALUE);
        buffer.method_10791(this.value);
        buffer.writeBoolean(this.ignore);
    }

    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.key = buffer.method_10800(Short.MAX_VALUE);
        this.value = buffer.method_10792();
        this.ignore = buffer.readBoolean();
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43469((String)"extraquests.key_value.title", (Object[])new Object[]{this.key, this.value});
    }

    @Environment(value=EnvType.CLIENT)
    public String getButtonText() {
        return "+" + this.value;
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("key", this.key, value -> {
            this.key = value;
        }, this.key).setNameKey("extraquests.key_value.key");
        config.addLong("value", this.value, value -> {
            this.value = value;
        }, 5L, 1L, Long.MAX_VALUE).setNameKey("extraquests.key_value.value");
        config.addBool("ignore", this.ignore, value -> {
            this.ignore = value;
        }, false).setNameKey("extraquests.key_value.ignore");
    }

    public void claim(class_3222 player, boolean notify) {
        for (KeyValueTask task : ServerQuestFile.INSTANCE.collect(KeyValueTask.class)) {
            task.progress(ServerQuestFile.INSTANCE.getOrCreateTeamData((class_1297)player), this.key, this.value, this.ignore);
        }
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public long getValue() {
        return this.value;
    }

    @Generated
    public boolean isIgnore() {
        return this.ignore;
    }
}

