/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.loot;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.gui.EditRewardTableScreen;
import dev.ftb.mods.ftbquests.client.gui.RewardTablesScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.RecipeModHelper;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public final class RewardTable
extends QuestObjectBase {
    private final BaseQuestFile file;
    private final List<WeightedReward> weightedRewards;
    private final Quest fakeQuest;
    private float emptyWeight;
    private int lootSize;
    private boolean hideTooltip;
    private boolean useTitle;
    private LootCrate lootCrate;
    private class_2960 lootTableId;
    private String filename;

    public RewardTable(long id, BaseQuestFile file) {
        this(id, file, "");
    }

    public RewardTable(long id, BaseQuestFile file, String filename) {
        super(id);
        this.file = file;
        this.filename = filename;
        this.weightedRewards = new ArrayList<WeightedReward>();
        this.fakeQuest = new Quest(-1L, new Chapter(-1L, this.file, file.getDefaultChapterGroup()));
        this.emptyWeight = 0.0f;
        this.lootSize = 1;
        this.hideTooltip = false;
        this.useTitle = false;
        this.lootCrate = null;
        this.lootTableId = null;
    }

    public class_2561 getTitleOrElse(class_2561 def) {
        return this.useTitle ? this.getTitle() : def;
    }

    public BaseQuestFile getFile() {
        return this.file;
    }

    public List<WeightedReward> getWeightedRewards() {
        return Collections.unmodifiableList(this.weightedRewards);
    }

    @Nullable
    public LootCrate getLootCrate() {
        return this.lootCrate;
    }

    public Quest getFakeQuest() {
        return this.fakeQuest;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.REWARD_TABLE;
    }

    @Override
    public BaseQuestFile getQuestFile() {
        return this.file;
    }

    public float getTotalWeight(boolean includeEmpty) {
        float initial = includeEmpty ? this.emptyWeight : 0.0f;
        return this.weightedRewards.stream().map(WeightedReward::getWeight).reduce(Float.valueOf(initial), Float::sum).floatValue();
    }

    public Collection<WeightedReward> generateWeightedRandomRewards(class_5819 random, int nAttempts, boolean includeEmpty) {
        float total = this.getTotalWeight(includeEmpty);
        if (total <= 0.0f) {
            return List.of();
        }
        List res = this.weightedRewards.stream().filter(reward -> reward.getWeight() == 0.0f).collect(Collectors.toCollection(ArrayList::new));
        nAttempts *= this.lootSize;
        block0: for (int i = 0; i < nAttempts; ++i) {
            float currentWeight;
            float threshold = random.method_43057() * total;
            float f = currentWeight = includeEmpty ? this.emptyWeight : 0.0f;
            if (!(currentWeight < threshold)) continue;
            for (WeightedReward reward2 : this.weightedRewards) {
                if (!((currentWeight += reward2.getWeight()) >= threshold)) continue;
                res.add(reward2);
                continue block0;
            }
        }
        return res;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        if (this.emptyWeight > 0.0f) {
            nbt.method_10548("empty_weight", this.emptyWeight);
        }
        nbt.method_10569("loot_size", this.lootSize);
        if (this.hideTooltip) {
            nbt.method_10556("hide_tooltip", true);
        }
        if (this.useTitle) {
            nbt.method_10556("use_title", true);
        }
        class_2499 list = new class_2499();
        for (WeightedReward wr : this.weightedRewards) {
            SNBTCompoundTag nbt1 = new SNBTCompoundTag();
            wr.getReward().writeData((class_2487)nbt1);
            if (wr.getReward().getType() != RewardTypes.ITEM) {
                nbt1.method_10582("type", wr.getReward().getType().getTypeForNBT());
            } else if (nbt1.method_10540("item") == 8) {
                nbt1.singleLine();
            }
            if (wr.getWeight() != 1.0f) {
                nbt1.method_10548("weight", wr.getWeight());
            }
            list.add((Object)nbt1);
        }
        nbt.method_10566("rewards", (class_2520)list);
        if (this.lootCrate != null) {
            class_2487 nbt1 = new class_2487();
            this.lootCrate.writeData(nbt1);
            nbt.method_10566("loot_crate", (class_2520)nbt1);
        }
        if (this.lootTableId != null) {
            nbt.method_10582("loot_table_id", this.lootTableId.toString());
        }
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.emptyWeight = nbt.method_10583("empty_weight");
        this.lootSize = nbt.method_10550("loot_size");
        this.hideTooltip = nbt.method_10577("hide_tooltip");
        this.useTitle = nbt.method_10577("use_title");
        this.weightedRewards.clear();
        class_2499 list = nbt.method_10554("rewards", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 nbt1 = list.method_10602(i);
            Reward reward = RewardType.createReward(0L, this.fakeQuest, nbt1.method_10558("type"));
            if (reward == null) continue;
            reward.readData(nbt1);
            this.weightedRewards.add(new WeightedReward(reward, nbt1.method_10545("weight") ? nbt1.method_10583("weight") : 1.0f));
        }
        this.lootCrate = null;
        if (nbt.method_10545("loot_crate")) {
            this.lootCrate = new LootCrate(this, false);
            this.lootCrate.readData(nbt.method_10562("loot_crate"));
        }
        this.lootTableId = nbt.method_10545("loot_table_id") ? new class_2960(nbt.method_10558("loot_table_id")) : null;
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10788(this.filename, Short.MAX_VALUE);
        buffer.writeFloat(this.emptyWeight);
        buffer.method_10804(this.lootSize);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (boolean)this.hideTooltip);
        flags = Bits.setFlag((int)flags, (int)2, (boolean)this.useTitle);
        flags = Bits.setFlag((int)flags, (int)4, (this.lootCrate != null ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (this.lootTableId != null ? 1 : 0) != 0);
        buffer.method_10804(flags);
        buffer.method_10804(this.weightedRewards.size());
        for (WeightedReward wr : this.weightedRewards) {
            buffer.method_10804(wr.getReward().getType().intId);
            wr.getReward().writeNetData(buffer);
            buffer.writeFloat(wr.getWeight());
        }
        if (this.lootCrate != null) {
            this.lootCrate.writeNetData(buffer);
        }
        if (this.lootTableId != null) {
            buffer.method_10812(this.lootTableId);
        }
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.filename = buffer.method_10800(Short.MAX_VALUE);
        this.emptyWeight = buffer.readFloat();
        this.lootSize = buffer.method_10816();
        int flags = buffer.method_10816();
        this.hideTooltip = Bits.getFlag((int)flags, (int)1);
        this.useTitle = Bits.getFlag((int)flags, (int)2);
        boolean hasCrate = Bits.getFlag((int)flags, (int)4);
        boolean hasLootTableId = Bits.getFlag((int)flags, (int)8);
        this.weightedRewards.clear();
        int s = buffer.method_10816();
        for (int i = 0; i < s; ++i) {
            RewardType type = this.file.getRewardType(buffer.method_10816());
            Reward reward = type.createReward(0L, this.fakeQuest);
            reward.readNetData(buffer);
            float weight = buffer.readFloat();
            this.weightedRewards.add(new WeightedReward(reward, weight));
        }
        this.lootCrate = null;
        if (hasCrate) {
            this.lootCrate = new LootCrate(this, false);
            this.lootCrate.readNetData(buffer);
        }
        this.lootTableId = hasLootTableId ? buffer.method_10810() : null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addDouble("empty_weight", (double)this.emptyWeight, v -> {
            this.emptyWeight = v.floatValue();
        }, 0.0, 0.0, 2.147483647E9);
        config.addInt("loot_size", this.lootSize, v -> {
            this.lootSize = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addBool("hide_tooltip", this.hideTooltip, v -> {
            this.hideTooltip = v;
        }, false);
        config.addBool("use_title", this.useTitle, v -> {
            this.useTitle = v;
        }, false);
        if (this.lootCrate != null) {
            this.lootCrate.fillConfigGroup(config.getOrCreateSubgroup("loot_crate").setNameKey("item.ftbquests.lootcrate"));
        }
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.weightedRewards.forEach(reward -> reward.getReward().clearCachedData());
    }

    @Override
    public void deleteSelf() {
        this.file.removeRewardTable(this);
        super.deleteSelf();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null && gui.isViewingQuest()) {
            gui.refreshViewQuestPanel();
        } else {
            RewardTablesScreen gui1 = (RewardTablesScreen)((Object)ClientUtils.getCurrentGuiAs(RewardTablesScreen.class));
            if (gui1 != null) {
                gui1.refreshWidgets();
            }
        }
        this.file.updateLootCrates();
    }

    @Override
    public void editedFromGUIOnServer() {
        this.file.updateLootCrates();
    }

    @Override
    public void onCreated() {
        if (this.filename.isEmpty()) {
            this.filename = this.file.generateRewardTableName(RewardTable.titleToID(this.rawTitle).orElse(this.toString()));
        }
        this.file.addRewardTable(this);
    }

    public String getFilename() {
        if (this.filename.isEmpty()) {
            this.filename = RewardTable.getCodeString(this);
        }
        return this.filename;
    }

    @Override
    public Optional<String> getPath() {
        return Optional.of("reward_tables/" + this.getFilename() + ".snbt");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2561 getAltTitle() {
        return this.weightedRewards.size() == 1 ? this.weightedRewards.get(0).getReward().getTitle() : class_2561.method_43471((String)"ftbquests.reward_table");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        if (this.lootCrate != null) {
            return ItemIcon.getItemIcon((class_1799)this.lootCrate.createStack());
        }
        if (this.weightedRewards.isEmpty()) {
            return Icons.DICE;
        }
        List icons = this.weightedRewards.stream().map(reward -> reward.getReward().getIcon()).collect(Collectors.toList());
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onEditButtonClicked(Runnable gui) {
        new EditRewardTableScreen(gui, this, editedReward -> {
            new EditObjectMessage((QuestObjectBase)editedReward).sendToServer();
            this.clearCachedData();
        }).openGui();
    }

    public void addMouseOverText(TooltipList list, boolean includeWeight, boolean includeEmpty) {
        if (ClientQuestFile.INSTANCE.canEdit() || !this.hideTooltip) {
            float totalWeight = this.getTotalWeight(includeEmpty);
            if (includeWeight && includeEmpty && this.emptyWeight > 0.0f) {
                RewardTable.addItem(list, (class_2561)class_2561.method_43471((String)"ftbquests.reward_table.nothing"), this.emptyWeight, totalWeight);
            }
            List sortedRewards = this.weightedRewards.stream().sorted().toList();
            BaseScreen gui = (BaseScreen)ClientUtils.getCurrentGuiAs(BaseScreen.class);
            int maxLines = gui == null ? 12 : (gui.height - 20) / (gui.getTheme().getFontHeight() + 2);
            int nRewards = sortedRewards.size();
            int start = nRewards > maxLines ? (int)(FTBQuestsClient.getClientLevel().method_8510() / 10L % (long)nRewards) : 0;
            int nLines = Math.min(maxLines, nRewards);
            for (int idx = 0; idx < nLines; ++idx) {
                WeightedReward wr = (WeightedReward)sortedRewards.get((start + idx) % nRewards);
                if (includeWeight) {
                    RewardTable.addItem(list, wr.getReward().getTitle(), wr.getWeight(), totalWeight);
                    continue;
                }
                list.add((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852(wr.getReward().getTitle()));
            }
        }
    }

    private static void addItem(TooltipList list, class_2561 text, float weight, float totalWeight) {
        list.add((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852(text).method_10852((class_2561)class_2561.method_43470((String)(" [" + WeightedReward.chanceString(weight, totalWeight) + "]")).method_27692(class_124.field_1063)));
    }

    @Override
    public Set<RecipeModHelper.Components> componentsToRefresh() {
        return EnumSet.of(RecipeModHelper.Components.LOOT_CRATES);
    }

    public void addReward(WeightedReward weightedReward) {
        this.weightedRewards.add(weightedReward);
    }

    public void removeReward(WeightedReward weightedReward) {
        this.weightedRewards.remove(weightedReward);
    }

    public WeightedReward makeWeightedItemReward(class_1799 stack, float weight) {
        return new WeightedReward(new ItemReward(0L, this.fakeQuest, stack), weight);
    }

    public LootCrate toggleLootCrate() {
        this.lootCrate = this.lootCrate == null ? new LootCrate(this, true) : null;
        return this.lootCrate;
    }

    public boolean shouldShowTooltip() {
        return !this.hideTooltip;
    }
}

