/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_furniture.common.block.FurnitureBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableBlock
extends class_2248
implements class_3737,
FurnitureBlock {
    private static final int MAX_LENGTH = 5;
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    private static final class_2746 ROTATED = ModBlockStateProperties.ROTATED;
    private static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final EnumMap<class_2350, class_2746> PROPERTY_BY_DIRECTION = (EnumMap)class_156.method_654(new EnumMap(class_2350.class), map -> {
        map.put(class_2350.field_11043, NORTH);
        map.put(class_2350.field_11034, EAST);
        map.put(class_2350.field_11035, SOUTH);
        map.put(class_2350.field_11039, WEST);
    });
    private static final class_265 TOP_SHAPE = class_2248.method_9541((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<class_2350, class_265> TWO_LEGS_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((class_265)class_259.method_17786((class_265)TOP_SHAPE, (class_265[])new class_265[]{class_2248.method_9541((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), class_2248.method_9541((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)}));
    private static final Map<class_2350, class_265> ONE_LEG_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((class_265)class_259.method_1084((class_265)TOP_SHAPE, (class_265)class_2248.method_9541((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)));
    private static final class_265 SHAPE = class_259.method_17786((class_265)TOP_SHAPE, (class_265[])new class_265[]{class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), class_2248.method_9541((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), class_2248.method_9541((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0), class_2248.method_9541((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0)});
    private final class_4719 woodType;

    public TableBlock(class_4719 woodType, class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ROTATED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.woodType = woodType;
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        ArrayList<class_2350> connectedDirections = new ArrayList<class_2350>();
        for (class_2350 direction : class_2350.values()) {
            if (direction.method_10166() == class_2350.class_2351.field_11052 || !((Boolean)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            connectedDirections.add(direction);
        }
        if (connectedDirections.size() >= 3 || connectedDirections.size() == 2 && connectedDirections.get(0) == ((class_2350)connectedDirections.get(1)).method_10153()) {
            return TOP_SHAPE;
        }
        if (connectedDirections.size() == 1) {
            return TWO_LEGS_SHAPES.get(connectedDirections.get(0));
        }
        if (connectedDirections.size() == 2) {
            boolean flag = ((class_2350)connectedDirections.get(0)).method_10170() == connectedDirections.get(1);
            return flag ? ONE_LEG_SHAPES.get(connectedDirections.get(0)) : ONE_LEG_SHAPES.get(connectedDirections.get(1));
        }
        return SHAPE;
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 context) {
        boolean flag = context.method_8045().method_8316(context.method_8037()).method_15772() == class_3612.field_15910;
        boolean rotated = context.method_8042().method_10166() == class_2350.class_2351.field_11048;
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)ROTATED, (Comparable)Boolean.valueOf(rotated))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean method_9526(@NotNull class_2680 state) {
        return true;
    }

    @NotNull
    public class_2680 method_9559(@NotNull class_2680 state, @NotNull class_2350 direction, @NotNull class_2680 neighborState, @NotNull class_1936 level, @NotNull class_2338 currentPos, @NotNull class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return state;
        }
        class_2746 property = PROPERTY_BY_DIRECTION.get(direction);
        class_2746 oppositeProperty = PROPERTY_BY_DIRECTION.get(direction.method_10153());
        if (neighborState.method_26204() instanceof TableBlock) {
            if (((Boolean)neighborState.method_11654((class_2769)oppositeProperty)).booleanValue() && !((Boolean)state.method_11654((class_2769)property)).booleanValue()) {
                return (class_2680)state.method_11657((class_2769)property, (Comparable)Boolean.valueOf(true));
            }
            if (!((Boolean)neighborState.method_11654((class_2769)oppositeProperty)).booleanValue() && ((Boolean)state.method_11654((class_2769)property)).booleanValue()) {
                return (class_2680)state.method_11657((class_2769)property, (Comparable)Boolean.valueOf(false));
            }
        } else if (((Boolean)state.method_11654((class_2769)property)).booleanValue()) {
            return (class_2680)state.method_11657((class_2769)property, (Comparable)Boolean.valueOf(false));
        }
        if (this.isValidTable(neighborState) && !((Boolean)state.method_11654((class_2769)property)).booleanValue()) {
            this.tryConnect(direction, currentPos, level);
        }
        return state;
    }

    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        for (class_2350 direction : class_2350.values()) {
            if (direction.method_10166() == class_2350.class_2351.field_11052 || !((Boolean)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            this.trySplit(direction, pos, (class_1936)level);
            break;
        }
        super.method_9576(level, pos, state, player);
    }

    private void tryConnect(class_2350 direction, class_2338 pos, class_1936 level) {
        class_2680 offsetState;
        class_2680 state;
        class_2338.class_2339 mutable;
        int j;
        class_2680 state2;
        class_2680 state3;
        int tableLength;
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        for (tableLength = 1; tableLength < 5 && (state3 = level.method_8320(pos.method_10079(direction.method_10153(), tableLength))).method_26204() instanceof TableBlock && ((Boolean)state3.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).booleanValue(); ++tableLength) {
        }
        int otherTableLength = 1;
        for (int j2 = 2; j2 < 5 && (state2 = level.method_8320(pos.method_10079(direction, j2))).method_26204() instanceof TableBlock && ((Boolean)state2.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10153()))).booleanValue(); ++j2) {
            ++otherTableLength;
        }
        if (tableLength + otherTableLength > 5) {
            return;
        }
        boolean flag = false;
        class_2338 offsetPos = pos.method_10093(direction);
        if (!this.isSameRotation(level.method_8320(pos), level.method_8320(offsetPos))) {
            return;
        }
        list.add(offsetPos);
        if (level.method_8320(offsetPos).method_26204() instanceof TableBlock) {
            flag = (Boolean)level.method_8320(offsetPos).method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10170()));
        }
        for (j = 1; j < 5; ++j) {
            mutable = pos.method_25503().method_10104(direction.method_10170(), j);
            state = level.method_8320((class_2338)mutable);
            offsetState = level.method_8320((class_2338)mutable.method_10098(direction));
            if (!this.isValidTable(state) || this.isValidTable(state) && !((Boolean)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10160()))).booleanValue() || !this.isSameRotation(level.method_8320(pos), state)) {
                if (!this.isValidTable(offsetState) || !flag) break;
                return;
            }
            if (!this.isValidTable(offsetState) || this.isValidTable(offsetState) && !((Boolean)offsetState.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10160()))).booleanValue() || !this.isSameRotation(level.method_8320(pos), offsetState)) {
                return;
            }
            flag = this.isValidTable(offsetState) ? (Boolean)offsetState.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10170())) : false;
            list.add(mutable);
            ++i;
        }
        flag = level.method_8320(offsetPos).method_26204() instanceof TableBlock ? (Boolean)level.method_8320(offsetPos).method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10160())) : false;
        for (j = 1; j < 5; ++j) {
            mutable = pos.method_25503().method_10104(direction.method_10160(), j);
            state = level.method_8320((class_2338)mutable);
            offsetState = level.method_8320((class_2338)mutable.method_10098(direction));
            if (!this.isValidTable(state) || this.isValidTable(state) && !((Boolean)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10170()))).booleanValue() || !this.isSameRotation(level.method_8320(pos), state)) {
                if (!this.isValidTable(offsetState) || !flag) break;
                return;
            }
            if (!this.isValidTable(offsetState) || this.isValidTable(offsetState) && !((Boolean)offsetState.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10170()))).booleanValue() || !this.isSameRotation(level.method_8320(pos), offsetState)) {
                return;
            }
            flag = this.isValidTable(offsetState) ? (Boolean)offsetState.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10160())) : false;
            list.add(mutable);
            ++i;
        }
        if (i >= 5) {
            return;
        }
        list.forEach(tablePos -> level.method_8652(tablePos, (class_2680)level.method_8320(tablePos).method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10153()), (Comparable)Boolean.valueOf(true)), 3));
    }

    private void trySplit(class_2350 direction, class_2338 pos, class_1936 level) {
        class_2338.class_2339 mutable;
        class_2680 offsetState;
        int j;
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        for (j = 1; j < 5 && this.isValidTable(offsetState = level.method_8320((class_2338)(mutable = pos.method_25503().method_10104(direction.method_10170(), j)))) && ((Boolean)offsetState.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10160()))).booleanValue(); ++j) {
            if (!((Boolean)offsetState.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            list.add(mutable.method_10062());
        }
        for (j = 1; j < 5 && this.isValidTable(offsetState = level.method_8320((class_2338)(mutable = pos.method_25503().method_10104(direction.method_10160(), j)))) && ((Boolean)offsetState.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10170()))).booleanValue(); ++j) {
            if (!((Boolean)offsetState.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            list.add(mutable.method_10062());
        }
        list.forEach(tablePos -> {
            class_2680 state = level.method_8320(tablePos);
            boolean rotated = (Boolean)state.method_11654((class_2769)ROTATED);
            level.method_8652(tablePos, class_2246.field_10124.method_9564(), 3);
            level.method_8652(tablePos, (class_2680)state.method_26204().method_9564().method_11657((class_2769)ROTATED, (Comparable)Boolean.valueOf(rotated)), 3);
        });
    }

    public boolean isValidTable(class_2680 state) {
        TableBlock table;
        class_2248 class_22482 = state.method_26204();
        return class_22482 instanceof TableBlock && (table = (TableBlock)class_22482).getWoodType() == this.getWoodType();
    }

    public boolean isSameRotation(class_2680 state1, class_2680 state2) {
        if (!this.isValidTable(state1) || !this.isValidTable(state2)) {
            return false;
        }
        return state1.method_11654((class_2769)ROTATED) == state2.method_11654((class_2769)ROTATED);
    }

    public class_4719 getWoodType() {
        return this.woodType;
    }

    @NotNull
    public class_2680 method_9598(@NotNull class_2680 state, @NotNull class_2470 rotation) {
        ArrayList<class_2350> directions = new ArrayList<class_2350>();
        for (Map.Entry<class_2350, class_2746> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (((Boolean)state.method_11654((class_2769)entry.getValue())).booleanValue()) {
                directions.add(rotation.method_10503(entry.getKey()));
            }
            state = (class_2680)state.method_11657((class_2769)entry.getValue(), (Comparable)Boolean.valueOf(false));
        }
        for (class_2350 direction : directions) {
            state = (class_2680)state.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @NotNull
    public class_2680 method_9569(@NotNull class_2680 state, @NotNull class_2415 mirror) {
        ArrayList<class_2350> directions = new ArrayList<class_2350>();
        for (Map.Entry<class_2350, class_2746> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (((Boolean)state.method_11654((class_2769)entry.getValue())).booleanValue()) {
                directions.add(mirror.method_10343(entry.getKey()));
            }
            state = (class_2680)state.method_11657((class_2769)entry.getValue(), (Comparable)Boolean.valueOf(false));
        }
        for (class_2350 direction : directions) {
            state = (class_2680)state.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH, EAST, SOUTH, WEST, ROTATED, WATERLOGGED});
    }

    @NotNull
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public FurnitureBlock.Type getType() {
        return FurnitureBlock.Type.TABLE;
    }
}

