/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.fluid;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.fluid.fabric.SoftFluidInternalImpl;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SoftFluidInternal {
    private static final WeakHashMap<class_5455, Map<class_3611, class_6880<SoftFluid>>> FLUID_MAP = new WeakHashMap();
    private static final WeakHashMap<class_5455, Map<class_1792, class_6880<SoftFluid>>> ITEM_MAP = new WeakHashMap();

    public static class_6880<SoftFluid> fromVanillaFluid(class_3611 fluid, class_5455 registryAccess) {
        if (!FLUID_MAP.containsKey(registryAccess)) {
            SoftFluidInternal.populateSlaveMaps(registryAccess);
        }
        return FLUID_MAP.get(registryAccess).get(fluid);
    }

    public static class_6880<SoftFluid> fromVanillaItem(class_1792 item, class_5455 registryAccess) {
        if (!ITEM_MAP.containsKey(registryAccess)) {
            SoftFluidInternal.populateSlaveMaps(registryAccess);
        }
        return ITEM_MAP.get(registryAccess).get(item);
    }

    private static void populateSlaveMaps(class_5455 registryAccess) {
        Map fluidMap = FLUID_MAP.computeIfAbsent(registryAccess, k -> new IdentityHashMap());
        Map itemMap = ITEM_MAP.computeIfAbsent(registryAccess, k -> new IdentityHashMap());
        fluidMap.clear();
        itemMap.clear();
        for (class_6880.class_6883<SoftFluid> h : SoftFluidRegistry.getHolders()) {
            SoftFluid s = (SoftFluid)h.comp_349();
            if (!s.isEnabled()) continue;
            s.getEquivalentFluids().forEach(f -> fluidMap.put(f, h));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != class_1802.field_8574 || !BuiltInSoftFluids.WATER.is((class_6880<SoftFluid>)h)) {
                    itemMap.put(i, h);
                }
            });
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        SoftFluidInternalImpl.init();
    }

    public static void postInitClient() {
        FLUID_MAP.clear();
        ITEM_MAP.clear();
        SoftFluidColors.refreshParticleColors(Utils.hackyGetRegistryAccess());
    }

    public static void onDataSyncToPlayer(class_3222 player, boolean isJoined) {
        if (isJoined) {
            ModMessages.CHANNEL.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
        }
    }

    public static void doPostInitServer(class_5455 reg) {
        SoftFluidInternal.populateSlaveMaps(reg);
        SoftFluidInternal.registerExistingVanillaFluids(FLUID_MAP.get(reg), ITEM_MAP.get(reg));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids(Map<class_3611, class_6880<SoftFluid>> fluidMap, Map<class_1792, class_6880<SoftFluid>> itemMap) {
        void var1_1;
        SoftFluidInternalImpl.registerExistingVanillaFluids(fluidMap, (Map<class_1792, class_6880<SoftFluid>>)var1_1);
    }
}

