/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.registry;

import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.betterx.bclib.api.v2.LifeCycleAPI;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.generator.map.hex.HexBiomeMap;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.config.Configs;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.cave.EmptyAuroraCaveBiome;
import org.betterx.betterend.world.biome.cave.EmptyEndCaveBiome;
import org.betterx.betterend.world.biome.cave.EmptySmaragdantCaveBiome;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;
import org.betterx.betterend.world.biome.cave.JadeCaveBiome;
import org.betterx.betterend.world.biome.cave.LushAuroraCaveBiome;
import org.betterx.betterend.world.biome.cave.LushSmaragdantCaveBiome;
import org.betterx.betterend.world.generator.GeneratorOptions;

public class EndBiomes {
    public static final BiomeAPI.BiomeType END_CAVE = new BiomeAPI.BiomeType("END_CAVE", BiomeAPI.BiomeType.END_IGNORE);
    public static BiomePicker CAVE_BIOMES = null;
    private static HexBiomeMap caveBiomeMap;
    private static long lastSeed;
    public static final class_5321<class_1959> AMBER_LAND;
    public static final class_5321<class_1959> BLOSSOMING_SPIRES;
    public static final class_5321<class_1959> CHORUS_FOREST;
    public static final class_5321<class_1959> FOGGY_MUSHROOMLAND;
    public static final class_5321<class_1959> GLOWING_GRASSLANDS;
    public static final class_5321<class_1959> LANTERN_WOODS;
    public static final class_5321<class_1959> MEGALAKE;
    public static final class_5321<class_1959> MEGALAKE_GROVE;
    public static final class_5321<class_1959> NEON_OASIS;
    public static final class_5321<class_1959> SHADOW_FOREST;
    public static final class_5321<class_1959> SULPHUR_SPRINGS;
    public static final class_5321<class_1959> UMBRELLA_JUNGLE;

    private static class_5321<class_1959> cKey(String path) {
        return class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)BetterEnd.makeID(path));
    }

    public static void register() {
        BCLBiomeRegistry.registerBiomeCodec((class_2960)BetterEnd.makeID("biome"), EndBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((class_2960)BetterEnd.makeID("cave_biome"), EndCaveBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((class_2960)BetterEnd.makeID("empty_aurora_cave_biome"), EmptyAuroraCaveBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((class_2960)BetterEnd.makeID("empty_end_cave_biome"), EmptyEndCaveBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((class_2960)BetterEnd.makeID("empty_smaragdant_cave_biome"), EmptySmaragdantCaveBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((class_2960)BetterEnd.makeID("jade_cave_biome"), JadeCaveBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((class_2960)BetterEnd.makeID("lush_aurora_cave_biome"), LushAuroraCaveBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((class_2960)BetterEnd.makeID("lush_smaragdant_cave_biome"), LushSmaragdantCaveBiome.KEY_CODEC);
        LifeCycleAPI.onLevelLoad(EndBiomes::onWorldLoad);
    }

    private static void onWorldLoad(class_3218 level, long seed, class_2378<class_1959> registry) {
        if (CAVE_BIOMES == null || EndBiomes.CAVE_BIOMES.biomeRegistry != registry) {
            CAVE_BIOMES = new BiomePicker(registry);
            registry.method_10220().filter(biome -> registry.method_29113(biome).isPresent()).map(biome -> registry.method_40290((class_5321)registry.method_29113(biome).get())).map(biome -> ((class_5321)biome.method_40230().orElseThrow()).method_29177()).filter(id -> BiomeAPI.wasRegisteredAs((class_2960)id, (BiomeAPI.BiomeType)END_CAVE)).map(BiomeAPI::getBiome).filter(bcl -> !BCLBiomeRegistry.isEmptyBiome((BCLBiome)bcl)).forEach(arg_0 -> ((BiomePicker)CAVE_BIOMES).addBiome(arg_0));
            CAVE_BIOMES.rebuild();
            caveBiomeMap = null;
        }
        if (caveBiomeMap == null || lastSeed != seed) {
            caveBiomeMap = new HexBiomeMap(seed, GeneratorOptions.getBiomeSizeCaves(), CAVE_BIOMES);
            lastSeed = seed;
        }
    }

    public static EndBiome registerSubBiomeIntegration(EndBiome.Config biomeConfig) {
        return EndBiome.create(biomeConfig, BiomeAPI.BiomeType.END_LAND);
    }

    public static void addSubBiomeIntegration(EndBiome biome, class_2960 parent) {
        BCLBiome parentBiome;
        if (Configs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true) && !BCLBiomeRegistry.isEmptyBiome((BCLBiome)(parentBiome = BiomeAPI.getBiome((class_2960)parent))) && biome.getParentBiome().getID().equals((Object)biome.getID())) {
            parentBiome.addSubBiome((BCLBiome)biome);
        }
    }

    public static BiomePicker.ActualBiome getCaveBiome(int x, int z) {
        return caveBiomeMap.getBiome((double)x, 5.0, (double)z);
    }

    static {
        AMBER_LAND = EndBiomes.cKey("amber_land");
        BLOSSOMING_SPIRES = EndBiomes.cKey("blossoming_spires");
        CHORUS_FOREST = EndBiomes.cKey("chorus_forest");
        FOGGY_MUSHROOMLAND = EndBiomes.cKey("foggy_mushroomland");
        GLOWING_GRASSLANDS = EndBiomes.cKey("glowing_grasslands");
        LANTERN_WOODS = EndBiomes.cKey("lantern_woods");
        MEGALAKE = EndBiomes.cKey("megalake");
        MEGALAKE_GROVE = EndBiomes.cKey("megalake_grove");
        NEON_OASIS = EndBiomes.cKey("neon_oasis");
        SHADOW_FOREST = EndBiomes.cKey("shadow_forest");
        SULPHUR_SPRINGS = EndBiomes.cKey("sulphur_springs");
        UMBRELLA_JUNGLE = EndBiomes.cKey("umbrella_jungle");
    }
}

