/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.crank.ValveHandleBlock;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CKinetics;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

public class KineticStats
implements TooltipModifier {
    protected final class_2248 block;

    public KineticStats(class_2248 block) {
        this.block = block;
    }

    @Nullable
    public static KineticStats create(class_1792 item) {
        class_1747 blockItem;
        class_2248 block;
        if (item instanceof class_1747 && ((block = (blockItem = (class_1747)item).method_7711()) instanceof IRotate || block instanceof SteamEngineBlock)) {
            return new KineticStats(block);
        }
        return null;
    }

    @Override
    public void modify(class_1799 stack, class_1657 player, class_1836 flags, List<class_2561> tooltip) {
        List<class_2561> kineticStats = KineticStats.getKineticStats(this.block, player);
        if (!kineticStats.isEmpty()) {
            tooltip.add(class_5244.field_39003);
            tooltip.addAll(kineticStats);
        }
    }

    public static List<class_2561> getKineticStats(class_2248 block, class_1657 player) {
        boolean hasStressCapacity;
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        CKinetics config = AllConfigs.server().kinetics;
        LangBuilder rpmUnit = CreateLang.translate("generic.unit.rpm", new Object[0]);
        LangBuilder suUnit = CreateLang.translate("generic.unit.stress", new Object[0]);
        boolean hasGoggles = GogglesItem.isWearingGoggles(player);
        boolean showStressImpact = block instanceof IRotate ? !((IRotate)block).hideStressImpact() : true;
        if (block instanceof ValveHandleBlock) {
            block = (class_2248)AllBlocks.COPPER_VALVE_HANDLE.get();
        }
        boolean hasStressImpact = IRotate.StressImpact.isEnabled() && showStressImpact && BlockStressValues.getImpact(block) > 0.0;
        boolean bl = hasStressCapacity = IRotate.StressImpact.isEnabled() && BlockStressValues.getCapacity(block) > 0.0;
        if (hasStressImpact) {
            CreateLang.translate("tooltip.stressImpact", new Object[0]).style(class_124.field_1080).addTo(list);
            double impact = BlockStressValues.getImpact(block);
            IRotate.StressImpact impactId = impact >= (Double)config.highStressImpact.get() ? IRotate.StressImpact.HIGH : (impact >= (Double)config.mediumStressImpact.get() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.LOW);
            LangBuilder builder = CreateLang.builder().add(CreateLang.text(TooltipHelper.makeProgressBar(3, impactId.ordinal() + 1)).style(impactId.getAbsoluteColor()));
            if (hasGoggles) {
                builder.add(CreateLang.number(impact)).text("x ").add(rpmUnit).addTo(list);
            } else {
                builder.translate("tooltip.stressImpact." + Lang.asId((String)impactId.name()), new Object[0]).addTo(list);
            }
        }
        if (hasStressCapacity) {
            CreateLang.translate("tooltip.capacityProvided", new Object[0]).style(class_124.field_1080).addTo(list);
            double capacity = BlockStressValues.getCapacity(block);
            BlockStressValues.GeneratedRpm generatedRPM = BlockStressValues.RPM.get(block);
            IRotate.StressImpact impactId = capacity >= (Double)config.highCapacity.get() ? IRotate.StressImpact.HIGH : (capacity >= (Double)config.mediumCapacity.get() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.LOW);
            IRotate.StressImpact opposite = IRotate.StressImpact.values()[IRotate.StressImpact.values().length - 2 - impactId.ordinal()];
            LangBuilder builder = CreateLang.builder().add(CreateLang.text(TooltipHelper.makeProgressBar(3, impactId.ordinal() + 1)).style(opposite.getAbsoluteColor()));
            if (hasGoggles) {
                builder.add(CreateLang.number(capacity)).text("x ").add(rpmUnit).addTo(list);
                if (generatedRPM != null) {
                    LangBuilder amount = CreateLang.number(capacity * (double)generatedRPM.value()).add(suUnit);
                    CreateLang.text(" -> ").add(generatedRPM.mayGenerateLess() ? CreateLang.translate("tooltip.up_to", amount) : amount).style(class_124.field_1063).addTo(list);
                }
            } else {
                builder.translate("tooltip.capacityProvided." + Lang.asId((String)impactId.name()), new Object[0]).addTo(list);
            }
        }
        return list;
    }
}

