/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.bogey;

import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.foundation.blockEntity.CachedRenderBBBlockEntity;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBogeyBlockEntity
extends CachedRenderBBBlockEntity {
    public static final String BOGEY_STYLE_KEY = "BogeyStyle";
    public static final String BOGEY_DATA_KEY = "BogeyData";
    private class_2487 bogeyData;
    LerpedFloat virtualAnimation = LerpedFloat.angular();

    public AbstractBogeyBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public abstract BogeyStyle getDefaultStyle();

    public class_2487 getBogeyData() {
        if (this.bogeyData == null || !this.bogeyData.method_10545(BOGEY_STYLE_KEY)) {
            this.bogeyData = this.createBogeyData();
        }
        return this.bogeyData;
    }

    public void setBogeyData(@NotNull class_2487 newData) {
        if (!newData.method_10545(BOGEY_STYLE_KEY)) {
            class_2960 style = this.getDefaultStyle().id;
            NBTHelper.writeResourceLocation((class_2487)newData, (String)BOGEY_STYLE_KEY, (class_2960)style);
        }
        this.bogeyData = newData;
    }

    public void setBogeyStyle(@NotNull BogeyStyle style) {
        class_2960 location = style.id;
        class_2487 data = this.getBogeyData();
        NBTHelper.writeResourceLocation((class_2487)data, (String)BOGEY_STYLE_KEY, (class_2960)location);
        this.markUpdated();
    }

    @NotNull
    public BogeyStyle getStyle() {
        class_2487 data = this.getBogeyData();
        class_2960 currentStyle = NBTHelper.readResourceLocation((class_2487)data, (String)BOGEY_STYLE_KEY);
        BogeyStyle style = AllBogeyStyles.BOGEY_STYLES.get(currentStyle);
        if (style == null) {
            this.setBogeyStyle(this.getDefaultStyle());
            return this.getStyle();
        }
        return style;
    }

    protected void method_11007(@NotNull class_2487 pTag) {
        class_2487 data = this.getBogeyData();
        if (data != null) {
            pTag.method_10566(BOGEY_DATA_KEY, (class_2520)data);
        }
        super.method_11007(pTag);
    }

    public void method_11014(class_2487 pTag) {
        this.bogeyData = pTag.method_10545(BOGEY_DATA_KEY) ? pTag.method_10562(BOGEY_DATA_KEY) : this.createBogeyData();
        super.method_11014(pTag);
    }

    private class_2487 createBogeyData() {
        class_2487 nbt = new class_2487();
        NBTHelper.writeResourceLocation((class_2487)nbt, (String)BOGEY_STYLE_KEY, (class_2960)this.getDefaultStyle().id);
        boolean upsideDown = false;
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogeyBlock = (AbstractBogeyBlock)class_22482;
            upsideDown = bogeyBlock.isUpsideDown(this.method_11010());
        }
        nbt.method_10556("UpsideDown", upsideDown);
        return nbt;
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(2.0);
    }

    public float getVirtualAngle(float partialTicks) {
        return this.virtualAnimation.getValue(partialTicks);
    }

    public void animate(float distanceMoved) {
        class_2680 blockState = this.method_11010();
        class_2248 class_22482 = blockState.method_26204();
        if (!(class_22482 instanceof AbstractBogeyBlock)) {
            return;
        }
        AbstractBogeyBlock type = (AbstractBogeyBlock)class_22482;
        double angleDiff = (double)(360.0f * distanceMoved) / (Math.PI * 2 * type.getWheelRadius());
        double newWheelAngle = ((double)this.virtualAnimation.getValue() - angleDiff) % 360.0;
        this.virtualAnimation.setValue(newWheelAngle);
    }

    private void markUpdated() {
        this.method_5431();
        class_1937 level = this.method_10997();
        if (level != null) {
            level.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }
}

