/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.clipboard;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.clipboard.ClipboardBlock;
import com.simibubi.create.content.equipment.clipboard.ClipboardScreen;
import com.simibubi.create.content.logistics.AddressEditBoxHelper;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ClipboardBlockEntity
extends SmartBlockEntity {
    public class_1799 dataContainer = AllBlocks.CLIPBOARD.asStack();
    private UUID lastEdit;

    public ClipboardBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateWrittenState();
    }

    public void onEditedBy(class_1657 player) {
        this.lastEdit = player.method_5667();
        this.notifyUpdate();
        this.updateWrittenState();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.method_8608()) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> this::advertiseToAddressHelper);
        }
    }

    public void updateWrittenState() {
        boolean shouldBeWritten;
        class_2680 blockState = this.method_11010();
        if (!AllBlocks.CLIPBOARD.has(blockState)) {
            return;
        }
        if (this.field_11863.method_8608()) {
            return;
        }
        boolean isWritten = (Boolean)blockState.method_11654((class_2769)ClipboardBlock.WRITTEN);
        boolean bl = shouldBeWritten = this.dataContainer.method_7969() != null;
        if (isWritten == shouldBeWritten) {
            return;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)blockState.method_11657((class_2769)ClipboardBlock.WRITTEN, (Comparable)Boolean.valueOf(shouldBeWritten)));
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10566("Item", NBTSerializer.serializeNBT((Object)this.dataContainer));
        if (clientPacket && this.lastEdit != null) {
            tag.method_25927("LastEdit", this.lastEdit);
        }
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.dataContainer = class_1799.method_7915((class_2487)tag.method_10562("Item"));
        if (!AllBlocks.CLIPBOARD.isIn(this.dataContainer)) {
            this.dataContainer = AllBlocks.CLIPBOARD.asStack();
        }
        if (clientPacket) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.readClientSide(tag));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void readClientSide(class_2487 tag) {
        class_310 mc = class_310.method_1551();
        class_437 class_4372 = mc.field_1755;
        if (!(class_4372 instanceof ClipboardScreen)) {
            return;
        }
        ClipboardScreen cs = (ClipboardScreen)class_4372;
        if (tag.method_10545("LastEdit") && tag.method_25926("LastEdit").equals(mc.field_1724.method_5667())) {
            return;
        }
        if (!this.field_11867.equals((Object)cs.targetedBlock)) {
            return;
        }
        cs.reopenWith(this.dataContainer);
    }

    @Environment(value=EnvType.CLIENT)
    private void advertiseToAddressHelper() {
        AddressEditBoxHelper.advertiseClipboard(this);
    }
}

