/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.render;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ClientContraption;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.render.BlockEntityRenderHelper;
import com.simibubi.create.foundation.utility.fabric.SingleRenderTypeSbbBuilder;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.BitSet;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.client.render.model.BakedModelBufferer;
import net.createmod.catnip.client.render.model.ShadeSeparatedResultConsumer;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_2688;
import net.minecraft.class_2960;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.apache.commons.lang3.tuple.Pair;

public class ContraptionEntityRenderer<C extends AbstractContraptionEntity>
extends class_897<C> {
    public static final SuperByteBufferCache.Compartment<Pair<Contraption, class_1921>> CONTRAPTION = new SuperByteBufferCache.Compartment();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    public ContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public static SuperByteBuffer getBuffer(Contraption contraption, VirtualRenderWorld renderWorld, class_1921 renderType) {
        return SuperByteBufferCache.getInstance().get(CONTRAPTION, (Object)Pair.of((Object)contraption, (Object)renderType), () -> ContraptionEntityRenderer.buildStructureBuffer(contraption, renderWorld, renderType));
    }

    private static SuperByteBuffer buildStructureBuffer(Contraption contraption, VirtualRenderWorld renderWorld, class_1921 layer) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        class_4587 poseStack = objects.poseStack;
        ClientContraption clientContraption = contraption.getOrCreateClientContraptionLazy();
        ClientContraption.RenderedBlocks blocks = clientContraption.getRenderedBlocks();
        SingleRenderTypeSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.prepare(layer);
        BakedModelBufferer.bufferBlocks(blocks.positions().iterator(), (class_1920)renderWorld, (class_4587)poseStack, (boolean)true, (ShadeSeparatedResultConsumer)sbbBuilder);
        return sbbBuilder.build();
    }

    public class_2960 getTextureLocation(C entity) {
        return null;
    }

    public boolean shouldRender(C entity, class_4604 frustum, double cameraX, double cameraY, double cameraZ) {
        if (((AbstractContraptionEntity)((Object)entity)).getContraption() == null) {
            return false;
        }
        if (!((AbstractContraptionEntity)((Object)entity)).isAliveOrStale()) {
            return false;
        }
        if (!((AbstractContraptionEntity)((Object)entity)).isReadyForRender()) {
            return false;
        }
        return super.method_3933(entity, frustum, cameraX, cameraY, cameraZ);
    }

    public void render(C entity, float yaw, float partialTicks, class_4587 poseStack, class_4597 buffers, int overlay) {
        super.method_3936(entity, yaw, partialTicks, poseStack, buffers, overlay);
        Contraption contraption = ((AbstractContraptionEntity)((Object)entity)).getContraption();
        if (contraption == null) {
            return;
        }
        class_1937 level = entity.method_37908();
        ClientContraption clientContraption = contraption.getOrCreateClientContraptionLazy();
        VirtualRenderWorld renderWorld = clientContraption.getRenderLevel();
        ContraptionMatrices matrices = clientContraption.getMatrices();
        matrices.setup(poseStack, (AbstractContraptionEntity)((Object)entity));
        if (!VisualizationManager.supportsVisualization((class_1936)level)) {
            for (class_1921 renderType : class_1921.method_22720()) {
                SuperByteBuffer sbb = ContraptionEntityRenderer.getBuffer(contraption, renderWorld, renderType);
                if (sbb.isEmpty()) continue;
                class_4588 vc = buffers.getBuffer(renderType);
                ((SuperByteBuffer)sbb.transform(matrices.getModel())).useLevelLight((class_1920)level, matrices.getWorld()).renderInto(poseStack, vc);
            }
        }
        BitSet adjustRenderedBlockEntities = clientContraption.getAndAdjustShouldRenderBlockEntities();
        clientContraption.scratchErroredBlockEntities.clear();
        BlockEntityRenderHelper.renderBlockEntities(clientContraption.renderedBlockEntityView, adjustRenderedBlockEntities, clientContraption.scratchErroredBlockEntities, renderWorld, level, matrices.getModelViewProjection(), matrices.getLight(), buffers, AnimationTickHolder.getPartialTicks());
        clientContraption.shouldRenderBlockEntities.andNot(clientContraption.scratchErroredBlockEntities);
        ContraptionEntityRenderer.renderActors(level, renderWorld, contraption, matrices, buffers);
        matrices.clear();
    }

    private static void renderActors(class_1937 level, VirtualRenderWorld renderWorld, Contraption c, ContraptionMatrices matrices, class_4597 buffer) {
        class_4587 m = matrices.getModel();
        for (Pair pair : c.getActors()) {
            class_3499.class_3501 blockInfo;
            MovementBehaviour movementBehaviour;
            MovementContext context = (MovementContext)pair.getRight();
            if (context == null) continue;
            if (context.world == null) {
                context.world = level;
            }
            if ((movementBehaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)(blockInfo = (class_3499.class_3501)pair.getLeft()).comp_1342())) == null || c.isHiddenInPortal(blockInfo.comp_1341())) continue;
            m.method_22903();
            TransformStack.of((class_4587)m).translate((class_2382)blockInfo.comp_1341());
            movementBehaviour.renderInContraption(context, renderWorld, matrices, buffer);
            m.method_22909();
        }
    }

    private static class ThreadLocalObjects {
        public final class_4587 poseStack = new class_4587();
        public final SingleRenderTypeSbbBuilder sbbBuilder = new SingleRenderTypeSbbBuilder();

        private ThreadLocalObjects() {
        }
    }
}

