/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.bearing;

import com.simibubi.create.AllContraptionTypes;
import com.simibubi.create.api.contraption.ContraptionType;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import org.apache.commons.lang3.tuple.Pair;

public class ClockworkContraption
extends Contraption {
    protected class_2350 facing;
    public HandType handType;
    public int offset;
    private Set<class_2338> ignoreBlocks = new HashSet<class_2338>();

    @Override
    public ContraptionType getType() {
        return (ContraptionType)AllContraptionTypes.CLOCKWORK.comp_349();
    }

    private void ignoreBlocks(Set<class_2338> blocks, class_2338 anchor) {
        for (class_2338 blockPos : blocks) {
            this.ignoreBlocks.add(anchor.method_10081((class_2382)blockPos));
        }
    }

    @Override
    protected boolean isAnchoringBlockAt(class_2338 pos) {
        return pos.equals((Object)this.anchor.method_10079(this.facing.method_10153(), this.offset + 1));
    }

    public static Pair<ClockworkContraption, ClockworkContraption> assembleClockworkAt(class_1937 world, class_2338 pos, class_2350 direction) throws AssemblyException {
        int hourArmBlocks = 0;
        ClockworkContraption hourArm = new ClockworkContraption();
        ClockworkContraption minuteArm = null;
        hourArm.facing = direction;
        hourArm.handType = HandType.HOUR;
        if (!hourArm.assemble(world, pos)) {
            return null;
        }
        for (int i = 0; i < 16; ++i) {
            class_2338 offsetPos = class_2338.field_10980.method_10079(direction, i);
            if (hourArm.getBlocks().containsKey(offsetPos)) continue;
            hourArmBlocks = i;
            break;
        }
        if (hourArmBlocks > 0) {
            minuteArm = new ClockworkContraption();
            minuteArm.facing = direction;
            minuteArm.handType = HandType.MINUTE;
            minuteArm.offset = hourArmBlocks;
            minuteArm.ignoreBlocks(hourArm.getBlocks().keySet(), hourArm.anchor);
            if (!minuteArm.assemble(world, pos)) {
                return null;
            }
            if (minuteArm.getBlocks().isEmpty()) {
                minuteArm = null;
            }
        }
        hourArm.startMoving(world);
        hourArm.expandBoundsAroundAxis(direction.method_10166());
        if (minuteArm != null) {
            minuteArm.startMoving(world);
            minuteArm.expandBoundsAroundAxis(direction.method_10166());
        }
        return Pair.of((Object)hourArm, (Object)minuteArm);
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        return this.searchMovedStructure(world, pos, this.facing);
    }

    @Override
    public boolean searchMovedStructure(class_1937 world, class_2338 pos, class_2350 direction) throws AssemblyException {
        return super.searchMovedStructure(world, pos.method_10079(direction, this.offset + 1), null);
    }

    @Override
    protected boolean moveBlock(class_1937 world, class_2350 direction, Queue<class_2338> frontier, Set<class_2338> visited) throws AssemblyException {
        if (this.ignoreBlocks.contains(frontier.peek())) {
            frontier.poll();
            return true;
        }
        return super.moveBlock(world, direction, frontier, visited);
    }

    @Override
    public class_2487 writeNBT(boolean spawnPacket) {
        class_2487 tag = super.writeNBT(spawnPacket);
        tag.method_10569("facing", this.facing.method_10146());
        tag.method_10569("offset", this.offset);
        NBTHelper.writeEnum((class_2487)tag, (String)"HandType", (Enum)this.handType);
        return tag;
    }

    @Override
    public void readNBT(class_1937 world, class_2487 tag, boolean spawnData) {
        this.facing = class_2350.method_10143((int)tag.method_10550("facing"));
        this.handType = (HandType)NBTHelper.readEnum((class_2487)tag, (String)"HandType", HandType.class);
        this.offset = tag.method_10550("offset");
        super.readNBT(world, tag, spawnData);
    }

    @Override
    public boolean canBeStabilized(class_2350 facing, class_2338 localPos) {
        if (class_2338.field_10980.equals((Object)localPos) || class_2338.field_10980.equals((Object)localPos.method_10093(facing))) {
            return false;
        }
        return facing.method_10166() == this.facing.method_10166();
    }

    public static enum HandType {
        HOUR,
        MINUTE;

    }
}

