/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei;

import com.simibubi.create.AllMenuTypes;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.CraftableBigItemStack;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.library.transfer.RecipeTransferErrorMissingSlots;
import mezz.jei.library.transfer.RecipeTransferErrorTooltip;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_6328;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class StockKeeperTransferHandler
implements IRecipeTransferHandler<StockKeeperRequestMenu, Object> {
    private IJeiHelpers helpers;

    public StockKeeperTransferHandler(IJeiHelpers helpers) {
        this.helpers = helpers;
    }

    public Class<? extends StockKeeperRequestMenu> getContainerClass() {
        return StockKeeperRequestMenu.class;
    }

    public Optional<class_3917<StockKeeperRequestMenu>> getMenuType() {
        return Optional.of((class_3917)AllMenuTypes.STOCK_KEEPER_REQUEST.get());
    }

    public RecipeType<Object> getRecipeType() {
        return null;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(StockKeeperRequestMenu container, Object object, IRecipeSlotsView recipeSlots, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        class_1937 level = player.method_37908();
        if (!(object instanceof class_1860)) {
            return null;
        }
        class_1860 recipe = (class_1860)object;
        MutableObject result = new MutableObject();
        if (level.method_8608()) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> result.setValue((Object)this.transferRecipeOnClient(container, recipe, recipeSlots, player, maxTransfer, doTransfer)));
        }
        return (IRecipeTransferError)result.getValue();
    }

    @Nullable
    private IRecipeTransferError transferRecipeOnClient(StockKeeperRequestMenu container, class_1860<?> recipe, IRecipeSlotsView recipeSlots, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        Iterator<CraftableBigItemStack> iterator = container.screenReference;
        if (!(iterator instanceof StockKeeperRequestScreen)) {
            return RecipeTransferErrorInternal.INSTANCE;
        }
        StockKeeperRequestScreen screen = (StockKeeperRequestScreen)((Object)iterator);
        if (recipe.method_8117().size() > 9) {
            return RecipeTransferErrorInternal.INSTANCE;
        }
        for (CraftableBigItemStack cbis : screen.recipesToOrder) {
            if (cbis.recipe != recipe) continue;
            return new RecipeTransferErrorTooltip((class_2561)CreateLang.translate("gui.stock_keeper.already_ordering_recipe", new Object[0]).component());
        }
        if (screen.itemsToOrder.size() >= 9) {
            return new RecipeTransferErrorTooltip((class_2561)CreateLang.translate("gui.stock_keeper.slots_full", new Object[0]).component());
        }
        InventorySummary summary = ((StockTickerBlockEntity)((StockKeeperRequestMenu)screen.method_17577()).contentHolder).getLastClientsideStockSnapshotAsSummary();
        if (summary == null) {
            return RecipeTransferErrorInternal.INSTANCE;
        }
        RecipeWrapper outputDummy = new RecipeWrapper(new ItemStackHandler(9));
        ArrayList<class_1735> craftingSlots = new ArrayList<class_1735>();
        for (int i = 0; i < outputDummy.method_5439(); ++i) {
            craftingSlots.add(new class_1735((class_1263)outputDummy, i, 0, 0));
        }
        List<BigItemStack> stacksByCount = summary.getStacksByCount();
        RecipeWrapper inputDummy = new RecipeWrapper(new ItemStackHandler(stacksByCount.size()));
        HashMap<class_1735, class_1799> availableItemStacks = new HashMap<class_1735, class_1799>();
        for (int j = 0; j < stacksByCount.size(); ++j) {
            BigItemStack bigItemStack = stacksByCount.get(j);
            availableItemStacks.put(new class_1735((class_1263)inputDummy, j, 0, 0), bigItemStack.stack.method_46651(bigItemStack.count));
        }
        RecipeTransferOperationsResult transferOperations = RecipeTransferUtil.getRecipeTransferOperations((IStackHelper)this.helpers.getStackHelper(), availableItemStacks, (List)recipeSlots.getSlotViews(RecipeIngredientRole.INPUT), craftingSlots);
        if (!transferOperations.missingItems.isEmpty()) {
            return new RecipeTransferErrorMissingSlots((class_2561)CreateLang.translate("gui.stock_keeper.not_in_stock", new Object[0]).component(), (Collection)transferOperations.missingItems);
        }
        if (!doTransfer) {
            return null;
        }
        class_1799 result = recipe.method_8110(player.method_37908().method_30349());
        if (result.method_7960()) {
            return new RecipeTransferErrorTooltip((class_2561)CreateLang.translate("gui.stock_keeper.recipe_result_empty", new Object[0]).component());
        }
        CraftableBigItemStack cbis = new CraftableBigItemStack(result, recipe);
        screen.recipesToOrder.add(cbis);
        screen.searchBox.method_1852("");
        screen.refreshSearchNextTick = true;
        screen.requestCraftable(cbis, maxTransfer ? cbis.stack.method_7914() : 1);
        return null;
    }
}

